/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PluggableDatabaseNodeLevelDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="nodeName")
    private final String nodeName;
    @JsonProperty(value="openMode")
    private final OpenMode openMode;

    @Deprecated
    @ConstructorProperties(value={"nodeName", "openMode"})
    public PluggableDatabaseNodeLevelDetails(String nodeName, OpenMode openMode) {
        this.nodeName = nodeName;
        this.openMode = openMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public OpenMode getOpenMode() {
        return this.openMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PluggableDatabaseNodeLevelDetails(");
        sb.append("super=").append(super.toString());
        sb.append("nodeName=").append(String.valueOf(this.nodeName));
        sb.append(", openMode=").append(String.valueOf((Object)this.openMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluggableDatabaseNodeLevelDetails)) {
            return false;
        }
        PluggableDatabaseNodeLevelDetails other = (PluggableDatabaseNodeLevelDetails)((Object)o);
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals((Object)this.openMode, (Object)other.openMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nodeName == null ? 43 : this.nodeName.hashCode());
        result = result * 59 + (this.openMode == null ? 43 : this.openMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OpenMode implements BmcEnum
    {
        ReadOnly("READ_ONLY"),
        ReadWrite("READ_WRITE"),
        Mounted("MOUNTED"),
        Migrate("MIGRATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OpenMode> map;

        private OpenMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OpenMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OpenMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OpenMode.class);
            map = new HashMap<String, OpenMode>();
            for (OpenMode v : OpenMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="nodeName")
        private String nodeName;
        @JsonProperty(value="openMode")
        private OpenMode openMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            this.__explicitlySet__.add("nodeName");
            return this;
        }

        public Builder openMode(OpenMode openMode) {
            this.openMode = openMode;
            this.__explicitlySet__.add("openMode");
            return this;
        }

        public PluggableDatabaseNodeLevelDetails build() {
            PluggableDatabaseNodeLevelDetails model = new PluggableDatabaseNodeLevelDetails(this.nodeName, this.openMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PluggableDatabaseNodeLevelDetails model) {
            if (model.wasPropertyExplicitlySet("nodeName")) {
                this.nodeName(model.getNodeName());
            }
            if (model.wasPropertyExplicitlySet("openMode")) {
                this.openMode(model.getOpenMode());
            }
            return this;
        }
    }
}

