/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.CloudAutomationUpdateDetails;
import com.oracle.bmc.database.model.DataCollectionOptions;
import com.oracle.bmc.database.model.ExadataIormConfig;
import com.oracle.bmc.database.model.FileSystemConfigurationDetail;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloudVmCluster
extends ExplicitlySetBmcModel {
    @JsonProperty(value="iormConfigCache")
    private final ExadataIormConfig iormConfigCache;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="subscriptionId")
    private final String subscriptionId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="backupSubnetId")
    private final String backupSubnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="backupNetworkNsgIds")
    private final List<String> backupNetworkNsgIds;
    @JsonProperty(value="lastUpdateHistoryEntryId")
    private final String lastUpdateHistoryEntryId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="listenerPort")
    private final Long listenerPort;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="storageSizeInGBs")
    private final Integer storageSizeInGBs;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="ocpuCount")
    private final Float ocpuCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="dbNodeStorageSizeInGBs")
    private final Integer dbNodeStorageSizeInGBs;
    @JsonProperty(value="dataStorageSizeInTBs")
    private final Double dataStorageSizeInTBs;
    @JsonProperty(value="dbServers")
    private final List<String> dbServers;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="dataStoragePercentage")
    private final Integer dataStoragePercentage;
    @JsonProperty(value="isLocalBackupEnabled")
    private final Boolean isLocalBackupEnabled;
    @JsonProperty(value="cloudExadataInfrastructureId")
    private final String cloudExadataInfrastructureId;
    @JsonProperty(value="isSparseDiskgroupEnabled")
    private final Boolean isSparseDiskgroupEnabled;
    @JsonProperty(value="giVersion")
    private final String giVersion;
    @JsonProperty(value="systemVersion")
    private final String systemVersion;
    @JsonProperty(value="sshPublicKeys")
    private final List<String> sshPublicKeys;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="diskRedundancy")
    private final DiskRedundancy diskRedundancy;
    @JsonProperty(value="scanIpIds")
    private final List<String> scanIpIds;
    @JsonProperty(value="vipIds")
    private final List<String> vipIds;
    @JsonProperty(value="scanIpv6Ids")
    private final List<String> scanIpv6Ids;
    @JsonProperty(value="vipv6Ids")
    private final List<String> vipv6Ids;
    @JsonProperty(value="scanDnsRecordId")
    private final String scanDnsRecordId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="securityAttributes")
    private final Map<String, Map<String, Object>> securityAttributes;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="scanDnsName")
    private final String scanDnsName;
    @JsonProperty(value="zoneId")
    private final String zoneId;
    @JsonProperty(value="scanListenerPortTcp")
    private final Integer scanListenerPortTcp;
    @JsonProperty(value="scanListenerPortTcpSsl")
    private final Integer scanListenerPortTcpSsl;
    @JsonProperty(value="dataCollectionOptions")
    private final DataCollectionOptions dataCollectionOptions;
    @JsonProperty(value="giSoftwareImageId")
    private final String giSoftwareImageId;
    @JsonProperty(value="fileSystemConfigurationDetails")
    private final List<FileSystemConfigurationDetail> fileSystemConfigurationDetails;
    @JsonProperty(value="cloudAutomationUpdateDetails")
    private final CloudAutomationUpdateDetails cloudAutomationUpdateDetails;
    @JsonProperty(value="vmClusterType")
    private final VmClusterType vmClusterType;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;

    @Deprecated
    @ConstructorProperties(value={"iormConfigCache", "id", "compartmentId", "subscriptionId", "availabilityDomain", "subnetId", "backupSubnetId", "nsgIds", "backupNetworkNsgIds", "lastUpdateHistoryEntryId", "shape", "listenerPort", "lifecycleState", "nodeCount", "storageSizeInGBs", "displayName", "timeCreated", "lifecycleDetails", "timeZone", "hostname", "domain", "cpuCoreCount", "ocpuCount", "memorySizeInGBs", "dbNodeStorageSizeInGBs", "dataStorageSizeInTBs", "dbServers", "clusterName", "dataStoragePercentage", "isLocalBackupEnabled", "cloudExadataInfrastructureId", "isSparseDiskgroupEnabled", "giVersion", "systemVersion", "sshPublicKeys", "licenseModel", "diskRedundancy", "scanIpIds", "vipIds", "scanIpv6Ids", "vipv6Ids", "scanDnsRecordId", "freeformTags", "definedTags", "securityAttributes", "systemTags", "scanDnsName", "zoneId", "scanListenerPortTcp", "scanListenerPortTcpSsl", "dataCollectionOptions", "giSoftwareImageId", "fileSystemConfigurationDetails", "cloudAutomationUpdateDetails", "vmClusterType", "computeModel"})
    public CloudVmCluster(ExadataIormConfig iormConfigCache, String id, String compartmentId, String subscriptionId, String availabilityDomain, String subnetId, String backupSubnetId, List<String> nsgIds, List<String> backupNetworkNsgIds, String lastUpdateHistoryEntryId, String shape, Long listenerPort, LifecycleState lifecycleState, Integer nodeCount, Integer storageSizeInGBs, String displayName, Date timeCreated, String lifecycleDetails, String timeZone, String hostname, String domain, Integer cpuCoreCount, Float ocpuCount, Integer memorySizeInGBs, Integer dbNodeStorageSizeInGBs, Double dataStorageSizeInTBs, List<String> dbServers, String clusterName, Integer dataStoragePercentage, Boolean isLocalBackupEnabled, String cloudExadataInfrastructureId, Boolean isSparseDiskgroupEnabled, String giVersion, String systemVersion, List<String> sshPublicKeys, LicenseModel licenseModel, DiskRedundancy diskRedundancy, List<String> scanIpIds, List<String> vipIds, List<String> scanIpv6Ids, List<String> vipv6Ids, String scanDnsRecordId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> securityAttributes, Map<String, Map<String, Object>> systemTags, String scanDnsName, String zoneId, Integer scanListenerPortTcp, Integer scanListenerPortTcpSsl, DataCollectionOptions dataCollectionOptions, String giSoftwareImageId, List<FileSystemConfigurationDetail> fileSystemConfigurationDetails, CloudAutomationUpdateDetails cloudAutomationUpdateDetails, VmClusterType vmClusterType, ComputeModel computeModel) {
        this.iormConfigCache = iormConfigCache;
        this.id = id;
        this.compartmentId = compartmentId;
        this.subscriptionId = subscriptionId;
        this.availabilityDomain = availabilityDomain;
        this.subnetId = subnetId;
        this.backupSubnetId = backupSubnetId;
        this.nsgIds = nsgIds;
        this.backupNetworkNsgIds = backupNetworkNsgIds;
        this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
        this.shape = shape;
        this.listenerPort = listenerPort;
        this.lifecycleState = lifecycleState;
        this.nodeCount = nodeCount;
        this.storageSizeInGBs = storageSizeInGBs;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.timeZone = timeZone;
        this.hostname = hostname;
        this.domain = domain;
        this.cpuCoreCount = cpuCoreCount;
        this.ocpuCount = ocpuCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        this.dbServers = dbServers;
        this.clusterName = clusterName;
        this.dataStoragePercentage = dataStoragePercentage;
        this.isLocalBackupEnabled = isLocalBackupEnabled;
        this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
        this.giVersion = giVersion;
        this.systemVersion = systemVersion;
        this.sshPublicKeys = sshPublicKeys;
        this.licenseModel = licenseModel;
        this.diskRedundancy = diskRedundancy;
        this.scanIpIds = scanIpIds;
        this.vipIds = vipIds;
        this.scanIpv6Ids = scanIpv6Ids;
        this.vipv6Ids = vipv6Ids;
        this.scanDnsRecordId = scanDnsRecordId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.securityAttributes = securityAttributes;
        this.systemTags = systemTags;
        this.scanDnsName = scanDnsName;
        this.zoneId = zoneId;
        this.scanListenerPortTcp = scanListenerPortTcp;
        this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
        this.dataCollectionOptions = dataCollectionOptions;
        this.giSoftwareImageId = giSoftwareImageId;
        this.fileSystemConfigurationDetails = fileSystemConfigurationDetails;
        this.cloudAutomationUpdateDetails = cloudAutomationUpdateDetails;
        this.vmClusterType = vmClusterType;
        this.computeModel = computeModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ExadataIormConfig getIormConfigCache() {
        return this.iormConfigCache;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getBackupSubnetId() {
        return this.backupSubnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public List<String> getBackupNetworkNsgIds() {
        return this.backupNetworkNsgIds;
    }

    public String getLastUpdateHistoryEntryId() {
        return this.lastUpdateHistoryEntryId;
    }

    public String getShape() {
        return this.shape;
    }

    public Long getListenerPort() {
        return this.listenerPort;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Integer getStorageSizeInGBs() {
        return this.storageSizeInGBs;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Float getOcpuCount() {
        return this.ocpuCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public Integer getDbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public Double getDataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public List<String> getDbServers() {
        return this.dbServers;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getDataStoragePercentage() {
        return this.dataStoragePercentage;
    }

    public Boolean getIsLocalBackupEnabled() {
        return this.isLocalBackupEnabled;
    }

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public Boolean getIsSparseDiskgroupEnabled() {
        return this.isSparseDiskgroupEnabled;
    }

    public String getGiVersion() {
        return this.giVersion;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public DiskRedundancy getDiskRedundancy() {
        return this.diskRedundancy;
    }

    public List<String> getScanIpIds() {
        return this.scanIpIds;
    }

    public List<String> getVipIds() {
        return this.vipIds;
    }

    public List<String> getScanIpv6Ids() {
        return this.scanIpv6Ids;
    }

    public List<String> getVipv6Ids() {
        return this.vipv6Ids;
    }

    public String getScanDnsRecordId() {
        return this.scanDnsRecordId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSecurityAttributes() {
        return this.securityAttributes;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String getScanDnsName() {
        return this.scanDnsName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Integer getScanListenerPortTcp() {
        return this.scanListenerPortTcp;
    }

    public Integer getScanListenerPortTcpSsl() {
        return this.scanListenerPortTcpSsl;
    }

    public DataCollectionOptions getDataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    public String getGiSoftwareImageId() {
        return this.giSoftwareImageId;
    }

    public List<FileSystemConfigurationDetail> getFileSystemConfigurationDetails() {
        return this.fileSystemConfigurationDetails;
    }

    public CloudAutomationUpdateDetails getCloudAutomationUpdateDetails() {
        return this.cloudAutomationUpdateDetails;
    }

    public VmClusterType getVmClusterType() {
        return this.vmClusterType;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CloudVmCluster(");
        sb.append("super=").append(super.toString());
        sb.append("iormConfigCache=").append(String.valueOf((Object)this.iormConfigCache));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", backupSubnetId=").append(String.valueOf(this.backupSubnetId));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", backupNetworkNsgIds=").append(String.valueOf(this.backupNetworkNsgIds));
        sb.append(", lastUpdateHistoryEntryId=").append(String.valueOf(this.lastUpdateHistoryEntryId));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", listenerPort=").append(String.valueOf(this.listenerPort));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", storageSizeInGBs=").append(String.valueOf(this.storageSizeInGBs));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", ocpuCount=").append(String.valueOf(this.ocpuCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", dbNodeStorageSizeInGBs=").append(String.valueOf(this.dbNodeStorageSizeInGBs));
        sb.append(", dataStorageSizeInTBs=").append(String.valueOf(this.dataStorageSizeInTBs));
        sb.append(", dbServers=").append(String.valueOf(this.dbServers));
        sb.append(", clusterName=").append(String.valueOf(this.clusterName));
        sb.append(", dataStoragePercentage=").append(String.valueOf(this.dataStoragePercentage));
        sb.append(", isLocalBackupEnabled=").append(String.valueOf(this.isLocalBackupEnabled));
        sb.append(", cloudExadataInfrastructureId=").append(String.valueOf(this.cloudExadataInfrastructureId));
        sb.append(", isSparseDiskgroupEnabled=").append(String.valueOf(this.isSparseDiskgroupEnabled));
        sb.append(", giVersion=").append(String.valueOf(this.giVersion));
        sb.append(", systemVersion=").append(String.valueOf(this.systemVersion));
        sb.append(", sshPublicKeys=").append(String.valueOf(this.sshPublicKeys));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", diskRedundancy=").append(String.valueOf((Object)this.diskRedundancy));
        sb.append(", scanIpIds=").append(String.valueOf(this.scanIpIds));
        sb.append(", vipIds=").append(String.valueOf(this.vipIds));
        sb.append(", scanIpv6Ids=").append(String.valueOf(this.scanIpv6Ids));
        sb.append(", vipv6Ids=").append(String.valueOf(this.vipv6Ids));
        sb.append(", scanDnsRecordId=").append(String.valueOf(this.scanDnsRecordId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", securityAttributes=").append(String.valueOf(this.securityAttributes));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", scanDnsName=").append(String.valueOf(this.scanDnsName));
        sb.append(", zoneId=").append(String.valueOf(this.zoneId));
        sb.append(", scanListenerPortTcp=").append(String.valueOf(this.scanListenerPortTcp));
        sb.append(", scanListenerPortTcpSsl=").append(String.valueOf(this.scanListenerPortTcpSsl));
        sb.append(", dataCollectionOptions=").append(String.valueOf((Object)this.dataCollectionOptions));
        sb.append(", giSoftwareImageId=").append(String.valueOf(this.giSoftwareImageId));
        sb.append(", fileSystemConfigurationDetails=").append(String.valueOf(this.fileSystemConfigurationDetails));
        sb.append(", cloudAutomationUpdateDetails=").append(String.valueOf((Object)this.cloudAutomationUpdateDetails));
        sb.append(", vmClusterType=").append(String.valueOf((Object)this.vmClusterType));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudVmCluster)) {
            return false;
        }
        CloudVmCluster other = (CloudVmCluster)((Object)o);
        return Objects.equals((Object)this.iormConfigCache, (Object)other.iormConfigCache) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.backupSubnetId, other.backupSubnetId) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.backupNetworkNsgIds, other.backupNetworkNsgIds) && Objects.equals(this.lastUpdateHistoryEntryId, other.lastUpdateHistoryEntryId) && Objects.equals(this.shape, other.shape) && Objects.equals(this.listenerPort, other.listenerPort) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals(this.storageSizeInGBs, other.storageSizeInGBs) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.domain, other.domain) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.ocpuCount, other.ocpuCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.dbNodeStorageSizeInGBs, other.dbNodeStorageSizeInGBs) && Objects.equals(this.dataStorageSizeInTBs, other.dataStorageSizeInTBs) && Objects.equals(this.dbServers, other.dbServers) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.dataStoragePercentage, other.dataStoragePercentage) && Objects.equals(this.isLocalBackupEnabled, other.isLocalBackupEnabled) && Objects.equals(this.cloudExadataInfrastructureId, other.cloudExadataInfrastructureId) && Objects.equals(this.isSparseDiskgroupEnabled, other.isSparseDiskgroupEnabled) && Objects.equals(this.giVersion, other.giVersion) && Objects.equals(this.systemVersion, other.systemVersion) && Objects.equals(this.sshPublicKeys, other.sshPublicKeys) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals((Object)this.diskRedundancy, (Object)other.diskRedundancy) && Objects.equals(this.scanIpIds, other.scanIpIds) && Objects.equals(this.vipIds, other.vipIds) && Objects.equals(this.scanIpv6Ids, other.scanIpv6Ids) && Objects.equals(this.vipv6Ids, other.vipv6Ids) && Objects.equals(this.scanDnsRecordId, other.scanDnsRecordId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.securityAttributes, other.securityAttributes) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.scanDnsName, other.scanDnsName) && Objects.equals(this.zoneId, other.zoneId) && Objects.equals(this.scanListenerPortTcp, other.scanListenerPortTcp) && Objects.equals(this.scanListenerPortTcpSsl, other.scanListenerPortTcpSsl) && Objects.equals((Object)this.dataCollectionOptions, (Object)other.dataCollectionOptions) && Objects.equals(this.giSoftwareImageId, other.giSoftwareImageId) && Objects.equals(this.fileSystemConfigurationDetails, other.fileSystemConfigurationDetails) && Objects.equals((Object)this.cloudAutomationUpdateDetails, (Object)other.cloudAutomationUpdateDetails) && Objects.equals((Object)this.vmClusterType, (Object)other.vmClusterType) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.iormConfigCache == null ? 43 : this.iormConfigCache.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.backupSubnetId == null ? 43 : this.backupSubnetId.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.backupNetworkNsgIds == null ? 43 : this.backupNetworkNsgIds.hashCode());
        result = result * 59 + (this.lastUpdateHistoryEntryId == null ? 43 : this.lastUpdateHistoryEntryId.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.listenerPort == null ? 43 : this.listenerPort.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.storageSizeInGBs == null ? 43 : this.storageSizeInGBs.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.ocpuCount == null ? 43 : this.ocpuCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.dbNodeStorageSizeInGBs == null ? 43 : this.dbNodeStorageSizeInGBs.hashCode());
        result = result * 59 + (this.dataStorageSizeInTBs == null ? 43 : this.dataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.dbServers == null ? 43 : this.dbServers.hashCode());
        result = result * 59 + (this.clusterName == null ? 43 : this.clusterName.hashCode());
        result = result * 59 + (this.dataStoragePercentage == null ? 43 : this.dataStoragePercentage.hashCode());
        result = result * 59 + (this.isLocalBackupEnabled == null ? 43 : this.isLocalBackupEnabled.hashCode());
        result = result * 59 + (this.cloudExadataInfrastructureId == null ? 43 : this.cloudExadataInfrastructureId.hashCode());
        result = result * 59 + (this.isSparseDiskgroupEnabled == null ? 43 : this.isSparseDiskgroupEnabled.hashCode());
        result = result * 59 + (this.giVersion == null ? 43 : this.giVersion.hashCode());
        result = result * 59 + (this.systemVersion == null ? 43 : this.systemVersion.hashCode());
        result = result * 59 + (this.sshPublicKeys == null ? 43 : this.sshPublicKeys.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.diskRedundancy == null ? 43 : this.diskRedundancy.hashCode());
        result = result * 59 + (this.scanIpIds == null ? 43 : this.scanIpIds.hashCode());
        result = result * 59 + (this.vipIds == null ? 43 : this.vipIds.hashCode());
        result = result * 59 + (this.scanIpv6Ids == null ? 43 : this.scanIpv6Ids.hashCode());
        result = result * 59 + (this.vipv6Ids == null ? 43 : this.vipv6Ids.hashCode());
        result = result * 59 + (this.scanDnsRecordId == null ? 43 : this.scanDnsRecordId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.securityAttributes == null ? 43 : this.securityAttributes.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.scanDnsName == null ? 43 : this.scanDnsName.hashCode());
        result = result * 59 + (this.zoneId == null ? 43 : this.zoneId.hashCode());
        result = result * 59 + (this.scanListenerPortTcp == null ? 43 : this.scanListenerPortTcp.hashCode());
        result = result * 59 + (this.scanListenerPortTcpSsl == null ? 43 : this.scanListenerPortTcpSsl.hashCode());
        result = result * 59 + (this.dataCollectionOptions == null ? 43 : this.dataCollectionOptions.hashCode());
        result = result * 59 + (this.giSoftwareImageId == null ? 43 : this.giSoftwareImageId.hashCode());
        result = result * 59 + (this.fileSystemConfigurationDetails == null ? 43 : this.fileSystemConfigurationDetails.hashCode());
        result = result * 59 + (this.cloudAutomationUpdateDetails == null ? 43 : this.cloudAutomationUpdateDetails.hashCode());
        result = result * 59 + (this.vmClusterType == null ? 43 : this.vmClusterType.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DiskRedundancy implements BmcEnum
    {
        High("HIGH"),
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DiskRedundancy> map;

        private DiskRedundancy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiskRedundancy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DiskRedundancy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DiskRedundancy.class);
            map = new HashMap<String, DiskRedundancy>();
            for (DiskRedundancy v : DiskRedundancy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum VmClusterType implements BmcEnum
    {
        Regular("REGULAR"),
        Developer("DEVELOPER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, VmClusterType> map;

        private VmClusterType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static VmClusterType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'VmClusterType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(VmClusterType.class);
            map = new HashMap<String, VmClusterType>();
            for (VmClusterType v : VmClusterType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ComputeModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ComputeModel.class);
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="iormConfigCache")
        private ExadataIormConfig iormConfigCache;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="subscriptionId")
        private String subscriptionId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="backupSubnetId")
        private String backupSubnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="backupNetworkNsgIds")
        private List<String> backupNetworkNsgIds;
        @JsonProperty(value="lastUpdateHistoryEntryId")
        private String lastUpdateHistoryEntryId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="listenerPort")
        private Long listenerPort;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="storageSizeInGBs")
        private Integer storageSizeInGBs;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="ocpuCount")
        private Float ocpuCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="dbNodeStorageSizeInGBs")
        private Integer dbNodeStorageSizeInGBs;
        @JsonProperty(value="dataStorageSizeInTBs")
        private Double dataStorageSizeInTBs;
        @JsonProperty(value="dbServers")
        private List<String> dbServers;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="dataStoragePercentage")
        private Integer dataStoragePercentage;
        @JsonProperty(value="isLocalBackupEnabled")
        private Boolean isLocalBackupEnabled;
        @JsonProperty(value="cloudExadataInfrastructureId")
        private String cloudExadataInfrastructureId;
        @JsonProperty(value="isSparseDiskgroupEnabled")
        private Boolean isSparseDiskgroupEnabled;
        @JsonProperty(value="giVersion")
        private String giVersion;
        @JsonProperty(value="systemVersion")
        private String systemVersion;
        @JsonProperty(value="sshPublicKeys")
        private List<String> sshPublicKeys;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="diskRedundancy")
        private DiskRedundancy diskRedundancy;
        @JsonProperty(value="scanIpIds")
        private List<String> scanIpIds;
        @JsonProperty(value="vipIds")
        private List<String> vipIds;
        @JsonProperty(value="scanIpv6Ids")
        private List<String> scanIpv6Ids;
        @JsonProperty(value="vipv6Ids")
        private List<String> vipv6Ids;
        @JsonProperty(value="scanDnsRecordId")
        private String scanDnsRecordId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="securityAttributes")
        private Map<String, Map<String, Object>> securityAttributes;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="scanDnsName")
        private String scanDnsName;
        @JsonProperty(value="zoneId")
        private String zoneId;
        @JsonProperty(value="scanListenerPortTcp")
        private Integer scanListenerPortTcp;
        @JsonProperty(value="scanListenerPortTcpSsl")
        private Integer scanListenerPortTcpSsl;
        @JsonProperty(value="dataCollectionOptions")
        private DataCollectionOptions dataCollectionOptions;
        @JsonProperty(value="giSoftwareImageId")
        private String giSoftwareImageId;
        @JsonProperty(value="fileSystemConfigurationDetails")
        private List<FileSystemConfigurationDetail> fileSystemConfigurationDetails;
        @JsonProperty(value="cloudAutomationUpdateDetails")
        private CloudAutomationUpdateDetails cloudAutomationUpdateDetails;
        @JsonProperty(value="vmClusterType")
        private VmClusterType vmClusterType;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder iormConfigCache(ExadataIormConfig iormConfigCache) {
            this.iormConfigCache = iormConfigCache;
            this.__explicitlySet__.add("iormConfigCache");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.__explicitlySet__.add("subscriptionId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder backupSubnetId(String backupSubnetId) {
            this.backupSubnetId = backupSubnetId;
            this.__explicitlySet__.add("backupSubnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder backupNetworkNsgIds(List<String> backupNetworkNsgIds) {
            this.backupNetworkNsgIds = backupNetworkNsgIds;
            this.__explicitlySet__.add("backupNetworkNsgIds");
            return this;
        }

        public Builder lastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
            this.__explicitlySet__.add("lastUpdateHistoryEntryId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder listenerPort(Long listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder storageSizeInGBs(Integer storageSizeInGBs) {
            this.storageSizeInGBs = storageSizeInGBs;
            this.__explicitlySet__.add("storageSizeInGBs");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder ocpuCount(Float ocpuCount) {
            this.ocpuCount = ocpuCount;
            this.__explicitlySet__.add("ocpuCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            this.__explicitlySet__.add("dbNodeStorageSizeInGBs");
            return this;
        }

        public Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            this.__explicitlySet__.add("dataStorageSizeInTBs");
            return this;
        }

        public Builder dbServers(List<String> dbServers) {
            this.dbServers = dbServers;
            this.__explicitlySet__.add("dbServers");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder dataStoragePercentage(Integer dataStoragePercentage) {
            this.dataStoragePercentage = dataStoragePercentage;
            this.__explicitlySet__.add("dataStoragePercentage");
            return this;
        }

        public Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            this.__explicitlySet__.add("isLocalBackupEnabled");
            return this;
        }

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            this.__explicitlySet__.add("cloudExadataInfrastructureId");
            return this;
        }

        public Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            this.__explicitlySet__.add("isSparseDiskgroupEnabled");
            return this;
        }

        public Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            this.__explicitlySet__.add("giVersion");
            return this;
        }

        public Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            this.__explicitlySet__.add("systemVersion");
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            this.__explicitlySet__.add("sshPublicKeys");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder diskRedundancy(DiskRedundancy diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
            this.__explicitlySet__.add("diskRedundancy");
            return this;
        }

        public Builder scanIpIds(List<String> scanIpIds) {
            this.scanIpIds = scanIpIds;
            this.__explicitlySet__.add("scanIpIds");
            return this;
        }

        public Builder vipIds(List<String> vipIds) {
            this.vipIds = vipIds;
            this.__explicitlySet__.add("vipIds");
            return this;
        }

        public Builder scanIpv6Ids(List<String> scanIpv6Ids) {
            this.scanIpv6Ids = scanIpv6Ids;
            this.__explicitlySet__.add("scanIpv6Ids");
            return this;
        }

        public Builder vipv6Ids(List<String> vipv6Ids) {
            this.vipv6Ids = vipv6Ids;
            this.__explicitlySet__.add("vipv6Ids");
            return this;
        }

        public Builder scanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
            this.__explicitlySet__.add("scanDnsRecordId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder securityAttributes(Map<String, Map<String, Object>> securityAttributes) {
            this.securityAttributes = securityAttributes;
            this.__explicitlySet__.add("securityAttributes");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder scanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
            this.__explicitlySet__.add("scanDnsName");
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            this.__explicitlySet__.add("zoneId");
            return this;
        }

        public Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            this.__explicitlySet__.add("scanListenerPortTcp");
            return this;
        }

        public Builder scanListenerPortTcpSsl(Integer scanListenerPortTcpSsl) {
            this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
            this.__explicitlySet__.add("scanListenerPortTcpSsl");
            return this;
        }

        public Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            this.__explicitlySet__.add("dataCollectionOptions");
            return this;
        }

        public Builder giSoftwareImageId(String giSoftwareImageId) {
            this.giSoftwareImageId = giSoftwareImageId;
            this.__explicitlySet__.add("giSoftwareImageId");
            return this;
        }

        public Builder fileSystemConfigurationDetails(List<FileSystemConfigurationDetail> fileSystemConfigurationDetails) {
            this.fileSystemConfigurationDetails = fileSystemConfigurationDetails;
            this.__explicitlySet__.add("fileSystemConfigurationDetails");
            return this;
        }

        public Builder cloudAutomationUpdateDetails(CloudAutomationUpdateDetails cloudAutomationUpdateDetails) {
            this.cloudAutomationUpdateDetails = cloudAutomationUpdateDetails;
            this.__explicitlySet__.add("cloudAutomationUpdateDetails");
            return this;
        }

        public Builder vmClusterType(VmClusterType vmClusterType) {
            this.vmClusterType = vmClusterType;
            this.__explicitlySet__.add("vmClusterType");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public CloudVmCluster build() {
            CloudVmCluster model = new CloudVmCluster(this.iormConfigCache, this.id, this.compartmentId, this.subscriptionId, this.availabilityDomain, this.subnetId, this.backupSubnetId, this.nsgIds, this.backupNetworkNsgIds, this.lastUpdateHistoryEntryId, this.shape, this.listenerPort, this.lifecycleState, this.nodeCount, this.storageSizeInGBs, this.displayName, this.timeCreated, this.lifecycleDetails, this.timeZone, this.hostname, this.domain, this.cpuCoreCount, this.ocpuCount, this.memorySizeInGBs, this.dbNodeStorageSizeInGBs, this.dataStorageSizeInTBs, this.dbServers, this.clusterName, this.dataStoragePercentage, this.isLocalBackupEnabled, this.cloudExadataInfrastructureId, this.isSparseDiskgroupEnabled, this.giVersion, this.systemVersion, this.sshPublicKeys, this.licenseModel, this.diskRedundancy, this.scanIpIds, this.vipIds, this.scanIpv6Ids, this.vipv6Ids, this.scanDnsRecordId, this.freeformTags, this.definedTags, this.securityAttributes, this.systemTags, this.scanDnsName, this.zoneId, this.scanListenerPortTcp, this.scanListenerPortTcpSsl, this.dataCollectionOptions, this.giSoftwareImageId, this.fileSystemConfigurationDetails, this.cloudAutomationUpdateDetails, this.vmClusterType, this.computeModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CloudVmCluster model) {
            if (model.wasPropertyExplicitlySet("iormConfigCache")) {
                this.iormConfigCache(model.getIormConfigCache());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("subscriptionId")) {
                this.subscriptionId(model.getSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("backupSubnetId")) {
                this.backupSubnetId(model.getBackupSubnetId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("backupNetworkNsgIds")) {
                this.backupNetworkNsgIds(model.getBackupNetworkNsgIds());
            }
            if (model.wasPropertyExplicitlySet("lastUpdateHistoryEntryId")) {
                this.lastUpdateHistoryEntryId(model.getLastUpdateHistoryEntryId());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("listenerPort")) {
                this.listenerPort(model.getListenerPort());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("storageSizeInGBs")) {
                this.storageSizeInGBs(model.getStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("ocpuCount")) {
                this.ocpuCount(model.getOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbNodeStorageSizeInGBs")) {
                this.dbNodeStorageSizeInGBs(model.getDbNodeStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInTBs")) {
                this.dataStorageSizeInTBs(model.getDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("dbServers")) {
                this.dbServers(model.getDbServers());
            }
            if (model.wasPropertyExplicitlySet("clusterName")) {
                this.clusterName(model.getClusterName());
            }
            if (model.wasPropertyExplicitlySet("dataStoragePercentage")) {
                this.dataStoragePercentage(model.getDataStoragePercentage());
            }
            if (model.wasPropertyExplicitlySet("isLocalBackupEnabled")) {
                this.isLocalBackupEnabled(model.getIsLocalBackupEnabled());
            }
            if (model.wasPropertyExplicitlySet("cloudExadataInfrastructureId")) {
                this.cloudExadataInfrastructureId(model.getCloudExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("isSparseDiskgroupEnabled")) {
                this.isSparseDiskgroupEnabled(model.getIsSparseDiskgroupEnabled());
            }
            if (model.wasPropertyExplicitlySet("giVersion")) {
                this.giVersion(model.getGiVersion());
            }
            if (model.wasPropertyExplicitlySet("systemVersion")) {
                this.systemVersion(model.getSystemVersion());
            }
            if (model.wasPropertyExplicitlySet("sshPublicKeys")) {
                this.sshPublicKeys(model.getSshPublicKeys());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("diskRedundancy")) {
                this.diskRedundancy(model.getDiskRedundancy());
            }
            if (model.wasPropertyExplicitlySet("scanIpIds")) {
                this.scanIpIds(model.getScanIpIds());
            }
            if (model.wasPropertyExplicitlySet("vipIds")) {
                this.vipIds(model.getVipIds());
            }
            if (model.wasPropertyExplicitlySet("scanIpv6Ids")) {
                this.scanIpv6Ids(model.getScanIpv6Ids());
            }
            if (model.wasPropertyExplicitlySet("vipv6Ids")) {
                this.vipv6Ids(model.getVipv6Ids());
            }
            if (model.wasPropertyExplicitlySet("scanDnsRecordId")) {
                this.scanDnsRecordId(model.getScanDnsRecordId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("securityAttributes")) {
                this.securityAttributes(model.getSecurityAttributes());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("scanDnsName")) {
                this.scanDnsName(model.getScanDnsName());
            }
            if (model.wasPropertyExplicitlySet("zoneId")) {
                this.zoneId(model.getZoneId());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcp")) {
                this.scanListenerPortTcp(model.getScanListenerPortTcp());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcpSsl")) {
                this.scanListenerPortTcpSsl(model.getScanListenerPortTcpSsl());
            }
            if (model.wasPropertyExplicitlySet("dataCollectionOptions")) {
                this.dataCollectionOptions(model.getDataCollectionOptions());
            }
            if (model.wasPropertyExplicitlySet("giSoftwareImageId")) {
                this.giSoftwareImageId(model.getGiSoftwareImageId());
            }
            if (model.wasPropertyExplicitlySet("fileSystemConfigurationDetails")) {
                this.fileSystemConfigurationDetails(model.getFileSystemConfigurationDetails());
            }
            if (model.wasPropertyExplicitlySet("cloudAutomationUpdateDetails")) {
                this.cloudAutomationUpdateDetails(model.getCloudAutomationUpdateDetails());
            }
            if (model.wasPropertyExplicitlySet("vmClusterType")) {
                this.vmClusterType(model.getVmClusterType());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            return this;
        }
    }
}

