/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AutonomousDatabaseEncryptionKeyDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="provider")
@JsonFilter(value="explicitlySetFilter")
public final class AzureKeyDetails
extends AutonomousDatabaseEncryptionKeyDetails {
    @JsonProperty(value="vaultUri")
    private final String vaultUri;
    @JsonProperty(value="keyName")
    private final String keyName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AzureKeyDetails(String vaultUri, String keyName) {
        this.vaultUri = vaultUri;
        this.keyName = keyName;
    }

    public String getVaultUri() {
        return this.vaultUri;
    }

    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AzureKeyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vaultUri=").append(String.valueOf(this.vaultUri));
        sb.append(", keyName=").append(String.valueOf(this.keyName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AzureKeyDetails)) {
            return false;
        }
        AzureKeyDetails other = (AzureKeyDetails)((Object)o);
        return Objects.equals(this.vaultUri, other.vaultUri) && Objects.equals(this.keyName, other.keyName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vaultUri == null ? 43 : this.vaultUri.hashCode());
        result = result * 59 + (this.keyName == null ? 43 : this.keyName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vaultUri")
        private String vaultUri;
        @JsonProperty(value="keyName")
        private String keyName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vaultUri(String vaultUri) {
            this.vaultUri = vaultUri;
            this.__explicitlySet__.add("vaultUri");
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            this.__explicitlySet__.add("keyName");
            return this;
        }

        public AzureKeyDetails build() {
            AzureKeyDetails model = new AzureKeyDetails(this.vaultUri, this.keyName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AzureKeyDetails model) {
            if (model.wasPropertyExplicitlySet("vaultUri")) {
                this.vaultUri(model.getVaultUri());
            }
            if (model.wasPropertyExplicitlySet("keyName")) {
                this.keyName(model.getKeyName());
            }
            return this;
        }
    }
}

