/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StandardTagDefinitionTemplate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="tagDefinitionName")
    private final String tagDefinitionName;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="possibleValues")
    private final List<String> possibleValues;
    @JsonProperty(value="isCostTracking")
    private final Boolean isCostTracking;
    @JsonProperty(value="enumMutability")
    private final EnumMutability enumMutability;

    @Deprecated
    @ConstructorProperties(value={"description", "tagDefinitionName", "type", "possibleValues", "isCostTracking", "enumMutability"})
    public StandardTagDefinitionTemplate(String description, String tagDefinitionName, Type type, List<String> possibleValues, Boolean isCostTracking, EnumMutability enumMutability) {
        this.description = description;
        this.tagDefinitionName = tagDefinitionName;
        this.type = type;
        this.possibleValues = possibleValues;
        this.isCostTracking = isCostTracking;
        this.enumMutability = enumMutability;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getTagDefinitionName() {
        return this.tagDefinitionName;
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getPossibleValues() {
        return this.possibleValues;
    }

    public Boolean getIsCostTracking() {
        return this.isCostTracking;
    }

    public EnumMutability getEnumMutability() {
        return this.enumMutability;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StandardTagDefinitionTemplate(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", tagDefinitionName=").append(String.valueOf(this.tagDefinitionName));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", possibleValues=").append(String.valueOf(this.possibleValues));
        sb.append(", isCostTracking=").append(String.valueOf(this.isCostTracking));
        sb.append(", enumMutability=").append(String.valueOf((Object)this.enumMutability));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardTagDefinitionTemplate)) {
            return false;
        }
        StandardTagDefinitionTemplate other = (StandardTagDefinitionTemplate)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.tagDefinitionName, other.tagDefinitionName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.possibleValues, other.possibleValues) && Objects.equals(this.isCostTracking, other.isCostTracking) && Objects.equals((Object)this.enumMutability, (Object)other.enumMutability) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.tagDefinitionName == null ? 43 : this.tagDefinitionName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.possibleValues == null ? 43 : this.possibleValues.hashCode());
        result = result * 59 + (this.isCostTracking == null ? 43 : this.isCostTracking.hashCode());
        result = result * 59 + (this.enumMutability == null ? 43 : this.enumMutability.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Enum("ENUM"),
        String("STRING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EnumMutability implements BmcEnum
    {
        Immutable("IMMUTABLE"),
        Mutable("MUTABLE"),
        Appendable("APPENDABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EnumMutability> map;

        private EnumMutability(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EnumMutability create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EnumMutability', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EnumMutability.class);
            map = new HashMap<String, EnumMutability>();
            for (EnumMutability v : EnumMutability.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="tagDefinitionName")
        private String tagDefinitionName;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="possibleValues")
        private List<String> possibleValues;
        @JsonProperty(value="isCostTracking")
        private Boolean isCostTracking;
        @JsonProperty(value="enumMutability")
        private EnumMutability enumMutability;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder tagDefinitionName(String tagDefinitionName) {
            this.tagDefinitionName = tagDefinitionName;
            this.__explicitlySet__.add("tagDefinitionName");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder possibleValues(List<String> possibleValues) {
            this.possibleValues = possibleValues;
            this.__explicitlySet__.add("possibleValues");
            return this;
        }

        public Builder isCostTracking(Boolean isCostTracking) {
            this.isCostTracking = isCostTracking;
            this.__explicitlySet__.add("isCostTracking");
            return this;
        }

        public Builder enumMutability(EnumMutability enumMutability) {
            this.enumMutability = enumMutability;
            this.__explicitlySet__.add("enumMutability");
            return this;
        }

        public StandardTagDefinitionTemplate build() {
            StandardTagDefinitionTemplate model = new StandardTagDefinitionTemplate(this.description, this.tagDefinitionName, this.type, this.possibleValues, this.isCostTracking, this.enumMutability);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StandardTagDefinitionTemplate model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("tagDefinitionName")) {
                this.tagDefinitionName(model.getTagDefinitionName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("possibleValues")) {
                this.possibleValues(model.getPossibleValues());
            }
            if (model.wasPropertyExplicitlySet("isCostTracking")) {
                this.isCostTracking(model.getIsCostTracking());
            }
            if (model.wasPropertyExplicitlySet("enumMutability")) {
                this.enumMutability(model.getEnumMutability());
            }
            return this;
        }
    }
}

