#!/bin/sh
#
# $Header: dbgendev/src/langdata/install/install_oml4py.sh /main/8 2025/07/28 08:13:40 arevathi Exp $
#
# install_oml4py.sh
#
# Copyright (c) 2025, Oracle and/or its affiliates. 
#
#    NAME
#      install_oml4py.sh - This script installs oml4py in a db instance.
#
#    DESCRIPTION
#      Usage: ./install_oml4py.sh <sys_username> <sys_password> <database_service_name> <pdb_name>
#              sys_username: Database Username for sysdba user
#              sys_password: Password for sysdba user
#              database_service_name: Service_name for database in short format
#              pdb_name: PDB name to install oml4py
#    NOTES
#      NONE
#
#    MODIFIED   (MM/DD/YY)
#    arevathi    07/09/25 - Update Model_dir to MOUNT_DIR
#    arevathi    05/22/25 - Update paths to consume from dbfs
#    dadoshi     05/14/25 - Update pip to python3.12 -m pip
#    dadoshi     04/29/25 - Execute SQL script only if all arguments are 
#                           provided, i.e., script is not executed within SQLcl
#    dadoshi     04/23/25 - Add sentence_transformers
#    deveverm    04/21/25 - Copy NunerZero model weights
#    deveverm    02/05/25 - Creation
#

#Exit script on error
set -e

# Store arguments in variables
USERNAME="$1"
PASSWORD="$2"
DSN="$3"
PDBNAME="$4"
MOUNT_DIR="$5"

# Check if ORACLE_HOME is set
if [ -z "$ORACLE_HOME" ]; then
    echo "ORACLE_HOME environment variable is not set."
    exit 1
fi
echo "ORACLE_HOME: $ORACLE_HOME"

# Set required env variables
export PYTHONPATH=$ORACLE_HOME/oml4py/modules
export PYTHONHOME=$ORACLE_HOME/python
export PATH=$PYTHONHOME/bin:$ORACLE_HOME/bin:$PATH
export OPE_LIBPYQE=$ORACLE_HOME/lib/libpyqe.so
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$PYTHONHOME/lib:$ORACLE_HOME/lib
export JAVA_HOME=$ORACLE_HOME/jdk

# Create the directory if it doesn't exist
if [ ! -d "$PYTHONPATH" ]; then
    mkdir -p "$PYTHONPATH"
    echo "Directory $PYTHONPATH created successfully."
else
    echo "Directory $PYTHONPATH already exists."
fi

#Set script dir
SCRIPT_DIR="$(dirname "$(realpath $0)")"
echo "Script Dir: $SCRIPT_DIR";

#copy required libs to oracle python
# cp -n $SCRIPT_DIR/python_libs/* $PYTHONHOME/lib/
cp -n $MOUNT_DIR/python_libs/* $ORACLE_HOME/lib/
cp -n $PYTHONHOME/lib/libpython* $ORACLE_HOME/lib/

# Check for perl-Env package
if rpm -qa | grep -q "perl-Env"; then
    echo "perl-Env package is installed."
else
    echo "perl-Env package is not installed. Please install it before \
          proceeding."
    exit 1
fi

# install python packages
echo 'Installing Python packages';
$PYTHONHOME/bin/python3.12 -m pip install -r $SCRIPT_DIR/oml4py_requirements.txt --target $PYTHONPATH --no-index --find-links $MOUNT_DIR/python_pkgs;

if [ -n "$1" ] && [ -n "$2" ] && [ -n "$3" ] && [ -n "$4" ]; then
        # Store arguments in variables
        USERNAME="$1"
        PASSWORD="$2"
        DSN="$3"
        PDBNAME="$4"
	echo 'Installing OML4Py'
	# change working dir to oml4py/server
	cd $ORACLE_HOME/oml4py/server;
	$ORACLE_HOME/bin/sqlplus $USERNAME/$PASSWORD@$DSN as sysdba @$SCRIPT_DIR/install_oml4py.sql $PDBNAME $SCRIPT_DIR $PYTHONHOME $ORACLE_HOME/oml4py/server
fi
if [ $? -ne 0 ]; then
    echo "OML4Py installation failed."
    exit 1
else
    echo "SQL script executed successfully"
fi

echo 'Installing GliNER'
$PYTHONHOME/bin/python3.12 -m pip install gliner==0.2.8 onnx==1.17.0 --target $PYTHONPATH --no-index --find-links $MOUNT_DIR/python_pkgs;
$PYTHONHOME/bin/python3.12 -m pip install sentence_transformers==4.1.0 --target $PYTHONPATH

$PYTHONHOME/bin/python3.12 -u -m pip install $MOUNT_DIR/python_pkgs/oml-2.1-cp312-cp312-linux_x86_64.whl --target=$ORACLE_HOME/oml4py/modules --no-index --find-links $MOUNT_DIR/python_pkgs;

# Function to print error and exit
error_exit() {
    echo "Error: $1" >&2
    exit 1
}

echo "Installed OML4Py, you can check the logs (install_root_log.txt and install_pdb_log.txt) at: $SCRIPT_DIR"
