Rem
Rem $Header: dbgendev/src/langdata/install/create_langdata_user.sql /main/11 2025/06/30 17:14:25 deveverm Exp $
Rem $Header: dbgendev/src/langdata/install/create_langdata_user.sql /main/11 2025/06/30 17:14:25 deveverm Exp $
Rem
Rem create_langdata_user.sql
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem    NAME
Rem      create_langdata_user.sql - Create LANGDATA OWNER and an app user
Rem
Rem    DESCRIPTION
Rem      This script creates LANGDATA OWNER and an app user based on the
Rem      the following arguments this script accepts:
Rem      
Rem          - pdb_name: Pluggable Database in which the user is to created.
Rem                      For SRG1, it is CDB1_PDB1
Rem          - langdata_tablespace_name: Name of the default tablespace of 
Rem                                      langdata owner
Rem          - langdata_username: Username of langdata owner
Rem          - langdata_username_pass: Password of langdata owner
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/create_langdata_user.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    SQL_CALLING_FILE:
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    06/25/25 - DBAI-771: added auto tablespace detection for ADB
Rem    lachoud     30/05/25 - DBAI-563: Added logging functinality in files
Rem    deveverm    06/02/25 - DBAI-794: removed privileges related to PLSQL-SDK
Rem    pryarla     05/15/25 - DBAI-737: Grant privilege on dbms_cloud and 
Rem                           dbms_cloud_ai
Rem    deveverm    04/16/25 - DBAI-735: Grant privilege on dbms_vector
Rem    deveverm    04/10/25 - DBAI-720: made changes to give appropriate
Rem                           privilege according to env (ADB or on-prem)
Rem    arevathi    03/07/25 - Grant privileges to user for managing Tablespace
Rem                           size
Rem    jiangnhu    03/07/25 - DBAI-542: Create user langdata as the owner of all
Rem                           langdata objects; create an app user
Rem    dadoshi     01/06/25 - Grant appropriate privileges to user for creating
Rem                           and managing resource plans
Rem    dadoshi     12/23/24 - Allow users to specify username
Rem    dadoshi     12/18/24 - Grant directory privileges to user
Rem    dadoshi     12/11/24 - Created
Rem

-- SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- Enable script to exit on error
WHENEVER SQLERROR EXIT SQL.SQLCODE


-- Define variables for arguments
DEFINE pdb_name = '&1'
DEFINE langdata_tablespace_name = '&2'
DEFINE langdata_username = '&3'
DEFINE langdata_password = '&4'

show con_name;
show parameter service_name;
ALTER SESSION SET CONTAINER=&pdb_name;
select username from all_users order by username;
show con_name;

DECLARE
    user_exists NUMBER;
BEGIN
    -- Check if the user exists
    SELECT COUNT(*) INTO user_exists FROM dba_users WHERE username = UPPER('&&langdata_username');

    -- If the user does not exist, create the user.
    IF user_exists = 0 THEN
            -- Create the user
        EXECUTE IMMEDIATE 'CREATE USER ' || UPPER('&&langdata_username') || ' IDENTIFIED BY ' || '&&langdata_password';
    END IF;
END;
/

GRANT EXECUTE ON CTXSYS.CTX_DDL TO &langdata_username;
-- General Privileges
GRANT CREATE MINING MODEL TO &langdata_username;
GRANT CREATE JOB TO &langdata_username;
GRANT CREATE ANY CONTEXT TO &langdata_username;
GRANT CREATE ROLE TO &langdata_username;
GRANT CREATE SESSION TO &langdata_username;
GRANT CREATE TABLE TO &langdata_username;
GRANT CREATE VIEW TO &langdata_username;
GRANT CREATE PROCEDURE TO &langdata_username;
GRANT GRANT ANY ROLE TO &langdata_username;
GRANT MANAGE SCHEDULER TO &langdata_username;

-- Execute Privileges on Specific Packages
GRANT EXECUTE ON DBMS_SQL TO &langdata_username;
GRANT EXECUTE ON DBMS_SCHEDULER TO &langdata_username;
GRANT EXECUTE ON DBMS_CRYPTO TO &langdata_username;
GRANT EXECUTE ON CTX_DDL TO &langdata_username;
GRANT EXECUTE ON DBMS_VECTOR TO &langdata_username;
GRANT CREATE TRIGGER TO &langdata_username;
GRANT EXECUTE ON DBMS_USERDIAG TO &langdata_username;

GRANT CREATE USER TO &langdata_username;
GRANT ALTER USER TO &langdata_username;
GRANT DROP USER TO &langdata_username;
GRANT CREATE ANY TYPE TO &langdata_username;
GRANT CREATE SYNONYM TO &langdata_username;
GRANT CREATE ANY DIRECTORY TO &langdata_username;
GRANT EXECUTE ON DBMS_VECTOR TO &langdata_username;
GRANT EXECUTE ON SYS.DBMS_ASSERT TO &langdata_username;
GRANT EXECUTE ON DBMS_SESSION TO &langdata_username;
GRANT CREATE SEQUENCE TO &langdata_username;
GRANT ALTER SYSTEM TO &langdata_username;
GRANT ADMINISTER DATABASE TRIGGER TO &langdata_username;
GRANT SELECT ON DBA_DATA_FILES TO &langdata_username;
GRANT EXECUTE on DBMS_CLOUD_AI TO &langdata_username;
GRANT EXECUTE on DBMS_CLOUD TO &langdata_username;


DECLARE
    v_cloud_service VARCHAR2(10);
BEGIN
    SELECT sys_cONtext('USERENV', 'CLOUD_SERVICE') 
    INTO v_cloud_service FROM dual;

    IF v_cloud_service IS NOT NULL THEN
        EXECUTE IMMEDIATE 'ALTER SESSION SET PLSQL_CCFLAGS = ''Is_Cloud:true''';
    ELSE
        EXECUTE IMMEDIATE 
        'ALTER SESSION SET PLSQL_CCFLAGS = ''Is_Cloud:false''';
    END IF;
END;
/

-- Privileges 
DECLARE
    v_cloud_service VARCHAR2(10);
    v_tablespace_name VARCHAR2(30);
BEGIN
    SELECT sys_context('USERENV', 'CLOUD_SERVICE') 
    INTO v_cloud_service FROM dual;

    IF v_cloud_service IS NULL THEN
        EXECUTE IMMEDIATE 
'ALTER USER &langdata_username DEFAULT TABLESPACE &langdata_tablespace_name';

        EXECUTE IMMEDIATE
'ALTER USER &langdata_username QUOTA UNLIMITED ON &langdata_tablespace_name';
        EXECUTE IMMEDIATE 'GRANT PYQADMIN TO &langdata_username';
        EXECUTE IMMEDIATE 
            'GRANT EXECUTE ON PYQSCRIPTCREATE TO &langdata_username';

        -- Not compile the below block for ADB
        $IF $$Is_Cloud = FALSE $THEN
            DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SYSTEM_PRIVILEGE(
                GRANTEE_NAME   => '&langdata_username',
                PRIVILEGE_NAME => 'ADMINISTER_RESOURCE_MANAGER',
                ADMIN_OPTION   => FALSE);
        $END
    ELSE
        EXECUTE IMMEDIATE
            'SELECT default_tablespace FROM dba_users '||
            'WHERE username = ''' || UPPER('&langdata_username') || ''''
        INTO v_tablespace_name;
        EXECUTE IMMEDIATE
            'ALTER USER &langdata_username QUOTA UNLIMITED ON '|| 
            v_tablespace_name;
    END IF;
END;
/