Rem
Rem $Header: dbgendev/src/langdata/install/check_langdata_tablespace.sql /main/1 2025/05/13 18:51:55 dadoshi Exp $
Rem
Rem check_langdata_tablespace.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      check_langdata_tablespace.sql - SQL Script to check existence of 
Rem                                      LANGDATA Tablespace in a PDB.
Rem
Rem    DESCRIPTION
Rem      This SQL Script checks the existence of LANGDATA Tablespace in a 
Rem      PDB and prints the message for the driver code to go through
Rem      as part of the LangData setup process. If a tablespace LANGDATA exists,
Rem      and is ASSM, "skip" is the output. In the cases of tablespace LANGDATA
Rem      not existing or existing but not being ASSM, "create" is the output.
Rem      Based on this output, the driver code decides whether to create the 
Rem      LANGDATA tablespace or skip this step.
Rem
Rem    NOTES
Rem      Script can only be executed as a user with DBA privileges.
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/check_langdata_tablespace.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dadoshi     04/29/25 - Created
Rem

-- Accept parameters
DEFINE pdb_name = '&1';
DEFINE langdata_tablespace_name = '&2';

-- Switch to the target PDB
ALTER SESSION SET CONTAINER = &pdb_name;

-- Anonymous PL/SQL block to check tablespace
SET SERVEROUTPUT ON
DECLARE
    v_count INTEGER;
    v_assm  VARCHAR2(10);
BEGIN
    -- Check if tablespace exists
    SELECT COUNT(*)
    INTO v_count
    FROM dba_tablespaces
    WHERE tablespace_name = UPPER('&langdata_tablespace_name');

    IF v_count = 0 THEN
        DBMS_OUTPUT.PUT_LINE('create'); -- Doesn't exist, proceed to create
    ELSE
        -- Check ASSM status
        SELECT segment_space_management
        INTO v_assm
        FROM dba_tablespaces
        WHERE tablespace_name = UPPER('&langdata_tablespace_name');

        IF v_assm = 'AUTO' THEN
            DBMS_OUTPUT.PUT_LINE('skip'); -- Exists and is ASSM, skip
        ELSE
            -- Drop the old non-ASSM tablespace
            EXECUTE IMMEDIATE 'DROP TABLESPACE ' || UPPER('&langdata_tablespace_name') || ' INCLUDING CONTENTS AND DATAFILES';
            DBMS_OUTPUT.PUT_LINE('create'); -- Dropped, so create a new one
        END IF;
    END IF;
END;
/

