/* iod-telemetry Services.sql version 2019.05.19.1 stkolev */
/* iod-telemetry Services.sql version 2021.03.16.1 balvesdo  */
with
    v$metricname as (
        /* version 4 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance 
    ),
    v$metric_history as (
        select /*+ INLINE OPT_PARAM('_px_cdb_view_enabled' 'FALSE') */
             csv.con_name
            ,csv.service_name
            ,case
                when csv.con_name =  'CDB$ROOT' and lower('s_'||sys_context('USERENV','DB_NAME'))               = csv.service_name  then 'S_READ_WRITE'
                when csv.con_name =  'CDB$ROOT' and lower('s_'||sys_context('USERENV','DB_NAME')||'_ro')        = csv.service_name  then 'S_READ_ONLY'
                when csv.con_name =  'CDB$ROOT' and csv.service_name in (
                    'SYS$BACKGROUND'
                    ,'SYS$USERS'
                    ,sys_context('USERENV','DB_UNIQUE_NAME')
                    ,sys_context('USERENV','DB_NAME')||'XDB'
                )   then 'DEFAULT'
                when csv.con_name != 'CDB$ROOT' and lower('s_'||csv.con_name)               = csv.service_name  then 'S_READ_WRITE'
                when csv.con_name != 'CDB$ROOT' and lower('s_'||csv.con_name||'_ro')        = csv.service_name  then 'S_READ_ONLY'
                when csv.con_name != 'CDB$ROOT' and lower(csv.con_name)   = csv.service_name  then 'DEFAULT'
                else 'OTHER'
             end as service_type
             ,decode(asv.name,null,0,1) as status
        from
            v$active_services asv
            ,(
                -- get a list of services that are defined and are supposed to be defined in this db
                select
                     con.con_id
                    ,con.name as con_name
                    ,regexp_substr(svc.name,'[^.]*',1,1) as service_name
                from
                     v$containers con
                    ,cdb_services svc
                where
                    con.con_id = svc.con_id
                union
                select
                     con_id
                    ,name as con_name
                    ,service_name
                from (
                    select
                         con_id
                        ,name
                        ,case when name = 'CDB$ROOT' then lower('s_'||sys_context('USERENV','DB_NAME')) else lower('s_'||name) end as s_read_write
                        ,case when name = 'CDB$ROOT' then lower('s_'||sys_context('USERENV','DB_NAME')||'_ro') else lower('s_'||name||'_ro') end as s_read_only
                    from
                         v$containers con
                ) unpivot (
                    service_name for service_type in (
                         s_read_write
                        ,s_read_only
                    )
                )
            ) csv
        where
            csv.con_id = asv.con_id (+)
            and lower(csv.service_name) = regexp_substr(lower(asv.name (+)),'[^.]*',1,1)
    ),
    v$metric as (
        select
            'Services.'|| metric_name as metric_name
            ,',"con_name":"'        || nvl(to_char(con_name     ),'null') || '"' ||
             ',"service_name":"'    || nvl(to_char(service_name ),'null') || '"' ||
             ',"service_type":"'    || nvl(to_char(service_type ),'null') || '"' as metric_dimensions
            ,metric_value as metric_value
        from (
            select
                con_name
                ,service_name
                ,service_type
                ,status                      as "Status"
            from
                v$metric_history
        ) unpivot (
            metric_value FOR metric_name IN (
                 "Status"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric