Rem
Rem $Header: dbgendev/src/langdata/plsql/semantic-cache/semantic_cache_pkg.pks /main/2 2025/08/17 19:34:27 deveverm Exp $
Rem
Rem semantic_cache_pkg.pls
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      semantic_cache_pkg.pks - Package specification for the semantic cache.
Rem
Rem    DESCRIPTION
Rem      Package for handling search for the semantic cache, along with,
Rem      seeding of the cache.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/semantic-cache/semantic_cache_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    08/08/25 - DBAI-1148: Added procedure cache_purge_reports,
Rem                           cache_delete_report_by_id
Rem    deveverm    08/06/25 - DBAI-1152: Added procedure cache_create_report
Rem    dadoshi     07/31/25 - JIRA_DBAI1147: Add cache_search_from_query
Rem    dadoshi     07/31/25 - Created
Rem

CREATE OR REPLACE PACKAGE lang_data_semantic_cache_pkg AUTHID CURRENT_USER IS
    /*
    ----------------------------------------------------------------------------
    Procedure cache_search_from_query
    ----------------------------------------------------------------------------
    Description:
        This procedure is a wrapper over the procedure, search_from_query of the
        package, lang_data_search_pkg, and is used for search from the semantic
        cache.

    Parameters:
        - p_query (IN VARCHAR2):
            The query text.
        - p_namespace (IN VARCHAR2):
            Namespace for the search_query.
        - p_min_confidence (IN NUMBER DEFAULT 0):
            Optional parameter for the minimum confidence in the top report
            match. Confidence is computed as:
                    100*(1-(vector distance of the top report match))
        - p_query_vector (IN VECTOR DEFAULT NULL):
            Optional parameter for the vector embedding of the query text.
        - p_search_id (OUT VARCHAR2):
            Unique ID of the search record.
        - p_report_id (OUT VARCHAR2):
            Report ID of the top matched report.
        - p_match_document (OUT JSON):
            Match Document of the top report.

    Exceptions:
        NONE
    ----------------------------------------------------------------------------
    */
    PROCEDURE cache_search_from_query (
        p_query                         IN VARCHAR2,
        p_namespace                     IN VARCHAR2,
        p_min_confidence                IN NUMBER DEFAULT 0,
        p_query_vector                  IN VECTOR DEFAULT NULL,
        p_search_id                     OUT VARCHAR2,
        p_report_id                     OUT VARCHAR2,
        p_match_document                OUT JSON
    );

    /*
    ----------------------------------------------------------------------------
    Procedure cache_create_report
    ----------------------------------------------------------------------------
    Description:
        This procedure is a wrapper over create_report procedure of the package 
        lang_data_reports_pkg, and is used for seeding the cache objects.

    Parameters:
        - p_query_text (IN VARCHAR2):
            The query text which will be used for creating cache object.
        - p_match_document (IN JSON):
            A json file containing data to be returned when calling 
            search_from_query.
        - p_related_queries (IN SYS.ODCIVARCHAR2LIST):
            List of related queries to be used for creating cache object.
        - p_namespace (IN VARCHAR2):
            Namespace for this particular report.
        - p_query_vector (IN VECTOR DEFAULT NULL):
            Optional parameter for the vector embedding of the query text.
        - p_report_id (OUT VARCHAR2):
            Unique ID of the created report.

    Exceptions:
        NONE
    ----------------------------------------------------------------------------
    */
    PROCEDURE cache_create_report (
        p_query_text            IN VARCHAR2,
        p_match_document        IN JSON,
        p_related_queries       IN SYS.ODCIVARCHAR2LIST,
        p_namespace             IN VARCHAR2,
        p_query_vector          IN VECTOR DEFAULT NULL,
        p_report_id             OUT VARCHAR2
    );

    /*
    ----------------------------------------------------------------------------
    Procedure cache_delete_report_by_id
    ----------------------------------------------------------------------------
    Description:
        This procedure is a wrapper over delete_report procedure of the package 
        lang_data_reports_pkg, and is used for deleting report objects.

    Parameters:
        - p_report_id (IN SYS.ODCIVARCHAR2LIST):
            List of report IDs to be deleted.

    Exceptions:
        NONE
    ----------------------------------------------------------------------------
    */
    PROCEDURE cache_delete_report_by_id(
        p_report_id IN SYS.ODCIVARCHAR2LIST
    );

    /*
    ----------------------------------------------------------------------
    PROCEDURE cache_purge_reports
    ----------------------------------------------------------------------
    Description:
        This procedure purges reports based on a specified timestamp and
        domain. It deletes reports that are older than the provided timestamp
        and belong to the specified domain which have hits lower than a 
        threshold.

    Parameters: 
        - p_namespace (IN VARCHAR2):
            The namespace for which reports should be purged.

        - p_timestamp (IN TIMESTAMP DEFAULT NULL):
            The timestamp before which reports should be purged. If NULL, 
            all reports are considered for purging.
        
        - p_hit_limit (IN NUMBER DEFAULT NULL):
            Reports with hits lower than this limit will be considered for 
            purging. If NULL, no limit is applied.  
        - p_action (IN VARCHAR2 DEFAULT 'COUNT'):
            The action to be performed. Allowed values are:
            - 'COUNT': Returns the number of reports that would be purged.
            - 'DELETE': Actually deletes the reports that would be purged.
            - 'ARCHIVE': Archives the reports instead of deleting them.
        - p_num_reports (OUT NUMBER):
            The number of reports that were purged.
    */
    PROCEDURE cache_purge_reports(
        p_namespace         IN VARCHAR2,
        p_timestamp         IN TIMESTAMP DEFAULT NULL,
        p_hit_limit         IN NUMBER DEFAULT NULL,
        p_action            IN VARCHAR2 DEFAULT 'COUNT',
        p_num_reports       OUT NUMBER
    );
END lang_data_semantic_cache_pkg;
/

