Rem
Rem $Header: dbgendev/src/langdata/plsql/install.sql 
Rem saloshah_dbai_311/1 2024/11/13 10:28:26 saloshah Exp $
Rem
Rem install.sql
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      install.sql - Script to install the Lang-Data PL/SQL Packages
Rem
Rem    DESCRIPTION
Rem      This script executes as part of the setup of database in Lang-Data and
Rem      installs all the required PL/SQL packages to it.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/install.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    07/28/25 - added create_types
Rem    deveverm    07/04/25 - DBAI-771: added LANGDATA_USER parameter for SQLcl
Rem    fgurrola    06/27/25 - Switch the order of named entities pkg before
Rem                           the setup pkg as the former calls the latter.
Rem    deveverm    06/25/25 - DBAI-771: Refactored test_pkgs into
Rem                           install_test.sql
Rem    arevathi    05/28/25 - Take model dir as input
Rem    jiangnhu    05/28/25 - Switch the order of setup pkg and utils pkg
Rem                           as the former calls the latter
Rem    arevathi    05/19/25 - Added role_grants procedure
Rem    pryarla     05/15/25 - DBAI-737: Install llm_pkg
Rem    deveverm    04/10/25 - DBAI-720: Set compilation flag based on
Rem                           environment
Rem    jiangnhu    04/04/25 - Switch the order of sample queries pkg and named
Rem                           entities pkg as the former calls the latter
Rem    jiangnhu    03/06/25 - Remove create_procedures.sql,
Rem                           populate_annotation_table.sql
Rem    dadoshi     02/24/25 - JIRA_DBAI578: Update to config_pkg
Rem    jiangnhu    01/17/25 - Switch the order of setup pkg and cleanup pkg as
Rem                           the former calls the latter
Rem    saloshah    11/28/24 - DBAI-327: Added annotations_pkg
Rem    deveverm    11/15/24 - JIRA_DBAI-322: fixed installation order
Rem    arevathi    11/12/24 - JIRA_DBAI345: included feedback package
Rem    deveverm    10/30/24 - JIRA_DBAI-326: added lang_data_analytics_pkg
Rem    dadoshi     10/29/24 - Update header
Rem    dadoshi     10/25/24 - Add drilldowns_pkg to install
Rem    pbagal      10/22/24 - Add doxygen comments
Rem    pryarla     10/16/24 - Created
Rem

--! @file example_pkg.pks
--! @brief This package manages user operations.
--! @author Your Name
--! @date 2024-10-23


-- WHENEVER SQLERROR EXIT FAILURE
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

DEFINE PACKAGE_ROOT = '&1'
DEFINE MODEL_DIR = '&2'
DEFINE LANGDATA_USER = '&3'

SET SERVEROUTPUT ON

ALTER SESSION SET CURRENT_SCHEMA=&LANGDATA_USER;
DECLARE
    v_cloud_service VARCHAR2(10);
BEGIN
    SELECT sys_context('USERENV', 'CLOUD_SERVICE') 
    INTO v_cloud_service FROM dual;

    IF v_cloud_service IS NOT NULL THEN
        EXECUTE IMMEDIATE 'ALTER SESSION SET PLSQL_CCFLAGS = ''Is_Cloud:true''';
    ELSE
        EXECUTE IMMEDIATE 'ALTER SESSION SET PLSQL_CCFLAGS = ''Is_Cloud:false''';
    END IF;
END;
/

@&PACKAGE_ROOT/sql/create_tables.sql
@&PACKAGE_ROOT/sql/create_types.sql

@&PACKAGE_ROOT/logging/logging_pkg.pks
@&PACKAGE_ROOT/logging/logging_pkg.pkb

@&PACKAGE_ROOT/errors/errors_pkg.pks
@&PACKAGE_ROOT/errors/errors_pkg.pkb

@&PACKAGE_ROOT/auth/auth_pkg.pks
@&PACKAGE_ROOT/auth/auth_pkg.pkb

@&PACKAGE_ROOT/config/config_pkg.pks

@&PACKAGE_ROOT/llm/llm_pkg.pks
@&PACKAGE_ROOT/llm/llm_pkg.pkb

@&PACKAGE_ROOT/config/config_pkg.pkb

@&PACKAGE_ROOT/cleanup/cleanup_pkg.pks
@&PACKAGE_ROOT/cleanup/cleanup_pkg.pkb

@&PACKAGE_ROOT/utils/utils_pkg.pks
@&PACKAGE_ROOT/utils/utils_pkg.pkb

@&PACKAGE_ROOT/named-entities/named_entities_pkg.pks
@&PACKAGE_ROOT/named-entities/named_entities_pkg.pkb

@&PACKAGE_ROOT/setup/setup_pkg.pks
@&PACKAGE_ROOT/setup/setup_pkg.pkb

EXEC lang_data_setup_pkg.init('&MODEL_DIR');

@&PACKAGE_ROOT/migration/migration_pkg.pks
@&PACKAGE_ROOT/migration/migration_pkg.pkb

@&PACKAGE_ROOT/samplequeries/samplequeries_pkg.pks
@&PACKAGE_ROOT/samplequeries/samplequeries_pkg.pkb

@&PACKAGE_ROOT/reports/reports_pkg.pks
@&PACKAGE_ROOT/reports/reports_pkg.pkb

@&PACKAGE_ROOT/drilldowns/drilldowns_pkg.pks
@&PACKAGE_ROOT/drilldowns/drilldowns_pkg.pkb

@&PACKAGE_ROOT/search/search_pkg.pks
@&PACKAGE_ROOT/search/search_pkg.pkb

@&PACKAGE_ROOT/feedback/feedback_pkg.pks
@&PACKAGE_ROOT/feedback/feedback_pkg.pkb

@&PACKAGE_ROOT/annotations/annotations_pkg.pks
@&PACKAGE_ROOT/annotations/annotations_pkg.pkb

@&PACKAGE_ROOT/analytics/analytics_pkg.pks
@&PACKAGE_ROOT/analytics/analytics_pkg.pkb

@&PACKAGE_ROOT/lang_data.pks
@&PACKAGE_ROOT/lang_data.pkb

@&PACKAGE_ROOT/sql/create_triggers.sql

EXEC lang_data_setup_pkg.grant_langdata_execution_privileges_by_role();
