Rem
Rem $Header: dbgendev/src/langdata/plsql/feedback/feedback_pkg.pks /main/5 2025/07/07 16:12:43 saloshah Exp $
Rem
Rem feedback_pkg.pls
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      feedback_pkg.pks - Package specification for feedback packages
Rem
Rem    DESCRIPTION
Rem       This package contains specifications of procedures 
Rem       for feedback for user search records.
Rem
Rem    NOTES
Rem     NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/feedback_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    saloshah    06/26/25 - DBAI-873: Added delete feedback API
Rem    arevathi    03/20/25 - Add APIs for undo accept report
Rem    arevathi    11/12/24 - Fixed errors, removed unnecessary procedures
Rem    anisbans    11/04/24 - Created
Rem
CREATE OR REPLACE PACKAGE lang_data_feedback_pkg IS

/*
    Procedure update_required_feedback_action
    ----------------------------------------------------------------------
    Description:
        Updates the `required_feedback_action` to the given value for the 
        search record identified by `p_id`. 

    Parameters:
    ----------------------------------------------------------------------
    - p_id (IN VARCHAR2):
        The unique identifier for the search record.

    - p_required_feedback_action (IN VARCHAR2):
        The new value to set for the required_feedback_action in 
        (New Report, Update Report, Pending Review, None).

    - p_error_message (IN VARCHAR2):
        Custom error message to use if search record with given id is not 
        found. If not provided, a default message is used.

    Exceptions:
    ----------------------------------------------------------------------
    - c_resource_not_found (-20004)::
        Raised when no record with the specified ID is found, A error with a 
        code -20004 is raised with a custom  error message.

    ----------------------------------------------------------------------
    Procedure update_feedback_action_priority
    ----------------------------------------------------------------------
    Description:
        Updates the `feedback_action_priority` to the given value for the 
        search record identified by `p_id`. 

    Parameters:
    ----------------------------------------------------------------------
    - p_id (IN VARCHAR2):
        The unique identifier for the search record.

    - p_feedback_action_priority (IN VARCHAR2):
        The new value to set for the `feedback_action_priority` in 
        (low, medium, high).

    - p_error_message (IN VARCHAR2):
        Custom error message to use if search record with given id is not 
        found. If not provided, a default message is used.

    Exceptions:
    ----------------------------------------------------------------------
    - c_resource_not_found (-20004)::
        Raised when no record with the specified ID is found, A error with a 
        code -20004 is raised with a custom  error message.

    ----------------------------------------------------------------------
    Procedure update_expected_report_id
    ----------------------------------------------------------------------
    Description:
        Updates the expected report id for the given search record.

    Parameters:
    ----------------------------------------------------------------------
    - p_search_id (IN VARCHAR2):
        The unique identifier for the search record.

    - p_expected_report_id (IN VARCHAR2):
        The new expected report id value to be set for the search record.

    Exceptions:
    ----------------------------------------------------------------------
    - c_invalid_parameters_code (-20002):
        Raised when the new expected_report_id matches the current value

    - c_resource_not_found (-20004)::
        Raised when no record with the specified ID is found, A error with a 
        code -20004 is raised with a custom  error message.

    ----------------------------------------------------------------------
    Procedure update_expected_drilldown_id
    ----------------------------------------------------------------------
    Description:
        Updates the expected drilldown id for the given search record.

    Parameters:
    ----------------------------------------------------------------------
    - p_search_id (IN VARCHAR2):
        The unique identifier for the search record.

    - p_expected_drilldown_id (IN VARCHAR2):
        The new expected drilldown id value to be set for the search record.

    Exceptions:
    ----------------------------------------------------------------------
    - c_invalid_parameters_code (-20002):
        Raised when the new expected_drilldown_id matches the current value

    - c_resource_not_found (-20004)::
        Raised when no record with the specified ID is found, A error with a 
        code -20004 is raised with a custom  error message.

    ----------------------------------------------------------------------
    Procedure update_feedback
    ----------------------------------------------------------------------
    Description:
        Used to share feedback information for the given search record which 
        includes feedback rating and feedback comments

    Parameters:
    ----------------------------------------------------------------------
    - p_search_id (IN VARCHAR2):
        The unique identifier for the search record.

    - p_feedback_comments (IN VARCHAR2 DEFAULT NULL):
        Comments for feedback.

    - p_feedback_rating (IN BOOLEAN DEFAULT NULL):
        Rating for feedback, must be Positive or Negative.

    Exceptions:
    ----------------------------------------------------------------------
    - c_max_text_length_exceeded (-20003):
        Raised when the given text exceeds the max length limit.
        
    - c_invalid_parameters_code (-20002):
        Raised when the given parameters are invalid. 
        Logged as an error before raising.

    ----------------------------------------------------------------------
    Procedure delete_feedback
    ----------------------------------------------------------------------
    Description:
        Used to delete feedback information for the given search record which 
        includes feedback rating and feedback comments

    Parameters:
    ----------------------------------------------------------------------
    - p_search_id (IN VARCHAR2):
        The unique identifier for the search record.

    - p_delete_rating (IN BOOLEAN DEFAULT FALSE):
        Flag to indicate whether the feedback rating should be deleted 
        (set to NULL).

    - p_delete_comments (IN BOOLEAN DEFAULT FALSE):
        Flag to indicate whether the feedback comments should be deleted 
        (set to NULL).

    Exceptions:
    ----------------------------------------------------------------------
    - c_resource_not_found (-20004):
        Raised when no record with the specified ID is found, A error with a 
        code -20004 is raised with a custom error message.
        
    - c_invalid_parameters_code (-20002):
        Raised when the given parameters are invalid. 
        Logged as an error before raising.

    ----------------------------------------------------------------------
    Procedure remove_expected_report_id
    ----------------------------------------------------------------------
    Description:
        Used to remove the expected report ID associated with the given 
        search record.

    Parameters:
    ----------------------------------------------------------------------
    - p_search_id (IN VARCHAR2):
        The unique identifier for the search record.

    Exceptions:
    ----------------------------------------------------------------------
    - c_resource_not_found (-20004)::
        Raised when no record with the specified ID is found, A error with a 
        code -20004 is raised with a custom  error message.
        

    ----------------------------------------------------------------------
    Procedure remove_expected_drilldown_id
    ----------------------------------------------------------------------
    Description:
        Used to remove the expected drilldown ID associated with the given 
        search record.

    Parameters:
    ----------------------------------------------------------------------
    - p_search_id (IN VARCHAR2):
        The unique identifier for the search record.

    Exceptions:
    ----------------------------------------------------------------------
    - c_resource_not_found (-20004)::
        Raised when no record with the specified ID is found, A error with a 
        code -20004 is raised with a custom  error message.
        
*/
    PROCEDURE update_feedback(
        p_search_id         IN VARCHAR2,
        p_feedback_comments IN VARCHAR2 DEFAULT NULL,
        p_feedback_rating   IN BOOLEAN DEFAULT NULL
    );

    PROCEDURE delete_feedback(
        p_search_id         IN VARCHAR2,
        p_delete_rating     IN BOOLEAN DEFAULT FALSE,
        p_delete_comments   IN BOOLEAN DEFAULT FALSE
    );

    PROCEDURE update_required_feedback_action (
        p_id                  IN VARCHAR2,
        p_required_feedback_action IN VARCHAR2,
        p_error_message            IN VARCHAR2 DEFAULT 'Search record not '|| 
                                                'found for the specified ID'
    );

    PROCEDURE update_expected_report_id (
        p_search_id          IN VARCHAR2,
        p_expected_report_id IN VARCHAR2
    );

    PROCEDURE update_expected_drilldown_id (
        p_search_id             IN VARCHAR2,
        p_expected_drilldown_id IN VARCHAR2
    );

    PROCEDURE update_feedback_action_priority (
        p_id                  IN VARCHAR2,
        p_feedback_action_priority IN VARCHAR2,
        p_error_message       IN VARCHAR2 DEFAULT 'Search record not found'|| 
                                                'for the specified ID'
    );

    PROCEDURE remove_expected_report_id (
        p_search_id          IN VARCHAR2
    );

    PROCEDURE remove_expected_drilldown_id (
        p_search_id             IN VARCHAR2
    );
    
END lang_data_feedback_pkg;
/


