Rem
Rem $Header: dbgendev/src/langdata/plsql/config/config_pkg.pks /main/10 2025/08/13 01:29:21 jiangnhu Exp $
Rem
Rem config_pkg.pls
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      config_pkg.pks - LangData Config Package
Rem
Rem    DESCRIPTION
Rem      This package contains specifications of procedures and functions
Rem      to manage the configuration of LangData.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/config/config_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dadoshi     07/30/25 - Add optional mount dir parameter to populate
Rem                           procedure for SQLcl
Rem    jiangnhu    07/16/25 - Add p_genAI_rerank_endpoint_id in 
Rem                           set_oci_credential
Rem    anisbans    07/03/25 - DBAI-878: Remove config_tablespace_limits
Rem    fgurrola    06/27/25 - DBAI-776: Adding global variable to disable
Rem                           custom name entities.
Rem    deveverm    06/02/25 - DBAI-794: modified set_oci_credential to take
Rem                           genAI endpoint
Rem    dadoshi     05/05/25 - JIRA_DBAI777: Add documentation
Rem    deveverm    04/10/25 - DBAI-721: added set_oci_credential
Rem    arevathi    03/07/25 - Add config_tablespace_limits Procedure
Rem    dadoshi     02/24/25 - Created
/*
--------------------------------------------------------------------------------
Package Name: lang_data_config_pkg
Description: This package contains procedures related to the configuration
parameters used in various LangData APIs. These procedures are designed to 
handle CRUD operations on these parameters.
--------------------------------------------------------------------------------
*/
CREATE OR REPLACE PACKAGE lang_data_config_pkg IS
    /*
    ----------------------------------------------------------------------------
    Procedure populate_config_table
    ----------------------------------------------------------------------------
    Description:
        This procedure populates the langdata$config table with all the 
        required configuration parameters with their default values.

    Parameters:
        - p_mount_dir (IN VARCHAR2 DEFAULT ''):
            Path to mount directory.

    Exceptions:
        NONE
    ----------------------------------------------------------------------------
    */
    PROCEDURE populate_config_table (
        p_mount_dir     IN varchar2 default ''
    );

    /*
    ----------------------------------------------------------------------------
    Function get_config_variable_names
    ----------------------------------------------------------------------------
    Description:
        This function returns the list of the names of the configuration 
        parameters, concatenated as a string.

    Parameters:
        NONE

    Returns (VARCHAR2):
        List of comma-seperated configuration parameter names as a string.

    Exceptions:
        NONE
    ----------------------------------------------------------------------------
    */
    FUNCTION get_config_variable_names
    RETURN VARCHAR2;

    /*
    ----------------------------------------------------------------------------
    Function get_config_parameter
    ----------------------------------------------------------------------------
    Description:
        This function returns the value of a configuration parameter based on
        the given name of the configuration parameter.

    Parameters:
        - p_name (IN VARCHAR2):
            Name of the configuration parameter.

    Returns:
        Value of the configuration parameter.

    Exceptions:
        - c_resource_not_found (-20004):
            Raised when no report is found for the given report ID. A custom 
            error with code -20004 is raised, using the lang_data_errors_pkg 
            package, with the message "Resource not found".
    ----------------------------------------------------------------------------
    */
    FUNCTION get_config_parameter (
        p_name IN VARCHAR2
    ) RETURN VARCHAR2;

    /*
    ----------------------------------------------------------------------------
    Procedure update_config_parameter
    ----------------------------------------------------------------------------
    Description:
        This procedure updates the value of the given configuration parameter to
        the one provided.

    Parameters:
        - p_name (IN VARCHAR2):
            Name of the configuration parameter.

        - p_value (IN VARCHAR2):
            New value of the configuration parameter.

    Exceptions:
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20000 using the lang_data_errors_pkg
            package.

        - c_invalid_parameters_code (-20002):
            Raised when the report or description parameters are invalid. 
            Logged as an error before raising.

        - c_resource_not_found (-20004):
            Raised when no report is found for the given report ID. A custom 
            error with code -20004 is raised, using the lang_data_errors_pkg 
            package, with the message "Resource not found".
    ----------------------------------------------------------------------------
    */
    PROCEDURE update_config_parameter (
        p_name IN VARCHAR2,
        p_value IN VARCHAR2
    );

    /*
    ----------------------------------------------------------------------------
    Function set_oci_credential
    ----------------------------------------------------------------------------
    Description:
        This function updates all the config parameters needed for OCI calls 
        for the following functionalities:
            - Named Entity_Recognition
            - Embedding Generation
        This function is a safe way of updating OCI config parameters as it 
        validates that the configs are working with OCI before updating it in 
        langdata.
    Parameters:
        - p_cred_name (IN VARCHAR2):
            Credential Name to use for OCI requests.

        - p_compartment_id (IN VARCHAR2):
            Compartment OCID having AI language services and Generative AI 
            inference service enabled.

        - p_region_code (IN VARCHAR2):
            OCI region code to use for OCI requests.
        
        - p_genAI_endpoint (IN VARCHAR2):
            OCI endpoint to use for genAI services.
            For example:
                https://inference.generativeai.us-chicago-1.oci.oraclecloud.com 

        - p_genAI_rerank_endpoint_id (IN VARCHAR2):
            The OCID of the Generative AI Dedicated Endpoint to be used for 
            model inference requests (e.g., rerank with `cohere.rerank.3-5`).
            This value will be used as `servingMode.endpointId` when invoking 
            dedicated models.
            For example:
                ocid1.generativeaiendpoint.oc1.us-chicago-1.aaaaaaaaxxxxxxx

    Exceptions:
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20000 using the lang_data_errors_pkg
            package.

        - c_invalid_parameters_code (-20002):
            Raised when one of the parameters is invalid.
    ----------------------------------------------------------------------------
    */
    FUNCTION set_oci_credential (
        p_cred_name IN VARCHAR2,
        p_compartment_id IN VARCHAR2,
        p_region_code IN VARCHAR2,
        p_genAI_endpoint IN VARCHAR2,
        p_genAI_rerank_endpoint_id IN VARCHAR2
    ) RETURN VARCHAR2;

    -- Global variable to disable custom entities.
    g_custom_entities   BOOLEAN := FALSE;
    
END lang_data_config_pkg;
/


