/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICModel;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.CertificateProcessor;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;
import oracle.jdbc.OracleCallableStatement;
import oracle.security.pki.OracleWallet;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class BICStubs {
    protected static Map<Id, String> booleanBinds = new LinkedHashMap<Id, String>();
    protected static LinkedHashMap<Id, String> outputBindsAndFiles = new LinkedHashMap();
    protected static Boolean isSelectorPresent = false;

    protected static String getQuery(String id, Connection conn, String path) {
        QueryXMLSupport xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(CertificateProcessor.class.getClassLoader(), path));
        Query q = xml.getQuery(id, conn);
        return q == null ? null : q.getSql();
    }

    protected static LinkedHashMap<Id, Object> collectOptionValue(BICModel model, ParsedCommand parsedCommand, LinkedHashMap<Id, Object> binds, LinkedHashSet<Id> InVar, HashSet<Id> OutBinds, HashSet<Id> OutFiles) throws BICException {
        String value;
        List options = parsedCommand.getType().getOptions();
        booleanBinds.clear();
        outputBindsAndFiles.clear();
        ArrayList<Id> optionIds = new ArrayList<Id>();
        for (Option opt : options) {
            optionIds.add(opt.getId());
        }
        for (Id curInVarIteratorVal : InVar) {
            if (optionIds.contains(curInVarIteratorVal)) {
                if (((Option)options.get(optionIds.indexOf(curInVarIteratorVal))).isFlag()) {
                    Boolean val = (Boolean)parsedCommand.getOptionValue(curInVarIteratorVal);
                    booleanBinds.put(curInVarIteratorVal, Boolean.toString(val));
                    continue;
                }
                if (parsedCommand.getOptionValue(curInVarIteratorVal) != null && parsedCommand.getOptionValue(curInVarIteratorVal).toString().startsWith(":")) {
                    try {
                        String optVal = ((Bind)model.getContext().getVarMap().get(parsedCommand.getOptionValue(curInVarIteratorVal).toString().substring(1).toUpperCase())).getValue();
                        if (optVal == null) {
                            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.EMPTY_BIND_VARIABLE"), parsedCommand.getOptionValue(curInVarIteratorVal).toString(), ((Option)options.get(optionIds.indexOf(curInVarIteratorVal))).getName())});
                        }
                        if (curInVarIteratorVal == BICOptions.tableName_immutable_req.getId() || curInVarIteratorVal == BICOptions.tableName_blockchain_req.getId()) {
                            binds = BICStubs.normalizeTableName(binds, model, optVal, curInVarIteratorVal);
                            continue;
                        }
                        binds.put(curInVarIteratorVal, optVal);
                        continue;
                    }
                    catch (NullPointerException e) {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_BIND_VARIABLE"), parsedCommand.getOptionValue(curInVarIteratorVal).toString(), ((Option)options.get(optionIds.indexOf(curInVarIteratorVal))).getName())});
                    }
                }
                if (curInVarIteratorVal == BICOptions.tableName_immutable_req.getId() || curInVarIteratorVal == BICOptions.tableName_blockchain_req.getId()) {
                    binds = BICStubs.normalizeTableName(binds, model, (String)parsedCommand.getOptionValue(curInVarIteratorVal), curInVarIteratorVal);
                    continue;
                }
                binds.put(curInVarIteratorVal, parsedCommand.getOptionValue(curInVarIteratorVal));
                continue;
            }
            binds.put(curInVarIteratorVal, "");
        }
        if (OutBinds != null) {
            for (Id curOutBindsIteratorVal : OutBinds) {
                if (!optionIds.contains(curOutBindsIteratorVal)) continue;
                value = (String)parsedCommand.getOptionValue(curOutBindsIteratorVal);
                if (value != null && value.startsWith(":")) {
                    if (!model.getContext().getVarMap().containsKey(value.substring(1).toUpperCase())) {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_BIND_VARIABLE"), value, ((Option)options.get(optionIds.indexOf(curOutBindsIteratorVal))).getName())});
                    }
                    outputBindsAndFiles.put(curOutBindsIteratorVal, value.substring(1).toUpperCase());
                    continue;
                }
                if (value == null || value.startsWith(":")) continue;
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_BIND_VARIABLE"), value, ((Option)options.get(optionIds.indexOf(curOutBindsIteratorVal))).getName())});
            }
        }
        if (OutFiles != null) {
            for (Id curOutFilesIteratorVal : OutFiles) {
                if (!optionIds.contains(curOutFilesIteratorVal)) continue;
                value = (String)parsedCommand.getOptionValue(curOutFilesIteratorVal);
                if (value != null && value.startsWith(":")) {
                    if (!model.getContext().getVarMap().containsKey(value.substring(1).toUpperCase())) {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_BIND_VARIABLE"), value, ((Option)options.get(optionIds.indexOf(curOutFilesIteratorVal))).getName())});
                    }
                    outputBindsAndFiles.put(curOutFilesIteratorVal, String.valueOf(model.getContext().getVarMap().get(value.substring(1).toUpperCase())));
                    continue;
                }
                if (value == null || value.startsWith(":")) continue;
                outputBindsAndFiles.put(curOutFilesIteratorVal, value);
            }
        }
        return binds;
    }

    protected static CallableStatement bind(CallableStatement statement, List<Object> binds) throws BICException {
        int bindIdx = 1;
        try {
            if (binds != null) {
                for (Object bind : binds) {
                    if (bind == BICOptions.NULL_OBJECT || bind instanceof String && bind.equals("")) {
                        statement.setNull(bindIdx, 12);
                    } else if (bind instanceof String) {
                        statement.setString(bindIdx, (String)bind);
                    } else if (bind instanceof BigDecimal) {
                        statement.setBigDecimal(bindIdx, (BigDecimal)bind);
                    } else if (bind instanceof Date) {
                        statement.setDate(bindIdx, (Date)bind);
                    } else if (bind instanceof Integer) {
                        statement.setInt(bindIdx, (int)((Integer)bind));
                    } else if (bind instanceof Array) {
                        statement.setArray(bindIdx, (Array)bind);
                    } else if (bind instanceof Blob) {
                        statement.setBlob(bindIdx, (Blob)bind);
                    } else if (bind instanceof Boolean) {
                        statement.setBoolean(bindIdx, (boolean)((Boolean)bind));
                    } else if (bind instanceof Byte) {
                        statement.setByte(bindIdx, (byte)((Byte)bind));
                    } else if (bind instanceof byte[]) {
                        statement.setBytes(bindIdx, (byte[])bind);
                    } else if (bind instanceof Clob) {
                        statement.setClob(bindIdx, (Clob)bind);
                    } else if (bind instanceof Double) {
                        statement.setDouble(bindIdx, (double)((Double)bind));
                    } else if (bind instanceof Float) {
                        statement.setFloat(bindIdx, ((Float)bind).floatValue());
                    } else if (bind instanceof Long) {
                        statement.setLong(bindIdx, (long)((Long)bind));
                    } else if (bind instanceof NClob) {
                        statement.setNClob(bindIdx, (NClob)bind);
                    } else if (bind instanceof Ref) {
                        statement.setRef(bindIdx, (Ref)bind);
                    } else if (bind instanceof RowId) {
                        statement.setRowId(bindIdx, (RowId)bind);
                    } else if (bind instanceof Short) {
                        statement.setShort(bindIdx, (short)((Short)bind));
                    } else if (bind instanceof SQLXML) {
                        statement.setSQLXML(bindIdx, (SQLXML)bind);
                    } else if (bind instanceof Time) {
                        statement.setTime(bindIdx, (Time)bind);
                    } else if (bind instanceof Timestamp) {
                        statement.setTimestamp(bindIdx, Timestamp.valueOf(bind.toString()));
                    } else if (bind instanceof URL) {
                        statement.setURL(bindIdx, (URL)bind);
                    } else {
                        statement.setObject(bindIdx, bind);
                    }
                    ++bindIdx;
                }
            }
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return statement;
    }

    protected static String parseStringFromFile(String fileName, String optionName) throws BICException {
        String result;
        try {
            result = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_FILE_PATH"), fileName, optionName)});
        }
        return result;
    }

    protected static void writeBlobToFile(Blob blob, String outputFile, String optionName) throws BICException {
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            int nRead;
            InputStream is = blob.getBinaryStream();
            byte[] buf = new byte[8192];
            while ((nRead = is.read(buf, 0, buf.length)) != -1) {
                ((OutputStream)out).write(buf, 0, nRead);
            }
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_FILE_PATH"), outputFile, optionName)});
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
    }

    protected static byte[] convertBlobToByteArray(Blob blob) throws BICException {
        byte[] bytes = null;
        try {
            int bytesRead;
            if (blob == null) {
                return null;
            }
            InputStream is = blob.getBinaryStream();
            int blobLength = (int)blob.length();
            bytes = new byte[blobLength];
            int chunkSize = 8192;
            int offset = 0;
            byte[] chunk = new byte[chunkSize];
            while ((bytesRead = is.read(chunk)) != -1) {
                System.arraycopy(chunk, 0, bytes, offset, bytesRead);
                offset += bytesRead;
            }
            is.close();
        }
        catch (Exception e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return bytes;
    }

    protected static void writeSignatureBytesToFile(Blob blob, String outputFile) throws BICException {
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            int nRead;
            InputStream is = blob.getBinaryStream();
            byte[] buf = new byte[8192];
            while ((nRead = is.read(buf, 0, buf.length)) != -1) {
                ((OutputStream)out).write(buf, 0, nRead);
            }
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.SIGNATURE_BYTES_NOT_SAVED"), new Object[0])});
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
    }

    protected static Blob parseBlobFromBFile(BICModel model, String fileName, String optionName) throws BICException {
        Blob blob;
        File file = new File(fileName);
        try (FileInputStream fis = new FileInputStream(file);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int nRead;
            byte[] fileData = new byte[8192];
            blob = model.getConnection().createBlob();
            while ((nRead = fis.read(fileData)) != -1) {
                outputStream.write(fileData, 0, nRead);
            }
            blob.setBytes(1L, outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_FILE_PATH"), fileName, optionName)});
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return blob;
    }

    protected static RAW binaryFileToRaw(String fileName, String optionName) throws BICException {
        RAW rawValue;
        int bufferSize = 8192;
        File file = new File(fileName);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int bytesRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            rawValue = new RAW(os.toByteArray());
        }
        catch (FileNotFoundException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_FILE_PATH"), fileName, optionName)});
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return rawValue;
    }

    protected static RAW signatureFileToRaw(String fileName) throws BICException {
        RAW rawValue;
        int bufferSize = 8192;
        File file = new File(fileName);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int bytesRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            rawValue = new RAW(os.toByteArray());
        }
        catch (FileNotFoundException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.SIGNATURE_FILE_NOT_FOUND"), new Object[0])});
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return rawValue;
    }

    protected static RAW hexToRaw(String input) throws BICException {
        input = input.replaceAll("\\s+", "");
        byte[] rawData = new byte[input.length() / 2];
        try {
            for (int i = 0; i < input.length(); i += 2) {
                byte value;
                String hexByte = input.substring(i, i + 2);
                rawData[i / 2] = value = (byte)Integer.parseInt(hexByte, 16);
            }
        }
        catch (Exception e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return new RAW(rawData);
    }

    protected static String byteArrayToHex(byte[] input) {
        StringBuilder sb = new StringBuilder();
        for (byte b : input) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    protected static byte[] hexToByteArray(String input) {
        int len = input.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(input.charAt(i), 16) << 4) + Character.digit(input.charAt(i + 1), 16));
        }
        return data;
    }

    protected static Blob parseBlobFromFile(BICModel model, String inputFile, String optionName) throws BICException {
        Blob res;
        File file = new File(inputFile);
        try (FileInputStream in = new FileInputStream(file);){
            int bytesRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            res = model.getConnection().createBlob();
            res.setBytes(1L, os.toByteArray());
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_FILE_PATH"), inputFile, optionName)});
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return res;
    }

    protected static void writeStringToFile(String data, String outputFile, String optionName) throws BICException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.write(data);
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_FILE_PATH"), outputFile, optionName)});
        }
    }

    protected static void writeRAWToFile(RAW data, String outputFile, String optionName) throws BICException, SQLException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            byte[] rawDataBytes = data.getBytes();
            bufferedOutputStream.write(rawDataBytes);
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_FILE_PATH"), outputFile, optionName)});
        }
    }

    protected static LinkedHashMap<Id, Object> normalizeTableName(LinkedHashMap<Id, Object> binds, BICModel model, String tableName, Id curInVarIteratorVal) throws BICException {
        int dotIndex = BICStubs.findUnquotedPeriod(tableName);
        if (dotIndex == -1) {
            try {
                binds.put(BICOptions.schema.getId(), "\"" + model.getConnection().getSchema() + "\"");
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            if (curInVarIteratorVal == BICOptions.tableName_immutable_req) {
                binds.put(BICOptions.tableName_immutable_req.getId(), tableName);
            } else {
                binds.put(BICOptions.tableName_blockchain_req.getId(), tableName);
            }
        } else {
            binds.put(BICOptions.schema.getId(), tableName.substring(0, dotIndex));
            if (curInVarIteratorVal == BICOptions.tableName_immutable_req) {
                binds.put(BICOptions.tableName_immutable_req.getId(), tableName.substring(dotIndex + 1));
            } else {
                binds.put(BICOptions.tableName_blockchain_req.getId(), tableName.substring(dotIndex + 1));
            }
        }
        return binds;
    }

    public static int findUnquotedPeriod(String input) {
        boolean insideQuote = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                insideQuote = !insideQuote;
                continue;
            }
            if (c != '.' || insideQuote) continue;
            return i;
        }
        return -1;
    }

    protected static JsonObject convertOracleSQLStructToJson(STRUCT struct) throws SQLException {
        StructDescriptor structDescriptor = struct.getDescriptor();
        int attributeCount = structDescriptor.getMetaData().getColumnCount();
        Object[] attributeValues = struct.getAttributes();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (int i = 1; i <= attributeCount; ++i) {
            Object attributeValue = attributeValues[i - 1];
            if (attributeValue instanceof STRUCT) {
                jsonObjectBuilder.add(structDescriptor.getMetaData().getColumnName(i), (JsonValue)BICStubs.convertOracleSQLStructToJson((STRUCT)attributeValue));
                continue;
            }
            if (attributeValue instanceof byte[]) {
                byte[] byteArray = (byte[])attributeValue;
                RAW rawValue = new RAW(byteArray);
                jsonObjectBuilder.add(structDescriptor.getMetaData().getColumnName(i), rawValue.stringValue());
                continue;
            }
            jsonObjectBuilder.add(structDescriptor.getMetaData().getColumnName(i), attributeValue != null ? attributeValue.toString() : null);
        }
        return jsonObjectBuilder.build();
    }

    protected static String generateUniqueName(String baseName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String timestamp = sdf.format(new java.util.Date());
        return baseName + "_" + timestamp;
    }

    protected static LinkedHashMap<Id, Object> positionOrKeyCol(LinkedHashMap<Id, Object> binds, ParsedCommand parsedCommand, int dbMajorVersion) throws BICException {
        ArrayList<String> errorsPos = BICStubs.validatePosition(parsedCommand);
        ArrayList<String> errorsKc = BICStubs.validateKc(parsedCommand);
        if (errorsPos.size() == 3 && errorsKc.size() == 0) {
            if (dbMajorVersion >= 23) {
                binds.remove(BICOptions.instance_id.getId());
                binds.remove(BICOptions.chain_id.getId());
                binds.remove(BICOptions.sequence_id.getId());
            }
        } else if (errorsPos.size() == 0 && errorsKc.size() == 2) {
            binds.remove(BICOptions.keycol1_name.getId());
            binds.remove(BICOptions.keycol1_value.getId());
            binds.remove(BICOptions.keycol2_name.getId());
            binds.remove(BICOptions.keycol2_value.getId());
            binds.remove(BICOptions.keycol3_name.getId());
            binds.remove(BICOptions.keycol3_value.getId());
        } else {
            if (errorsPos.size() == 3 && errorsKc.size() == 2 || errorsPos.size() == 0 && errorsKc.size() == 0) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MISSING_BOTH_POSITION_KEYCOL"), BICOptions.instance_id.getName(), BICOptions.chain_id.getName(), BICOptions.sequence_id.getName(), BICOptions.keycol1_name.getName(), BICOptions.keycol1_value.getName())});
            }
            if (errorsPos.size() == 3 && errorsKc.size() != 2) {
                throw new BICException(errorsKc.toArray(new String[0]));
            }
            if (errorsPos.size() != 3 && errorsKc.size() == 2) {
                throw new BICException(errorsPos.toArray(new String[0]));
            }
            if (errorsPos.size() != 3 && errorsKc.size() != 2) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MISSING_BOTH_POSITION_KEYCOL"), BICOptions.instance_id.getName(), BICOptions.chain_id.getName(), BICOptions.sequence_id.getName(), BICOptions.keycol1_name.getName(), BICOptions.keycol1_value.getName())});
            }
        }
        return binds;
    }

    private static ArrayList<String> validateKc(ParsedCommand parsedCommand) {
        ArrayList<String> errors = new ArrayList<String>();
        if (parsedCommand.getOptionValue(BICOptions.keycol1_name.getId()) == null) {
            errors.add(String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.keycol1_name.getName()));
        }
        if (parsedCommand.getOptionValue(BICOptions.keycol1_value.getId()) == null) {
            errors.add(String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.keycol1_value.getName()));
        }
        if (errors.size() != 0) {
            if (!(parsedCommand.getOptionValue(BICOptions.keycol2_name.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.keycol2_value.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.keycol3_name.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.keycol3_value.getId()).equals(""))) {
                errors.clear();
                errors.add(String.format(Messages.getString("BICEXP.INVALID_KEY_COLUMN_FORMAT"), "' 1 '"));
            }
            return errors;
        }
        if (parsedCommand.getOptionValue(BICOptions.keycol2_name.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.keycol2_value.getId()).equals("")) {
            if (!parsedCommand.getOptionValue(BICOptions.keycol3_name.getId()).equals("") || !parsedCommand.getOptionValue(BICOptions.keycol3_value.getId()).equals("")) {
                errors.add(String.format(Messages.getString("BICEXP.INVALID_KEY_COLUMN_FORMAT"), "' 2 '"));
            }
            return errors;
        }
        if (!parsedCommand.getOptionValue(BICOptions.keycol2_name.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.keycol2_value.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.keycol2_name.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.keycol2_value.getId()).equals("")) {
            if (!parsedCommand.getOptionValue(BICOptions.keycol3_name.getId()).equals("") || !parsedCommand.getOptionValue(BICOptions.keycol3_value.getId()).equals("")) {
                errors.add(String.format(Messages.getString("BICEXP.INVALID_KEY_COLUMN_FORMAT"), "' 2 '"));
                return errors;
            }
            errors.add(String.format(Messages.getString("BICEXP.MISSING_OPTIONAL_PARAMETER_PAIRS"), BICOptions.keycol2_name.getName(), BICOptions.keycol2_value.getName()));
            return errors;
        }
        if (!parsedCommand.getOptionValue(BICOptions.keycol3_name.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.keycol3_value.getId()).equals("") || parsedCommand.getOptionValue(BICOptions.keycol3_name.getId()).equals("") && !parsedCommand.getOptionValue(BICOptions.keycol3_value.getId()).equals("")) {
            errors.add(String.format(Messages.getString("BICEXP.MISSING_OPTIONAL_PARAMETER_PAIRS"), BICOptions.keycol3_name.getName(), BICOptions.keycol3_value.getName()));
        }
        return errors;
    }

    private static ArrayList<String> validatePosition(ParsedCommand parsedCommand) {
        ArrayList<String> errors = new ArrayList<String>();
        if (parsedCommand.getOptionValue(BICOptions.instance_id.getId()) == null) {
            errors.add(String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.instance_id.getName()));
        }
        if (parsedCommand.getOptionValue(BICOptions.chain_id.getId()) == null) {
            errors.add(String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.chain_id.getName()));
        }
        if (parsedCommand.getOptionValue(BICOptions.sequence_id.getId()) == null) {
            errors.add(String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.sequence_id.getName()));
        }
        return errors;
    }

    public static LinkedHashMap<Id, Object> findPosition(LinkedHashMap<Id, Object> binds, BICModel model, ParsedCommand parsedCommand) throws BICException {
        String query = BICStubs.getQuery("KEY_COLUMN_QUERY", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/blockchainQueriesP2.xml");
        String whereClause = BICStubs.whereClauseForKC(parsedCommand);
        try (Statement stmt = model.getConnection().createStatement();){
            SQLException e;
            if (query != null) {
                ResultSet response = stmt.executeQuery(String.format(query, parsedCommand.getOptionValue(BICOptions.tableName_blockchain_req.getId()), whereClause));
                if (!response.next()) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.NO_DATA_FOUND_KC"), parsedCommand.getOptionValue(BICOptions.tableName_blockchain_req.getId()), whereClause)});
                }
                binds.put(BICOptions.instance_id.getId(), response.getString("ORABCTAB_INST_ID$"));
                binds.put(BICOptions.chain_id.getId(), response.getString("ORABCTAB_CHAIN_ID$"));
                binds.put(BICOptions.sequence_id.getId(), response.getString("ORABCTAB_SEQ_NUM$"));
                if (response.next()) {
                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MULTIPLE_ROWS_FOUND"), parsedCommand.getOptionValue(BICOptions.tableName_blockchain_req.getId()), whereClause)});
                }
            }
            if ((e = DBUtil.getInstance((Connection)model.getConnection()).getLastException()) != null) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.FIND_POSITION_ERROR"), parsedCommand.getOptionValue(BICOptions.tableName_blockchain_req.getId()), whereClause, e.getMessage())});
        }
        return binds;
    }

    public static String whereClauseForKC(ParsedCommand parsedCommand) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append((String)parsedCommand.getOptionValue(BICOptions.keycol1_name.getId())).append(" = '").append((String)parsedCommand.getOptionValue(BICOptions.keycol1_value.getId())).append("'");
        if (!parsedCommand.getOptionValue(BICOptions.keycol2_name.getId()).equals("")) {
            whereClause.append(" AND ").append((String)parsedCommand.getOptionValue(BICOptions.keycol2_name.getId())).append(" = '").append((String)parsedCommand.getOptionValue(BICOptions.keycol2_value.getId())).append("'");
        }
        if (!parsedCommand.getOptionValue(BICOptions.keycol3_name.getId()).equals("")) {
            whereClause.append(" AND ").append((String)parsedCommand.getOptionValue(BICOptions.keycol3_name.getId())).append(" = '").append((String)parsedCommand.getOptionValue(BICOptions.keycol3_value.getId())).append("'");
        }
        return whereClause.toString();
    }

    public static void populateBindVariableStringValue(BICModel model, Option<Object> option, String value) throws BICException {
        if (outputBindsAndFiles.get(option.getId()) != null) {
            Bind bind;
            try {
                bind = (Bind)model.getContext().getVarMap().get(outputBindsAndFiles.get(option.getId()).toUpperCase());
            }
            catch (NullPointerException e) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_BIND_VARIABLE"), outputBindsAndFiles.get(option.getId()), option.getName())});
            }
            bind.setValue(value);
            model.getContext().getVarMap().put(outputBindsAndFiles.get(option.getId()).toUpperCase(), bind);
        }
    }

    public static String generateSignatureForSignRow(String signatureAlgo, String privateKeyPath, String signatureBytesFileName) throws BICException {
        String generatedsignatureFileName;
        try {
            ProcessBuilder checkOpenSSL = new ProcessBuilder("openssl", "version");
            checkOpenSSL.redirectErrorStream(true);
            Process opensslProcess = checkOpenSSL.start();
            int exitCode = opensslProcess.waitFor();
            if (exitCode != 0) {
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.OPENSSL_CHECK"), new Object[0])});
            }
            generatedsignatureFileName = BICStubs.generateUniqueName("row_sig") + ".dat";
            ProcessBuilder generateSignature = new ProcessBuilder("openssl", "dgst", "-" + signatureAlgo, "-sign", privateKeyPath, "-out", generatedsignatureFileName, signatureBytesFileName);
            generateSignature.redirectErrorStream(true);
            Process signatureGenerationProcess = generateSignature.start();
            exitCode = signatureGenerationProcess.waitFor();
            if (exitCode != 0) {
                String line;
                InputStream errorStream = signatureGenerationProcess.getInputStream();
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
                StringBuilder error = new StringBuilder();
                while ((line = errorReader.readLine()) != null) {
                    error.append(line);
                }
                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.OPENSSL_ERROR"), error)});
            }
        }
        catch (IOException e) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.OPENSSL_ERROR"), e)});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.OPENSSL_ERROR"), e)});
        }
        return generatedsignatureFileName;
    }

    protected static ArrayList<String> modifyTableName(String tableName) {
        int dotIndex = BICStubs.findUnquotedPeriod(tableName);
        ArrayList<String> names = new ArrayList<String>();
        if (dotIndex == -1) {
            tableName = tableName.contains("\"") ? tableName.substring(1, tableName.length() - 1) : tableName.toUpperCase();
            names.add(tableName);
        } else {
            String schema_name = tableName.substring(0, dotIndex);
            tableName = (tableName = tableName.substring(dotIndex + 1)).contains("\"") ? tableName.substring(1, tableName.length() - 1) : tableName.toUpperCase();
            names.add(tableName);
            schema_name = schema_name.contains("\"") ? schema_name.substring(1, schema_name.length() - 1) : schema_name.toUpperCase();
            names.add(schema_name);
        }
        return names;
    }

    protected static Boolean validateTable(BICModel model, ParsedCommand parsedCommand, Id tableNameID, String type, String bindTableName) throws BICException {
        String query = null;
        if (type.equals("IMMUTABLE")) {
            query = BICStubs.getQuery("TABLE_CHECK_IT", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/DDL.xml");
        } else if (type.equals("BLOCKCHAIN")) {
            query = BICStubs.getQuery("TABLE_CHECK_BT", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/DDL.xml");
        }
        int count = -1;
        try (Statement stmt1 = model.getConnection().createStatement();){
            String schema_name;
            String table_name;
            ArrayList<String> temp;
            if (bindTableName != null) {
                temp = BICStubs.modifyTableName(bindTableName);
                table_name = temp.get(0);
                schema_name = temp.size() > 1 ? temp.get(1) : model.getConnection().getSchema();
            } else {
                temp = BICStubs.modifyTableName((String)parsedCommand.getOptionValue(tableNameID));
                table_name = temp.get(0);
                String string = schema_name = temp.size() > 1 ? temp.get(1) : model.getConnection().getSchema();
            }
            if (query != null) {
                query = String.format(query, table_name, schema_name);
            }
            ResultSet response = stmt1.executeQuery(query);
            while (response.next()) {
                count = response.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return count == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Blob loadCertificateFromWallet(BICModel model, String walletPath, char[] walletPassword, String walletCertificateAlias) throws BICException {
        Blob blob = null;
        try {
            if (walletPassword == null || walletPassword == BICOptions.NULL_OBJECT || walletPassword.equals("")) {
                Console console = System.console();
                if (console == null) {
                    throw new BICException(new String[]{Messages.getString("BICEXP.CONSOLE_ERROR")});
                }
                walletPassword = console.readPassword(Messages.getString("BICEXP.WALLET_PASSWORD_PROMPT"), new Object[0]);
            }
            OracleWallet wallet = new OracleWallet();
            wallet.open(walletPath, walletPassword);
            KeyStore keyStore = wallet.getKeyStore();
            Certificate cert = null;
            if (!walletCertificateAlias.equals("")) {
                if (!keyStore.isCertificateEntry(walletCertificateAlias)) throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_CERTIFICATE_2"), walletCertificateAlias)});
                cert = keyStore.getCertificate(walletCertificateAlias);
                if (!(cert instanceof X509Certificate)) throw new BICException(new String[]{Messages.getString("BICEXP.X509_CERTIFICATE")});
                X509Certificate walletCertificate = (X509Certificate)cert;
                if (!BICStubs.isX509CertValid(walletCertificate)) throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_CERTIFICATE"), walletCertificateAlias)});
                blob = BICStubs.loadCertificatFromWalletInt(model, walletCertificate);
                return blob;
            } else {
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate walletCertificate;
                    String alias = aliases.nextElement();
                    if (!keyStore.isCertificateEntry(alias) || !((cert = keyStore.getCertificate(alias)) instanceof X509Certificate) || !BICStubs.isX509CertValid(walletCertificate = (X509Certificate)cert)) continue;
                    if (BICStubs.areMultipleX509ValidCertificates(keyStore, aliases)) {
                        throw new BICException(new String[]{Messages.getString("BICEXP.MULTIPLE_CERTIFICATES")});
                    }
                    blob = BICStubs.loadCertificatFromWalletInt(model, walletCertificate);
                    break;
                }
                if (blob != null) return blob;
                throw new BICException(new String[]{Messages.getString("BICEXP.INVALID_CERTIFICATE_3")});
            }
        }
        catch (Exception e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        finally {
            Arrays.fill(walletPassword, '\u0000');
        }
    }

    public static boolean isX509CertValid(X509Certificate cert) {
        try {
            cert.checkValidity();
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static boolean areMultipleX509ValidCertificates(KeyStore keyStore, Enumeration<String> aliases) throws BICException {
        try {
            X509Certificate walletCertificate;
            Certificate cert;
            String alias = aliases.nextElement();
            if (keyStore.isCertificateEntry(alias) && (cert = keyStore.getCertificate(alias)) instanceof X509Certificate && BICStubs.isX509CertValid(walletCertificate = (X509Certificate)cert)) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return Boolean.FALSE;
    }

    public static Blob loadCertificatFromWalletInt(BICModel model, X509Certificate cert) throws BICException {
        Blob blob = null;
        try {
            byte[] certBytes = cert.getEncoded();
            ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
            blob = model.getConnection().createBlob();
            byte[] chunk = new byte[8192];
            int bytesRead = 0;
            OutputStream os = blob.setBinaryStream(1L);
            while ((bytesRead = bais.read(chunk)) != -1) {
                os.write(chunk, 0, bytesRead);
            }
            os.close();
        }
        catch (Exception e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        return blob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RAW generateSignatureUsingWallet(BICModel model, String walletPath, char[] walletPassword, char[] prvtKeyPassword, String prvtKeyAlias, String certificateId, Blob signatureBytes, String signatureAlgorithm) throws BICException {
        Key privateKey;
        byte[] generatedSignature;
        block32: {
            generatedSignature = null;
            privateKey = null;
            try {
                if (walletPassword == BICOptions.NULL_OBJECT || walletPassword == null || walletPassword.equals("")) {
                    Console console = System.console();
                    if (console == null) {
                        throw new BICException(new String[]{Messages.getString("BICEXP.CONSOLE_ERROR")});
                    }
                    walletPassword = console.readPassword(Messages.getString("BICEXP.WALLET_PASSWORD_PROMPT"), new Object[0]);
                }
                OracleWallet wallet = new OracleWallet();
                wallet.open(walletPath, walletPassword);
                KeyStore keyStore = wallet.getKeyStore();
                Enumeration<String> aliases = keyStore.aliases();
                String finalAlias = null;
                if (prvtKeyAlias == null || prvtKeyAlias.equals("")) {
                    String query = BICStubs.getQuery("lsWhere", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/certificateQueries.xml");
                    OracleCallableStatement returnStatement = null;
                    ResultSet rs = null;
                    String hexCertificate = null;
                    Certificate certificate = null;
                    if (LockManager.lock((Connection)model.getConnection())) {
                        try {
                            query = String.format(query, certificateId);
                            returnStatement = (OracleCallableStatement)model.getConnection().prepareCall(query);
                            rs = returnStatement.executeQuery();
                            while (rs.next()) {
                                Blob certificateBlob = rs.getBlob("CERTIFICATE");
                                byte[] bytes = certificateBlob.getBytes(1L, (int)certificateBlob.length());
                                if (bytes == null) {
                                    throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_CERTIFICATE_4"), certificateId)});
                                }
                                hexCertificate = BICStubs.byteArrayToHex(bytes);
                                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                                certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bytes));
                            }
                            if (hexCertificate == null) {
                                throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_CERTIFICATE_5"), certificateId)});
                            }
                        }
                        catch (SQLException e) {
                            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                        }
                        finally {
                            if (returnStatement != null) {
                                returnStatement.close();
                            }
                            LockManager.unlock((Connection)model.getConnection());
                        }
                    }
                    while (aliases.hasMoreElements()) {
                        X509Certificate walletCertificate;
                        String alias = aliases.nextElement();
                        Certificate cert = keyStore.getCertificate(alias);
                        if (!(cert instanceof X509Certificate) || !certificate.equals(walletCertificate = (X509Certificate)cert) || !keyStore.isKeyEntry(alias)) continue;
                        finalAlias = alias;
                        break;
                    }
                } else {
                    if (!keyStore.containsAlias(prvtKeyAlias)) {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_ALIAS"), prvtKeyAlias)});
                    }
                    if (!keyStore.isKeyEntry(prvtKeyAlias)) {
                        throw new BICException(new String[]{String.format(Messages.getString("BICEXP.INVALID_PRIVATE_KEY"), prvtKeyAlias)});
                    }
                    finalAlias = prvtKeyAlias;
                }
                if (prvtKeyPassword == BICOptions.NULL_OBJECT || prvtKeyPassword == null || prvtKeyPassword.equals("")) {
                    Console console = System.console();
                    if (console == null) {
                        throw new BICException(new String[]{Messages.getString("BICEXP.CONSOLE_ERROR")});
                    }
                    prvtKeyPassword = console.readPassword(String.format(Messages.getString("BICEXP.WALLET_PRIVATE_KEY_PASSWORD_PROMPT"), finalAlias), new Object[0]);
                }
                privateKey = (PrivateKey)keyStore.getKey(finalAlias, prvtKeyPassword);
                byte[] dataToSign = BICStubs.convertBlobToByteArray(signatureBytes);
                Signature signature = Signature.getInstance(signatureAlgorithm);
                signature.initSign((PrivateKey)privateKey);
                signature.update(dataToSign);
                generatedSignature = signature.sign();
                if (prvtKeyPassword == null) break block32;
            }
            catch (Exception e) {
                try {
                    throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
                }
                catch (Throwable throwable) {
                    if (prvtKeyPassword != null) {
                        Arrays.fill(prvtKeyPassword, '\u0000');
                    }
                    if (walletPassword != null) {
                        Arrays.fill(walletPassword, '\u0000');
                    }
                    try {
                        if (privateKey == null) throw throwable;
                        byte[] encodedKey = privateKey.getEncoded();
                        Arrays.fill(encodedKey, (byte)0);
                        privateKey = null;
                        throw throwable;
                    }
                    catch (Exception e2) {
                        throw new BICException(new String[]{Messages.getString("BICEXP.PRIVATE_KEY_DELETE_ERROR")});
                    }
                }
            }
            Arrays.fill(prvtKeyPassword, '\u0000');
        }
        if (walletPassword != null) {
            Arrays.fill(walletPassword, '\u0000');
        }
        try {
            if (privateKey == null) return new RAW(generatedSignature);
            byte[] encodedKey = privateKey.getEncoded();
            Arrays.fill(encodedKey, (byte)0);
            return new RAW(generatedSignature);
        }
        catch (Exception e) {
            throw new BICException(new String[]{Messages.getString("BICEXP.PRIVATE_KEY_DELETE_ERROR")});
        }
    }
}

