/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.io.internal;

import com.oracle.bmc.http.client.io.DuplicatableInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class WrappedByteArrayInputStream
extends ByteArrayInputStream
implements DuplicatableInputStream {
    private int length;
    private int offset;

    public WrappedByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    public WrappedByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.offset = offset;
        this.length = length;
    }

    public long length() {
        return this.length == 0 ? (long)this.buf.length : (long)Math.min(this.offset + this.length, this.buf.length);
    }

    public InputStream duplicate() {
        if (this.length == 0 && this.offset == 0) {
            return new WrappedByteArrayInputStream(this.buf);
        }
        return new WrappedByteArrayInputStream(this.buf, this.offset, this.length);
    }
}

