/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import oracle.cloudstorage.io.Md5InputStream;

public class Md5VerifyingInputStream
extends Md5InputStream {
    private final String expectedMd5;

    public Md5VerifyingInputStream(String expectedMd5, InputStream in) {
        super(in);
        this.expectedMd5 = expectedMd5;
    }

    private void verifyMd5(int read) throws IOException {
        String actualMd5;
        if (read >= 0) {
            return;
        }
        try {
            actualMd5 = this.getFutureMd5().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new IOException("Expected MD5: " + this.expectedMd5, e);
        }
        if (!Md5VerifyingInputStream.equal(this.expectedMd5, actualMd5)) {
            throw new IOException("\nExpected MD5: " + this.expectedMd5 + "\n  Actual MD5: " + actualMd5);
        }
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        this.verifyMd5(read);
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b, 0, b.length);
        this.verifyMd5(read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.verifyMd5(read);
        return read;
    }

    private static final boolean equal(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }
}

