/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.retry.CompositeRetryState;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.retry.RetryState;

public class CompositeRetry<P extends IRetryStrategy>
implements IRetryStrategy,
Iterable<P> {
    private final List<P> parts = new LinkedList<P>();
    private Comparator<P> comparator = null;

    public static <C extends IRetryStrategy> CompositeRetry<C> of(Comparator<C> comparator, C ... parts) {
        CompositeRetry compositeRetry = new CompositeRetry(comparator, parts);
        return compositeRetry;
    }

    public static <C extends IRetryStrategy> CompositeRetry<C> of(C ... parts) {
        CompositeRetry compositeRetry = new CompositeRetry(parts);
        return compositeRetry;
    }

    public CompositeRetry(P ... parts) {
        this.add((IRetryStrategy[])parts);
    }

    public CompositeRetry(Comparator<P> comparator, P ... parts) {
        this((IRetryStrategy[])parts);
        this.comparator = comparator;
    }

    public final CompositeRetry<P> add(P ... inparts) {
        for (P retryStrategy : inparts) {
            if (retryStrategy == null) continue;
            this.parts.add(retryStrategy);
        }
        return this;
    }

    public Comparator<? extends P> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<P> comparator) {
        this.comparator = comparator;
    }

    public boolean remove(P part) {
        boolean removed = this.parts.remove(part);
        return removed;
    }

    @Override
    public CompositeRetryState reset() {
        if (this.comparator != null) {
            Collections.sort(this.parts, this.comparator);
        }
        CompositeRetryState compositeRetryState = new CompositeRetryState(this.parts.size());
        for (IRetryStrategy retryStrategy : this) {
            if (retryStrategy == null) {
                compositeRetryState.add(null);
                continue;
            }
            RetryState retryState = retryStrategy.reset();
            compositeRetryState.add(retryState);
        }
        return compositeRetryState;
    }

    @Override
    public IRetryStrategy.Cue onResponse(IRequestBuilder builder, int rawHttpStatusCode, Throwable throwable, RetryState retryState) throws RetryException, InterruptedException {
        if (this.parts.isEmpty()) {
            return IRetryStrategy.Cue.none;
        }
        if (!(retryState instanceof CompositeRetryState)) {
            throw new IllegalArgumentException();
        }
        CompositeRetryState compositeRetryState = (CompositeRetryState)retryState;
        compositeRetryState.first();
        if (this.comparator != null) {
            Collections.sort(this.parts, this.comparator);
        }
        for (IRetryStrategy retryStrategy : this) {
            IRetryStrategy.Cue status;
            compositeRetryState.next();
            if (retryStrategy == null || (status = retryStrategy.onResponse(builder, rawHttpStatusCode, throwable, retryState)) == IRetryStrategy.Cue.none) continue;
            return status;
        }
        return IRetryStrategy.Cue.none;
    }

    @Override
    public Iterator<P> iterator() {
        return this.parts.iterator();
    }
}

