/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.jaxrs;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.request.processor.AbstractResponse;

public class JaxrsResponseAdapter
extends AbstractResponse {
    private final Response response;
    private final Future<String> futureMd5;

    public JaxrsResponseAdapter(Response response, Future<String> futureMd5) {
        this.response = response;
        this.futureMd5 = futureMd5;
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    @Override
    public java.util.Map<String, List<Object>> getHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public InputStream getInputStream() {
        InputStream inputStream = (InputStream)this.response.readEntity(InputStream.class);
        return inputStream;
    }

    @Override
    public void close() {
        this.response.close();
    }

    @Override
    public Future<String> getFutureMd5() {
        return this.futureMd5;
    }

    public final String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("\n").append(this.getStatus());
        for (Map.Entry<String, List<Object>> header : this.getHeaders().entrySet()) {
            msg.append("\n  ").append(header.getKey()).append(':');
            int sep = 32;
            for (Object value : header.getValue()) {
                msg.append((char)sep).append(Map.mask(header.getKey(), value));
                sep = 44;
            }
        }
        String error = this.getErrorContent();
        if (error != null && !error.trim().isEmpty()) {
            msg.append("\n").append(error);
        }
        return msg.toString();
    }
}

