/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.delete;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.delete.BulkDeleteReply;
import oracle.cloudstorage.api.delete.DeleteContainerReply;
import oracle.cloudstorage.api.delete.DeleteObjectReply;
import oracle.cloudstorage.api.delete.DeleteRequestProcessor;
import oracle.cloudstorage.api.delete.IBulkDeleteReply;
import oracle.cloudstorage.api.delete.IDeleteContainerReply;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.delete.IDeleteRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.queryparam.QueryParam;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ScopedRequestProcessor;
import oracle.cloudstorage.api.request.processor.Sendable;
import oracle.cloudstorage.api.request.processor.SimpleXMLResponseParser;
import oracle.cloudstorage.api.request.processor.StringContent;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.io.IO;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSendableProcessor
extends DeleteRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DeleteSendableProcessor.class);
    private static final String NUMBER_NOT_FOUND = "<number_not_found>";
    private static final String NUMBER_DELETED = "<number_deleted>";
    private static final String RESPONSE_STATUS = "<response_status>";

    public DeleteSendableProcessor(IProcessorFactory processorFactory) {
        super(processorFactory);
    }

    @Override
    protected IDeleteContainerReply containerImpl(final Collection<IDeleteObjectReply> deleteObjectReplies) throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IDeleteContainerReply> processor = new ScopedRequestProcessor<IRequestBuilder, IDeleteContainerReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                IResponse response = DeleteSendableProcessor.this.send(logger, Marker.del.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IDeleteContainerReply buildReply(IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                DeleteContainerReply reply = new DeleteContainerReply(headers, statusCode, message, context, deleteObjectReplies);
                return reply;
            }
        };
        IDeleteContainerReply reply = (IDeleteContainerReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    protected IDeleteObjectReply atomicObject(String objectUrl) throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IDeleteObjectReply> processor = new ScopedRequestProcessor<IRequestBuilder, IDeleteObjectReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                IResponse response = DeleteSendableProcessor.this.send(logger, Marker.del.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IDeleteObjectReply buildReply(IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                DeleteObjectReply reply = new DeleteObjectReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IDeleteObjectReply reply = (IDeleteObjectReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    public IBulkDeleteReply bulk() throws RetryException, InterruptedException {
        ScopedRequestProcessor<IRequestBuilder, IBulkDeleteReply> processor = new ScopedRequestProcessor<IRequestBuilder, IBulkDeleteReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                StringBuilder body = new StringBuilder();
                for (String item : ((IDeleteRequestBuilder)DeleteSendableProcessor.this.getBuilder()).getBulkItems()) {
                    body.append(item).append("\n");
                }
                StringContent content = new StringContent(body.toString(), Charset.defaultCharset(), body.length());
                Sendable sendable = new Sendable((IRequestBuilder)DeleteSendableProcessor.this.getBuilder(), this.getSendable().getHeaders(), Method.post, Scope.account, DeleteSendableProcessor.this.getAccountUrl(), content, -2);
                sendable.getQueryParams().put(QueryParam.bulkDelete.provide(true));
                sendable.getHeaders().put(Header.contentType, (Object)"text/plain");
                sendable.getHeaders().put(Header.accept, (Object)"application/xml");
                ((IDeleteRequestBuilder)DeleteSendableProcessor.this.getBuilder()).getQueryParams().put(QueryParam.bulkDelete.provide(true));
                IResponse response = DeleteSendableProcessor.this.getSession().send(logger, Marker.del.and(Marker.jaxrs), sendable);
                return response;
            }

            @Override
            protected IBulkDeleteReply buildReply(IResponse response, IReply.Context context) {
                String[] parts;
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                InputStream inputStream = response.getInputStream();
                String body = IO.read(inputStream).toString();
                SimpleXMLResponseParser parser = new SimpleXMLResponseParser(body);
                int deleted = parser.getInt(DeleteSendableProcessor.NUMBER_DELETED);
                int notFound = parser.getInt(DeleteSendableProcessor.NUMBER_NOT_FOUND);
                String responseStatus = parser.get(DeleteSendableProcessor.RESPONSE_STATUS);
                String[] stringArray = parts = responseStatus == null ? null : responseStatus.split(" ");
                if (parts != null && parts.length > 1) {
                    try {
                        statusCode = Integer.parseInt(parts[0].trim());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unparsable bulk delete response status [" + responseStatus + "]", e);
                    }
                }
                BulkDeleteReply reply = new BulkDeleteReply(headers, statusCode, context, deleted, notFound);
                parser.parseErrors(reply);
                return reply;
            }
        };
        IBulkDeleteReply reply = (IBulkDeleteReply)processor.execute(this.getBuilder());
        return reply;
    }
}

