/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthKeepAliveStrategy;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.auth.IUser;
import oracle.cloudstorage.api.request.builder.IMethodRequestBuilder;
import oracle.cloudstorage.api.request.builder.IRequestExecutor;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;

public interface IAuthRequestBuilder
extends IMethodRequestBuilder<IAuthRequestBuilder, RetryStrategy, IAuthStrategy> {
    public String getUrl();

    public IAuthKeepAliveStrategy getAuthKeepAlive();

    public static interface Auth
    extends IRequestExecutor {
        public ISession getSession();

        @Override
        public IAuthReply send() throws RetryException, InterruptedException;
    }

    public static interface Password {
        public Auth password(String var1);
    }

    public static interface User {
        public Password tenant(String var1);

        public Password user(String var1);

        public Password user(String var1, String var2);

        public Password user(String var1, String var2, String var3);

        public Password user(String var1, String var2, String var3, String var4, String var5, String var6);
    }

    public static interface Host {
        public Auth user(IUser.FromTenant var1);

        public Auth user(IUser.FromAccount var1);

        public Auth user(IUser.FromIdentityDomain var1);

        public Auth user(IUser.PreBuilt var1);

        public Auth user(IUser.Properties var1);

        public User url(String var1);

        public User region(String var1);
    }

    public static interface KeepAlive
    extends Host,
    IRequestBuilder.Builder {
        public Host keepAlive(IAuthKeepAliveStrategy var1);
    }

    public static interface ReadTimeout
    extends KeepAlive,
    IRequestBuilder.ReadTimeout {
        @Override
        public KeepAlive read(long var1, TimeUnit var3);
    }

    public static interface ConnectTimeout
    extends ReadTimeout,
    IRequestBuilder.ConnectTimeout {
        @Override
        public ReadTimeout connect(long var1, TimeUnit var3);
    }

    public static interface RetryStrategy
    extends ConnectTimeout,
    IRequestBuilder.RetryStrategy {
        @Override
        public ConnectTimeout retry(IRetryStrategy var1);
    }
}

