/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.zip.ZipBuilder;

public class ZipMutator {
    private static final InputOutputStreams STREAMS = InputOutputStreams.instance();

    public static void mutate(InputStream is, OutputStream os, EntryMutator entryMutator) throws IOException {
        ZipBuilder builder = new ZipBuilder(os);
        try (ZipInputStream zip = new ZipInputStream(is);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                entryMutator.mutate(builder, zipEntry, STREAMS.uncloseable(is));
                zipEntry = zip.getNextEntry();
            }
            boolean hasMore = entryMutator.mutate(builder, null, null);
            while (hasMore) {
                hasMore = entryMutator.mutate(builder, null, null);
            }
            builder.build();
        }
    }

    @FunctionalInterface
    public static interface EntryMutator {
        public boolean mutate(ZipBuilder var1, ZipEntry var2, InputStream var3) throws IOException;
    }
}

