/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.tns.CodePointValidator;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;
import oracle.dbtools.core.tns.Quoted;
import oracle.dbtools.core.tns.Token;
import oracle.dbtools.core.util.Throwables;

class Lexer {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CRLF = new String(new char[]{'\r', '\n'});

    Lexer() {
    }

    private static boolean matches(int character, int ... candidates) {
        for (int candidate : candidates) {
            if (candidate != character) continue;
            return true;
        }
        return false;
    }

    Stream<Token> parse(CharSequence text) {
        return this.parse(InputOutputStreams.instance().asReader(text));
    }

    Stream<Token> parse(Reader text) {
        return StreamSupport.stream(new TokenSpliterator(text), false);
    }

    private static class TokenSpliterator
    extends Spliterators.AbstractSpliterator<Token> {
        private final PushbackReader text;
        private int line;
        private int column;

        protected TokenSpliterator(Reader text) {
            super(Long.MAX_VALUE, 1040);
            this.text = new PushbackReader(text, 1024);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Token> action) {
            try {
                Token token = this.nextToken();
                if (token == null) {
                    return false;
                }
                if (Token.Type.EOL == token.type) {
                    ++this.line;
                    this.column = 0;
                } else {
                    this.column += token.length();
                }
                action.accept(token);
                return true;
            }
            catch (IOException e) {
                OracleConfiguration.Position position = this.position();
                OracleConfiguration.SyntaxError error = OracleConfiguration.SyntaxError.of(position, Throwables.message(e));
                throw OracleConfigurationSyntaxException.of(error, e);
            }
        }

        private Token nextToken() throws IOException {
            int c = this.text.read();
            switch (c) {
                case -1: {
                    return this.eos();
                }
                case 13: {
                    return this.whitespaceOrEol(c);
                }
                case 10: {
                    return this.eol();
                }
                case 35: {
                    return this.comment();
                }
                case 40: {
                    return this.beginPair();
                }
                case 41: {
                    return this.endPair();
                }
                case 61: {
                    return this.eq();
                }
                case 44: {
                    return this.separator();
                }
                case 39: {
                    return this.quotedAtom(39);
                }
                case 34: {
                    return this.quotedAtom(34);
                }
            }
            if (CodePointValidator.WHITESPACE.test(c)) {
                return this.whitespace(c);
            }
            return this.unquotedAtom(c);
        }

        private Token whitespaceOrEol(int firstCharacter) throws IOException {
            int next = this.text.read();
            if (10 == next) {
                return this.eol(CRLF);
            }
            this.text.unread(next);
            return this.whitespace(firstCharacter);
        }

        private Token endPair() {
            return this.token(Token.Type.END_PAIR);
        }

        private Token separator() {
            return this.token(Token.Type.SEPARATOR);
        }

        private Token eq() {
            return this.token(Token.Type.EQ);
        }

        private String readWhile(CodePointValidator condition, TerminatingAction terminated) throws IOException {
            StringBuilder buffer = new StringBuilder();
            int c = this.text.read();
            while (c != -1) {
                if (condition.test(c)) {
                    buffer.appendCodePoint(c);
                    c = this.text.read();
                    continue;
                }
                terminated.accept(c);
                break;
            }
            return buffer.toString();
        }

        private String detectCRLF(String input) throws IOException {
            int next;
            String trimmed = input;
            int len = trimmed.length();
            if (len > 0 && '\r' == input.charAt(len - 1) && 10 == (next = this.text.read())) {
                trimmed = trimmed.substring(0, trimmed.length() - 1);
                this.text.unread(next);
                this.text.unread(13);
            }
            return trimmed;
        }

        private Token comment() throws IOException {
            String comment = this.detectCRLF(this.readWhile(CodePointValidator.NO_NEW_LINE, this.text::unread));
            return this.token(Token.Type.COMMENT, comment);
        }

        private Token eos() {
            return null;
        }

        private Token eol() {
            return this.eol("\n");
        }

        private Token eol(CharSequence text) {
            return this.token(Token.Type.EOL, text);
        }

        private Token beginPair() {
            return this.token(Token.Type.BEGIN_PAIR);
        }

        private Token unquotedAtom(int firstCharacter) throws IOException {
            int end;
            this.text.unread(firstCharacter);
            String atom = this.readWhile(CodePointValidator.UNQUOTED, this.text::unread);
            int pos = end = atom.length() - 1;
            while (Character.isWhitespace(atom.charAt(pos))) {
                this.text.unread(atom.charAt(pos));
                --pos;
            }
            if (pos < end) {
                return this.token(Token.Type.UNQUOTED_ATOM, atom.substring(0, pos + 1));
            }
            return this.token(Token.Type.UNQUOTED_ATOM, atom);
        }

        private Token whitespace(int firstCharacter) throws IOException {
            this.text.unread(firstCharacter);
            String whitespace = this.detectCRLF(this.readWhile(CodePointValidator.WHITESPACE, this.text::unread));
            return this.token(Token.Type.WHITESPACE, whitespace);
        }

        private Token quotedAtom(int quoteMark) throws IOException {
            String atom = Token.unescape(this.readWhile(new Quoted(quoteMark), c -> {}), quoteMark);
            Token.Type type = quoteMark == 39 ? Token.Type.SINGLE_QUOTED_ATOM : Token.Type.DOUBLE_QUOTED_ATOM;
            return this.token(type, atom);
        }

        private Token token(Token.Type type) {
            return this.token(type, null);
        }

        private Token token(Token.Type type, CharSequence text) {
            Token.Builder token = Token.builder().type(type).position(this.position());
            if (text != null) {
                token.text(text);
            }
            return token.build();
        }

        private OracleConfiguration.Position position() {
            return OracleConfiguration.Position.of(this.line, this.column);
        }

        static interface TerminatingAction {
            public void accept(int var1) throws IOException;
        }
    }
}

