/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.system;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SystemLocale {
    private final Map<String, String> properties;

    private SystemLocale(Map<String, String> properties) {
        this.properties = properties;
    }

    public static SystemLocale of(Map<String, String> properties) {
        return new SystemLocale(properties);
    }

    public Locale locale() {
        String script;
        String variant;
        String country;
        Map<String, String> props = this.properties;
        String language = props.getOrDefault("user.language", "en");
        String region = props.get("user.region");
        if (region != null) {
            int i = region.indexOf(95);
            if (i >= 0) {
                country = region.substring(0, i);
                variant = region.substring(i + 1);
            } else {
                country = region;
                variant = null;
            }
            script = null;
        } else {
            script = props.get("user.script");
            country = props.get("user.country");
            variant = props.get("user.variant");
        }
        List localeComponents = Stream.of(language, script, country, variant).filter(v -> v != null && !v.isBlank()).collect(Collectors.toList());
        String languageTag = String.join((CharSequence)"-", localeComponents);
        return Locale.forLanguageTag(languageTag);
    }
}

