/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc.configurators;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.jdbc.ConnectionConstants;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.DataSourceConfigurator;
import oracle.dbtools.core.jdbc.configurators.ConnectionTypeConfigurator;

public final class SimpleCredentialsConfiguration
implements DataSourceConfigurator,
ConnectionConstants {
    private final String username;
    private final String password;
    private final String role;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Properties props) {
        return new Builder().properties(props);
    }

    private SimpleCredentialsConfiguration(String username, String password, String role) {
        this.username = username;
        this.password = password;
        this.role = role;
    }

    @Override
    public void configure(DataSourceBuilder<?> dataSourceBuilder) throws SQLException, IOException {
        if (ConnectionTypeConfigurator.hasLength(this.username) && !ConnectionTypeConfigurator.hasLength(this.password)) {
            throw new SQLException(ConnectionsResources.getString("ERROR_MISSING_PASS"), "");
        }
        if (ConnectionTypeConfigurator.hasLength(this.username)) {
            dataSourceBuilder.user(this.username);
        }
        if (ConnectionTypeConfigurator.hasLength(this.password)) {
            dataSourceBuilder.password(this.password);
        }
        if (ConnectionTypeConfigurator.hasLength(this.role)) {
            Properties props = new Properties();
            props.setProperty("internal_logon", this.role);
            dataSourceBuilder.connectionProperties(props);
        }
    }

    public static final class Builder {
        private String username;
        private String password;
        private String role;

        private Builder() {
        }

        public Builder user(String user) {
            this.username = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder properties(Properties props) {
            this.user(props.getProperty("user"));
            this.password(props.getProperty("password"));
            this.role(props.getProperty("role"));
            return this;
        }

        public SimpleCredentialsConfiguration build() {
            return new SimpleCredentialsConfiguration(this.username, this.password, this.role);
        }
    }
}

