/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.feature.flags;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import oracle.dbtools.core.feature.flags.FeatureFlags;
import oracle.dbtools.core.io.file.HomeFolder;

class FeatureFlagsFile {
    private static final String FEATURES_JSON = "features.json";
    private final Path path;

    private FeatureFlagsFile(Path path) {
        this.path = path;
    }

    static FeatureFlagsFile of(HomeFolder home) {
        Path file = home.resolve(FEATURES_JSON, new String[0]);
        return new FeatureFlagsFile(file);
    }

    FeatureFlags read() throws IOException {
        FeatureFlags featureFlags;
        block8: {
            BufferedReader content = Files.newBufferedReader(this.path(), StandardCharsets.UTF_8);
            try {
                featureFlags = FeatureFlags.read(content);
                if (content == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return FeatureFlags.empty();
                }
            }
            content.close();
        }
        return featureFlags;
    }

    Path path() {
        return this.path;
    }
}

