/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.feature.flags;

import java.util.Objects;
import oracle.dbtools.core.feature.flags.FeatureFlags;
import oracle.dbtools.core.feature.flags.IllegalFeatureFlagException;
import oracle.dbtools.core.feature.flags.SystemFeatureFlags;
import oracle.dbtools.core.text.CharSequenceTrait;

public final class FeatureFlag
implements CharSequenceTrait,
Comparable<FeatureFlag> {
    private static final String DELIMITER = ".";
    private final String product;
    private final String feature;

    private FeatureFlag(String product, String feature) {
        this.product = product;
        this.feature = feature;
    }

    public static FeatureFlag of(CharSequence product, CharSequence feature) {
        return new FeatureFlag(product.toString(), feature.toString());
    }

    public static FeatureFlag of(CharSequence name) {
        String text = name.toString();
        String[] elements = name.toString().split("\\.");
        if (elements.length == 3 && "enabled".equals(elements[2])) {
            String product = elements[0];
            String feature = elements[1];
            return FeatureFlag.of(product, feature);
        }
        throw new IllegalFeatureFlagException(text);
    }

    public String feature() {
        return this.feature;
    }

    public String product() {
        return this.product;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlag that = (FeatureFlag)o;
        return Objects.equals(this.product, that.product) && Objects.equals(this.feature, that.feature);
    }

    public int hashCode() {
        return Objects.hash(this.product, this.feature);
    }

    @Override
    public String toString() {
        return String.join((CharSequence)DELIMITER, this.product, this.feature);
    }

    @Override
    public int compareTo(FeatureFlag other) {
        return this.toString().compareTo(String.valueOf(other));
    }

    public boolean isEnabled(FeatureFlags flags) {
        return flags.isEnabled(this);
    }

    public boolean isEnabled() {
        return this.isEnabled(SystemFeatureFlags.instance());
    }
}

