/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.util;

import java.io.IOException;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.storage.StoreException;
import oracle.dbtools.core.connections.storage.UnicodeSafeWalletSecrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class StoredConnectionSupport {
    private final ConnectionStorage storage;

    public static StoredConnectionSupport of(ConnectionStorage storage) {
        return new StoredConnectionSupport(storage);
    }

    protected StoredConnectionSupport(ConnectionStorage storage) {
        this.storage = storage;
    }

    public ConnectionDefinition createOracleConnectionDefinition(String name, String connectString, String userName, TextSecret password) {
        ConfigurationProperties.Builder configurationPropertiesBuilder = ConfigurationProperties.builder();
        configurationPropertiesBuilder.set("name", name).set("type", "ORACLE_DATABASE").set("connectionString", connectString).set("userName", userName);
        ConnectionDefinition.Builder defBuilder = ConnectionDefinition.builder(ConnectionIdentifiers.createUniqueIdentifier());
        defBuilder.dbtoolsProperties(configurationPropertiesBuilder.build());
        try {
            if (password.isPresent()) {
                OracleWallet wallet = new OracleWallet();
                wallet.createSSO();
                OracleSecretStore store = wallet.getSecretStore();
                UnicodeSafeWalletSecrets secrets = UnicodeSafeWalletSecrets.of(store);
                secrets.write((CharSequence)"dbtools.database.password.base64", password);
                wallet.setSecretStore(store);
                defBuilder.wallet(wallet);
            }
        }
        catch (IOException | OracleSecretStoreException exception) {
            throw new StoreException((Exception)exception);
        }
        return defBuilder.build();
    }

    public void storeConnection(ConnectionDefinition definition) {
        this.storage.storeDefinition(definition);
    }
}

