/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.storage.Wallet;
import oracle.dbtools.core.secrets.TextSecret;

public abstract class ConnectionCloner {
    protected final ConnectionDefinition origin;
    private final Connections.Identifier destIdentifier;
    private final Connections.Identifier destName;
    private final CloneCredentials credentials;
    private Path destDir;
    private ConfigurationProperties dbToolsProps;
    private Wallet wallet;

    protected ConnectionCloner(Builder builder) {
        this.origin = builder.origin;
        this.destIdentifier = ConnectionIdentifiers.createUniqueIdentifier();
        this.destName = ConnectionIdentifiers.createIdentifier(builder.destName);
        this.credentials = builder.credentials != null ? builder.credentials : CloneCredentials.of(null, TextSecret.none());
    }

    public abstract void handleCopyError(IOException var1);

    public void cloneConnection() throws IOException {
        if (this.origin == null) {
            throw new IllegalStateException("origin not set");
        }
        if (this.destName == null) {
            throw new IllegalStateException("destination not set");
        }
        Connections.Identifier originName = this.origin.getIdentifier();
        ConnectionStorage storage = ConnectionStorage.instance();
        this.destDir = storage.duplicateConnection(originName, this.destIdentifier, this::handleCopyError);
        Path dbTools = this.destDir.resolve("dbtools.properties");
        this.dbToolsProps = Files.exists(dbTools, new LinkOption[0]) ? ConnectionStorage.loadProperties(dbTools) : ConfigurationProperties.empty();
        this.dbToolsProps = this.dbToolsProps.withProperty("name", this.destName.toString());
        this.updateUser(this.credentials);
    }

    protected abstract ConnectionHelper findHelper();

    public void updateUser(CloneCredentials credentials) throws IOException {
        ConnectionHelper helper = this.findHelper();
        String spec = helper.getConnectionSpec();
        Path walletFile = this.destDir.resolve("credentials.sso");
        if (Files.exists(walletFile, new LinkOption[0])) {
            this.wallet = Wallet.createWallet(walletFile);
        }
        if (this.wallet == null) {
            this.wallet = Wallet.createEmptyWallet();
        }
        this.wallet.updateCredentials(spec, credentials.getUsername(), credentials.getPassword());
        this.dbToolsProps = this.dbToolsProps.withProperty("userName", credentials.getUsername());
    }

    public void saveConnection() throws IOException {
        ConnectionStorage storage = ConnectionStorage.instance();
        if (!this.dbToolsProps.isEmpty()) {
            storage.storeObject(this.destIdentifier, "dbtools.properties", this.dbToolsProps, ConnectionDefinition::outputProperties);
        }
        if (this.wallet != null) {
            storage.storeObject(this.destIdentifier, "credentials.sso", this.wallet, Wallet::writeWallet);
        }
    }

    public static abstract class Builder<T extends Builder, C> {
        private ConnectionDefinition origin;
        private String destName;
        private CloneCredentials credentials;

        protected Builder() {
        }

        public T origin(ConnectionDefinition origin) {
            this.origin = origin;
            return (T)this;
        }

        public T destination(String dest) {
            this.destName = dest;
            return (T)this;
        }

        public T credentials(CloneCredentials credentials) {
            this.credentials = credentials;
            return (T)this;
        }

        protected abstract C build();
    }

    public static final class CloneCredentials {
        private final String username;
        private final TextSecret password;

        private CloneCredentials(String username, TextSecret password) {
            this.username = username;
            this.password = password != null ? password : TextSecret.none();
        }

        public String getUsername() {
            return this.username;
        }

        public TextSecret getPassword() {
            return this.password;
        }

        public static CloneCredentials of(String username, TextSecret password) {
            return new CloneCredentials(username, password);
        }

        public static CloneCredentials from(ConnectionDefinition definition) {
            String username = definition.getDbtoolsProperties().getProperty("userName");
            Wallet wallet = definition.getWallet();
            return new CloneCredentials(username, wallet.getPassword());
        }
    }
}

