/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import oracle.dbtools.core.connections.ConnectionException;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.connections.helpers.ConnectCredentials;
import oracle.dbtools.core.secrets.TextSecret;

public interface ConnectionHelper {
    public static final String UNKNOWN_TYPE = "UNKNOWN";

    public static DisplayEntry displayEntry(String key, String value, boolean useNewLine) {
        return new DisplayEntry(key, value, useNewLine);
    }

    public Collection<DisplayEntry> getDisplayProperties();

    default public boolean requiresUsername() {
        return true;
    }

    public String getUsername();

    default public boolean requiresPassword() {
        return true;
    }

    default public ConnectCredentials getCredentials() {
        return ConnectCredentials.of(this.getUsername(), this.getPassword(), null);
    }

    public TextSecret getPassword();

    public String getConnectionSpec();

    public String getURL();

    default public Connection createConnection(ConnectCredentials credentials, Properties productProperties) throws SQLException {
        throw ConnectionException.of(ConnectionsResources.getString("ERROR_UNSUPPORTED_CONNECTION"));
    }

    default public Connection createConnection() throws SQLException {
        return this.createConnection(null, new Properties());
    }

    public static final class DisplayEntry {
        private static final String SINGLE_LINE = "{0}: {1}";
        private static final String TWO_LINE = "{0}:\n  {1}";
        private final String key;
        private final String value;
        private final boolean useNewLine;

        private DisplayEntry(String key, String value, boolean useNewLine) {
            this.key = key;
            this.value = value;
            this.useNewLine = useNewLine;
        }

        public String getDisplayOutput() {
            return MessageFormat.format(this.useNewLine ? TWO_LINE : SINGLE_LINE, this.key, this.value);
        }
    }
}

