/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListGiVersionMinorVersionsRequest
extends BmcRequest<Void> {
    private String version;
    private String availabilityDomain;
    private String compartmentId;
    private String opcRequestId;
    private ShapeFamily shapeFamily;
    private Boolean isGiVersionForProvisioning;
    private String shape;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;

    public String getVersion() {
        return this.version;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ShapeFamily getShapeFamily() {
        return this.shapeFamily;
    }

    public Boolean getIsGiVersionForProvisioning() {
        return this.isGiVersionForProvisioning;
    }

    public String getShape() {
        return this.shape;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().version(this.version).availabilityDomain(this.availabilityDomain).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).shapeFamily(this.shapeFamily).isGiVersionForProvisioning(this.isGiVersionForProvisioning).shape(this.shape).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",version=").append(String.valueOf(this.version));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",shapeFamily=").append(String.valueOf((Object)this.shapeFamily));
        sb.append(",isGiVersionForProvisioning=").append(String.valueOf(this.isGiVersionForProvisioning));
        sb.append(",shape=").append(String.valueOf(this.shape));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListGiVersionMinorVersionsRequest)) {
            return false;
        }
        ListGiVersionMinorVersionsRequest other = (ListGiVersionMinorVersionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.version, other.version) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.shapeFamily, (Object)other.shapeFamily) && Objects.equals(this.isGiVersionForProvisioning, other.isGiVersionForProvisioning) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.shapeFamily == null ? 43 : this.shapeFamily.hashCode());
        result = result * 59 + (this.isGiVersionForProvisioning == null ? 43 : this.isGiVersionForProvisioning.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Version("VERSION");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ShapeFamily implements BmcEnum
    {
        Singlenode("SINGLENODE"),
        Yoda("YODA"),
        Virtualmachine("VIRTUALMACHINE"),
        Exadata("EXADATA"),
        Exacc("EXACC"),
        ExadbXs("EXADB_XS");

        private final String value;
        private static Map<String, ShapeFamily> map;

        private ShapeFamily(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShapeFamily create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ShapeFamily: " + key);
        }

        static {
            map = new HashMap<String, ShapeFamily>();
            for (ShapeFamily v : ShapeFamily.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListGiVersionMinorVersionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String version = null;
        private String availabilityDomain = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private ShapeFamily shapeFamily = null;
        private Boolean isGiVersionForProvisioning = null;
        private String shape = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder shapeFamily(ShapeFamily shapeFamily) {
            this.shapeFamily = shapeFamily;
            return this;
        }

        public Builder isGiVersionForProvisioning(Boolean isGiVersionForProvisioning) {
            this.isGiVersionForProvisioning = isGiVersionForProvisioning;
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListGiVersionMinorVersionsRequest o) {
            this.version(o.getVersion());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.shapeFamily(o.getShapeFamily());
            this.isGiVersionForProvisioning(o.getIsGiVersionForProvisioning());
            this.shape(o.getShape());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListGiVersionMinorVersionsRequest build() {
            ListGiVersionMinorVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListGiVersionMinorVersionsRequest buildWithoutInvocationCallback() {
            ListGiVersionMinorVersionsRequest request = new ListGiVersionMinorVersionsRequest();
            request.version = this.version;
            request.availabilityDomain = this.availabilityDomain;
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.shapeFamily = this.shapeFamily;
            request.isGiVersionForProvisioning = this.isGiVersionForProvisioning;
            request.shape = this.shape;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }
}

