/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.AutonomousContainerDatabaseSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAutonomousContainerDatabasesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String autonomousExadataInfrastructureId;
    private String autonomousVmClusterId;
    private AutonomousContainerDatabaseSummary.InfrastructureType infrastructureType;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private AutonomousContainerDatabaseSummary.LifecycleState lifecycleState;
    private String availabilityDomain;
    private String displayName;
    private String serviceLevelAgreementType;
    private String cloudAutonomousVmClusterId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousExadataInfrastructureId() {
        return this.autonomousExadataInfrastructureId;
    }

    public String getAutonomousVmClusterId() {
        return this.autonomousVmClusterId;
    }

    public AutonomousContainerDatabaseSummary.InfrastructureType getInfrastructureType() {
        return this.infrastructureType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public AutonomousContainerDatabaseSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getServiceLevelAgreementType() {
        return this.serviceLevelAgreementType;
    }

    public String getCloudAutonomousVmClusterId() {
        return this.cloudAutonomousVmClusterId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).autonomousExadataInfrastructureId(this.autonomousExadataInfrastructureId).autonomousVmClusterId(this.autonomousVmClusterId).infrastructureType(this.infrastructureType).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).availabilityDomain(this.availabilityDomain).displayName(this.displayName).serviceLevelAgreementType(this.serviceLevelAgreementType).cloudAutonomousVmClusterId(this.cloudAutonomousVmClusterId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",autonomousExadataInfrastructureId=").append(String.valueOf(this.autonomousExadataInfrastructureId));
        sb.append(",autonomousVmClusterId=").append(String.valueOf(this.autonomousVmClusterId));
        sb.append(",infrastructureType=").append(String.valueOf((Object)this.infrastructureType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",serviceLevelAgreementType=").append(String.valueOf(this.serviceLevelAgreementType));
        sb.append(",cloudAutonomousVmClusterId=").append(String.valueOf(this.cloudAutonomousVmClusterId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAutonomousContainerDatabasesRequest)) {
            return false;
        }
        ListAutonomousContainerDatabasesRequest other = (ListAutonomousContainerDatabasesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.autonomousExadataInfrastructureId, other.autonomousExadataInfrastructureId) && Objects.equals(this.autonomousVmClusterId, other.autonomousVmClusterId) && Objects.equals((Object)this.infrastructureType, (Object)other.infrastructureType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.serviceLevelAgreementType, other.serviceLevelAgreementType) && Objects.equals(this.cloudAutonomousVmClusterId, other.cloudAutonomousVmClusterId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.autonomousExadataInfrastructureId == null ? 43 : this.autonomousExadataInfrastructureId.hashCode());
        result = result * 59 + (this.autonomousVmClusterId == null ? 43 : this.autonomousVmClusterId.hashCode());
        result = result * 59 + (this.infrastructureType == null ? 43 : this.infrastructureType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.serviceLevelAgreementType == null ? 43 : this.serviceLevelAgreementType.hashCode());
        result = result * 59 + (this.cloudAutonomousVmClusterId == null ? 43 : this.cloudAutonomousVmClusterId.hashCode());
        return result;
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousContainerDatabasesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String autonomousExadataInfrastructureId = null;
        private String autonomousVmClusterId = null;
        private AutonomousContainerDatabaseSummary.InfrastructureType infrastructureType = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private AutonomousContainerDatabaseSummary.LifecycleState lifecycleState = null;
        private String availabilityDomain = null;
        private String displayName = null;
        private String serviceLevelAgreementType = null;
        private String cloudAutonomousVmClusterId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder autonomousExadataInfrastructureId(String autonomousExadataInfrastructureId) {
            this.autonomousExadataInfrastructureId = autonomousExadataInfrastructureId;
            return this;
        }

        public Builder autonomousVmClusterId(String autonomousVmClusterId) {
            this.autonomousVmClusterId = autonomousVmClusterId;
            return this;
        }

        public Builder infrastructureType(AutonomousContainerDatabaseSummary.InfrastructureType infrastructureType) {
            this.infrastructureType = infrastructureType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(AutonomousContainerDatabaseSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder serviceLevelAgreementType(String serviceLevelAgreementType) {
            this.serviceLevelAgreementType = serviceLevelAgreementType;
            return this;
        }

        public Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousContainerDatabasesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.autonomousExadataInfrastructureId(o.getAutonomousExadataInfrastructureId());
            this.autonomousVmClusterId(o.getAutonomousVmClusterId());
            this.infrastructureType(o.getInfrastructureType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.displayName(o.getDisplayName());
            this.serviceLevelAgreementType(o.getServiceLevelAgreementType());
            this.cloudAutonomousVmClusterId(o.getCloudAutonomousVmClusterId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousContainerDatabasesRequest build() {
            ListAutonomousContainerDatabasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAutonomousContainerDatabasesRequest buildWithoutInvocationCallback() {
            ListAutonomousContainerDatabasesRequest request = new ListAutonomousContainerDatabasesRequest();
            request.compartmentId = this.compartmentId;
            request.autonomousExadataInfrastructureId = this.autonomousExadataInfrastructureId;
            request.autonomousVmClusterId = this.autonomousVmClusterId;
            request.infrastructureType = this.infrastructureType;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            request.availabilityDomain = this.availabilityDomain;
            request.displayName = this.displayName;
            request.serviceLevelAgreementType = this.serviceLevelAgreementType;
            request.cloudAutonomousVmClusterId = this.cloudAutonomousVmClusterId;
            return request;
        }
    }
}

