/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSchedulingWindowRequest
extends BmcRequest<Void> {
    private String schedulingPolicyId;
    private String schedulingWindowId;
    private String opcRequestId;

    public String getSchedulingPolicyId() {
        return this.schedulingPolicyId;
    }

    public String getSchedulingWindowId() {
        return this.schedulingWindowId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().schedulingPolicyId(this.schedulingPolicyId).schedulingWindowId(this.schedulingWindowId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulingPolicyId=").append(String.valueOf(this.schedulingPolicyId));
        sb.append(",schedulingWindowId=").append(String.valueOf(this.schedulingWindowId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSchedulingWindowRequest)) {
            return false;
        }
        GetSchedulingWindowRequest other = (GetSchedulingWindowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulingPolicyId, other.schedulingPolicyId) && Objects.equals(this.schedulingWindowId, other.schedulingWindowId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulingPolicyId == null ? 43 : this.schedulingPolicyId.hashCode());
        result = result * 59 + (this.schedulingWindowId == null ? 43 : this.schedulingWindowId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSchedulingWindowRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulingPolicyId = null;
        private String schedulingWindowId = null;
        private String opcRequestId = null;

        public Builder schedulingPolicyId(String schedulingPolicyId) {
            this.schedulingPolicyId = schedulingPolicyId;
            return this;
        }

        public Builder schedulingWindowId(String schedulingWindowId) {
            this.schedulingWindowId = schedulingWindowId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSchedulingWindowRequest o) {
            this.schedulingPolicyId(o.getSchedulingPolicyId());
            this.schedulingWindowId(o.getSchedulingWindowId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSchedulingWindowRequest build() {
            GetSchedulingWindowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSchedulingWindowRequest buildWithoutInvocationCallback() {
            GetSchedulingWindowRequest request = new GetSchedulingWindowRequest();
            request.schedulingPolicyId = this.schedulingPolicyId;
            request.schedulingWindowId = this.schedulingWindowId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

