/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DisableAutonomousDatabaseOperationsInsightsRequest
extends BmcRequest<Void> {
    private String autonomousDatabaseId;
    private String opcRequestId;

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().autonomousDatabaseId(this.autonomousDatabaseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousDatabaseId=").append(String.valueOf(this.autonomousDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisableAutonomousDatabaseOperationsInsightsRequest)) {
            return false;
        }
        DisableAutonomousDatabaseOperationsInsightsRequest other = (DisableAutonomousDatabaseOperationsInsightsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousDatabaseId, other.autonomousDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousDatabaseId == null ? 43 : this.autonomousDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DisableAutonomousDatabaseOperationsInsightsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousDatabaseId = null;
        private String opcRequestId = null;

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DisableAutonomousDatabaseOperationsInsightsRequest o) {
            this.autonomousDatabaseId(o.getAutonomousDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DisableAutonomousDatabaseOperationsInsightsRequest build() {
            DisableAutonomousDatabaseOperationsInsightsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DisableAutonomousDatabaseOperationsInsightsRequest buildWithoutInvocationCallback() {
            DisableAutonomousDatabaseOperationsInsightsRequest request = new DisableAutonomousDatabaseOperationsInsightsRequest();
            request.autonomousDatabaseId = this.autonomousDatabaseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

