/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CascadingDeleteSchedulingPlanRequest
extends BmcRequest<Void> {
    private String schedulingPlanId;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getSchedulingPlanId() {
        return this.schedulingPlanId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().schedulingPlanId(this.schedulingPlanId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulingPlanId=").append(String.valueOf(this.schedulingPlanId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CascadingDeleteSchedulingPlanRequest)) {
            return false;
        }
        CascadingDeleteSchedulingPlanRequest other = (CascadingDeleteSchedulingPlanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulingPlanId, other.schedulingPlanId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulingPlanId == null ? 43 : this.schedulingPlanId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CascadingDeleteSchedulingPlanRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulingPlanId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder schedulingPlanId(String schedulingPlanId) {
            this.schedulingPlanId = schedulingPlanId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CascadingDeleteSchedulingPlanRequest o) {
            this.schedulingPlanId(o.getSchedulingPlanId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CascadingDeleteSchedulingPlanRequest build() {
            CascadingDeleteSchedulingPlanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public CascadingDeleteSchedulingPlanRequest buildWithoutInvocationCallback() {
            CascadingDeleteSchedulingPlanRequest request = new CascadingDeleteSchedulingPlanRequest();
            request.schedulingPlanId = this.schedulingPlanId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

