/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpgradeDbSystemDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="snapshotRetentionPeriodInDays")
    private final Integer snapshotRetentionPeriodInDays;
    @JsonProperty(value="newGiVersion")
    private final String newGiVersion;
    @JsonProperty(value="newOsVersion")
    private final String newOsVersion;
    @JsonProperty(value="isSnapshotRetentionDaysForceUpdated")
    private final Boolean isSnapshotRetentionDaysForceUpdated;

    @Deprecated
    @ConstructorProperties(value={"action", "snapshotRetentionPeriodInDays", "newGiVersion", "newOsVersion", "isSnapshotRetentionDaysForceUpdated"})
    public UpgradeDbSystemDetails(Action action, Integer snapshotRetentionPeriodInDays, String newGiVersion, String newOsVersion, Boolean isSnapshotRetentionDaysForceUpdated) {
        this.action = action;
        this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
        this.newGiVersion = newGiVersion;
        this.newOsVersion = newOsVersion;
        this.isSnapshotRetentionDaysForceUpdated = isSnapshotRetentionDaysForceUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Action getAction() {
        return this.action;
    }

    public Integer getSnapshotRetentionPeriodInDays() {
        return this.snapshotRetentionPeriodInDays;
    }

    public String getNewGiVersion() {
        return this.newGiVersion;
    }

    public String getNewOsVersion() {
        return this.newOsVersion;
    }

    public Boolean getIsSnapshotRetentionDaysForceUpdated() {
        return this.isSnapshotRetentionDaysForceUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpgradeDbSystemDetails(");
        sb.append("super=").append(super.toString());
        sb.append("action=").append(String.valueOf((Object)this.action));
        sb.append(", snapshotRetentionPeriodInDays=").append(String.valueOf(this.snapshotRetentionPeriodInDays));
        sb.append(", newGiVersion=").append(String.valueOf(this.newGiVersion));
        sb.append(", newOsVersion=").append(String.valueOf(this.newOsVersion));
        sb.append(", isSnapshotRetentionDaysForceUpdated=").append(String.valueOf(this.isSnapshotRetentionDaysForceUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpgradeDbSystemDetails)) {
            return false;
        }
        UpgradeDbSystemDetails other = (UpgradeDbSystemDetails)((Object)o);
        return Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.snapshotRetentionPeriodInDays, other.snapshotRetentionPeriodInDays) && Objects.equals(this.newGiVersion, other.newGiVersion) && Objects.equals(this.newOsVersion, other.newOsVersion) && Objects.equals(this.isSnapshotRetentionDaysForceUpdated, other.isSnapshotRetentionDaysForceUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.snapshotRetentionPeriodInDays == null ? 43 : this.snapshotRetentionPeriodInDays.hashCode());
        result = result * 59 + (this.newGiVersion == null ? 43 : this.newGiVersion.hashCode());
        result = result * 59 + (this.newOsVersion == null ? 43 : this.newOsVersion.hashCode());
        result = result * 59 + (this.isSnapshotRetentionDaysForceUpdated == null ? 43 : this.isSnapshotRetentionDaysForceUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Precheck("PRECHECK"),
        Rollback("ROLLBACK"),
        UpdateSnapshotRetentionDays("UPDATE_SNAPSHOT_RETENTION_DAYS"),
        Upgrade("UPGRADE");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="snapshotRetentionPeriodInDays")
        private Integer snapshotRetentionPeriodInDays;
        @JsonProperty(value="newGiVersion")
        private String newGiVersion;
        @JsonProperty(value="newOsVersion")
        private String newOsVersion;
        @JsonProperty(value="isSnapshotRetentionDaysForceUpdated")
        private Boolean isSnapshotRetentionDaysForceUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder snapshotRetentionPeriodInDays(Integer snapshotRetentionPeriodInDays) {
            this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
            this.__explicitlySet__.add("snapshotRetentionPeriodInDays");
            return this;
        }

        public Builder newGiVersion(String newGiVersion) {
            this.newGiVersion = newGiVersion;
            this.__explicitlySet__.add("newGiVersion");
            return this;
        }

        public Builder newOsVersion(String newOsVersion) {
            this.newOsVersion = newOsVersion;
            this.__explicitlySet__.add("newOsVersion");
            return this;
        }

        public Builder isSnapshotRetentionDaysForceUpdated(Boolean isSnapshotRetentionDaysForceUpdated) {
            this.isSnapshotRetentionDaysForceUpdated = isSnapshotRetentionDaysForceUpdated;
            this.__explicitlySet__.add("isSnapshotRetentionDaysForceUpdated");
            return this;
        }

        public UpgradeDbSystemDetails build() {
            UpgradeDbSystemDetails model = new UpgradeDbSystemDetails(this.action, this.snapshotRetentionPeriodInDays, this.newGiVersion, this.newOsVersion, this.isSnapshotRetentionDaysForceUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpgradeDbSystemDetails model) {
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("snapshotRetentionPeriodInDays")) {
                this.snapshotRetentionPeriodInDays(model.getSnapshotRetentionPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("newGiVersion")) {
                this.newGiVersion(model.getNewGiVersion());
            }
            if (model.wasPropertyExplicitlySet("newOsVersion")) {
                this.newOsVersion(model.getNewOsVersion());
            }
            if (model.wasPropertyExplicitlySet("isSnapshotRetentionDaysForceUpdated")) {
                this.isSnapshotRetentionDaysForceUpdated(model.getIsSnapshotRetentionDaysForceUpdated());
            }
            return this;
        }
    }
}

