/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="updateId")
    private final String updateId;
    @JsonProperty(value="updateAction")
    private final UpdateAction updateAction;
    @JsonProperty(value="giSoftwareImageId")
    private final String giSoftwareImageId;

    @Deprecated
    @ConstructorProperties(value={"updateId", "updateAction", "giSoftwareImageId"})
    public UpdateDetails(String updateId, UpdateAction updateAction, String giSoftwareImageId) {
        this.updateId = updateId;
        this.updateAction = updateAction;
        this.giSoftwareImageId = giSoftwareImageId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUpdateId() {
        return this.updateId;
    }

    public UpdateAction getUpdateAction() {
        return this.updateAction;
    }

    public String getGiSoftwareImageId() {
        return this.giSoftwareImageId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateDetails(");
        sb.append("super=").append(super.toString());
        sb.append("updateId=").append(String.valueOf(this.updateId));
        sb.append(", updateAction=").append(String.valueOf((Object)this.updateAction));
        sb.append(", giSoftwareImageId=").append(String.valueOf(this.giSoftwareImageId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDetails)) {
            return false;
        }
        UpdateDetails other = (UpdateDetails)((Object)o);
        return Objects.equals(this.updateId, other.updateId) && Objects.equals((Object)this.updateAction, (Object)other.updateAction) && Objects.equals(this.giSoftwareImageId, other.giSoftwareImageId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.updateId == null ? 43 : this.updateId.hashCode());
        result = result * 59 + (this.updateAction == null ? 43 : this.updateAction.hashCode());
        result = result * 59 + (this.giSoftwareImageId == null ? 43 : this.giSoftwareImageId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UpdateAction implements BmcEnum
    {
        RollingApply("ROLLING_APPLY"),
        NonRollingApply("NON_ROLLING_APPLY"),
        Precheck("PRECHECK"),
        Rollback("ROLLBACK");

        private final String value;
        private static Map<String, UpdateAction> map;

        private UpdateAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpdateAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UpdateAction: " + key);
        }

        static {
            map = new HashMap<String, UpdateAction>();
            for (UpdateAction v : UpdateAction.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="updateId")
        private String updateId;
        @JsonProperty(value="updateAction")
        private UpdateAction updateAction;
        @JsonProperty(value="giSoftwareImageId")
        private String giSoftwareImageId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder updateId(String updateId) {
            this.updateId = updateId;
            this.__explicitlySet__.add("updateId");
            return this;
        }

        public Builder updateAction(UpdateAction updateAction) {
            this.updateAction = updateAction;
            this.__explicitlySet__.add("updateAction");
            return this;
        }

        public Builder giSoftwareImageId(String giSoftwareImageId) {
            this.giSoftwareImageId = giSoftwareImageId;
            this.__explicitlySet__.add("giSoftwareImageId");
            return this;
        }

        public UpdateDetails build() {
            UpdateDetails model = new UpdateDetails(this.updateId, this.updateAction, this.giSoftwareImageId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateDetails model) {
            if (model.wasPropertyExplicitlySet("updateId")) {
                this.updateId(model.getUpdateId());
            }
            if (model.wasPropertyExplicitlySet("updateAction")) {
                this.updateAction(model.getUpdateAction());
            }
            if (model.wasPropertyExplicitlySet("giSoftwareImageId")) {
                this.giSoftwareImageId(model.getGiSoftwareImageId());
            }
            return this;
        }
    }
}

