/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AutonomousDatabaseEncryptionKeyDetails;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.database.model.CustomerContact;
import com.oracle.bmc.database.model.DatabaseTool;
import com.oracle.bmc.database.model.LongTermBackUpScheduleDetails;
import com.oracle.bmc.database.model.ResourcePoolSummary;
import com.oracle.bmc.database.model.ScheduledOperationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateAutonomousDatabaseDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="backupRetentionPeriodInDays")
    private final Integer backupRetentionPeriodInDays;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;
    @JsonProperty(value="inMemoryPercentage")
    private final Integer inMemoryPercentage;
    @JsonProperty(value="localAdgAutoFailoverMaxDataLossLimit")
    private final Integer localAdgAutoFailoverMaxDataLossLimit;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="longTermBackupSchedule")
    private final LongTermBackUpScheduleDetails longTermBackupSchedule;
    @JsonProperty(value="isDevTier")
    private final Boolean isDevTier;
    @JsonProperty(value="computeCount")
    private final Float computeCount;
    @JsonProperty(value="ocpuCount")
    private final Float ocpuCount;
    @JsonProperty(value="dataStorageSizeInTBs")
    private final Integer dataStorageSizeInTBs;
    @JsonProperty(value="dataStorageSizeInGBs")
    private final Integer dataStorageSizeInGBs;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="isFreeTier")
    private final Boolean isFreeTier;
    @JsonProperty(value="adminPassword")
    private final String adminPassword;
    @JsonProperty(value="dbName")
    private final String dbName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="securityAttributes")
    private final Map<String, Map<String, Object>> securityAttributes;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="byolComputeCountLimit")
    private final Float byolComputeCountLimit;
    @JsonProperty(value="isAccessControlEnabled")
    private final Boolean isAccessControlEnabled;
    @JsonProperty(value="whitelistedIps")
    private final List<String> whitelistedIps;
    @JsonProperty(value="arePrimaryWhitelistedIpsUsed")
    private final Boolean arePrimaryWhitelistedIpsUsed;
    @JsonProperty(value="standbyWhitelistedIps")
    private final List<String> standbyWhitelistedIps;
    @JsonProperty(value="isAutoScalingEnabled")
    private final Boolean isAutoScalingEnabled;
    @JsonProperty(value="isRefreshableClone")
    private final Boolean isRefreshableClone;
    @JsonProperty(value="refreshableMode")
    private final RefreshableMode refreshableMode;
    @JsonProperty(value="isLocalDataGuardEnabled")
    private final Boolean isLocalDataGuardEnabled;
    @JsonProperty(value="isDataGuardEnabled")
    private final Boolean isDataGuardEnabled;
    @JsonProperty(value="peerDbId")
    private final String peerDbId;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="openMode")
    private final OpenMode openMode;
    @JsonProperty(value="permissionLevel")
    private final PermissionLevel permissionLevel;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="privateEndpointLabel")
    private final String privateEndpointLabel;
    @JsonProperty(value="privateEndpointIp")
    private final String privateEndpointIp;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="autoRefreshFrequencyInSeconds")
    private final Integer autoRefreshFrequencyInSeconds;
    @JsonProperty(value="autoRefreshPointLagInSeconds")
    private final Integer autoRefreshPointLagInSeconds;
    @JsonProperty(value="timeOfAutoRefreshStart")
    private final Date timeOfAutoRefreshStart;
    @JsonProperty(value="customerContacts")
    private final List<CustomerContact> customerContacts;
    @JsonProperty(value="isMtlsConnectionRequired")
    private final Boolean isMtlsConnectionRequired;
    @JsonProperty(value="resourcePoolLeaderId")
    private final String resourcePoolLeaderId;
    @JsonProperty(value="resourcePoolSummary")
    private final ResourcePoolSummary resourcePoolSummary;
    @JsonProperty(value="autonomousMaintenanceScheduleType")
    private final AutonomousMaintenanceScheduleType autonomousMaintenanceScheduleType;
    @JsonProperty(value="isBackupRetentionLocked")
    private final Boolean isBackupRetentionLocked;
    @JsonProperty(value="scheduledOperations")
    private final List<ScheduledOperationDetails> scheduledOperations;
    @JsonProperty(value="isAutoScalingForStorageEnabled")
    private final Boolean isAutoScalingForStorageEnabled;
    @JsonProperty(value="databaseEdition")
    private final AutonomousDatabaseSummary.DatabaseEdition databaseEdition;
    @JsonProperty(value="dbToolsDetails")
    private final List<DatabaseTool> dbToolsDetails;
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="secretVersionNumber")
    private final Integer secretVersionNumber;
    @JsonProperty(value="encryptionKey")
    private final AutonomousDatabaseEncryptionKeyDetails encryptionKey;
    @JsonProperty(value="isDisconnectPeer")
    private final Boolean isDisconnectPeer;

    @Deprecated
    @ConstructorProperties(value={"backupRetentionPeriodInDays", "computeModel", "inMemoryPercentage", "localAdgAutoFailoverMaxDataLossLimit", "cpuCoreCount", "longTermBackupSchedule", "isDevTier", "computeCount", "ocpuCount", "dataStorageSizeInTBs", "dataStorageSizeInGBs", "displayName", "isFreeTier", "adminPassword", "dbName", "freeformTags", "definedTags", "securityAttributes", "dbWorkload", "licenseModel", "byolComputeCountLimit", "isAccessControlEnabled", "whitelistedIps", "arePrimaryWhitelistedIpsUsed", "standbyWhitelistedIps", "isAutoScalingEnabled", "isRefreshableClone", "refreshableMode", "isLocalDataGuardEnabled", "isDataGuardEnabled", "peerDbId", "dbVersion", "openMode", "permissionLevel", "subnetId", "privateEndpointLabel", "privateEndpointIp", "nsgIds", "autoRefreshFrequencyInSeconds", "autoRefreshPointLagInSeconds", "timeOfAutoRefreshStart", "customerContacts", "isMtlsConnectionRequired", "resourcePoolLeaderId", "resourcePoolSummary", "autonomousMaintenanceScheduleType", "isBackupRetentionLocked", "scheduledOperations", "isAutoScalingForStorageEnabled", "databaseEdition", "dbToolsDetails", "secretId", "secretVersionNumber", "encryptionKey", "isDisconnectPeer"})
    public UpdateAutonomousDatabaseDetails(Integer backupRetentionPeriodInDays, ComputeModel computeModel, Integer inMemoryPercentage, Integer localAdgAutoFailoverMaxDataLossLimit, Integer cpuCoreCount, LongTermBackUpScheduleDetails longTermBackupSchedule, Boolean isDevTier, Float computeCount, Float ocpuCount, Integer dataStorageSizeInTBs, Integer dataStorageSizeInGBs, String displayName, Boolean isFreeTier, String adminPassword, String dbName, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> securityAttributes, DbWorkload dbWorkload, LicenseModel licenseModel, Float byolComputeCountLimit, Boolean isAccessControlEnabled, List<String> whitelistedIps, Boolean arePrimaryWhitelistedIpsUsed, List<String> standbyWhitelistedIps, Boolean isAutoScalingEnabled, Boolean isRefreshableClone, RefreshableMode refreshableMode, Boolean isLocalDataGuardEnabled, Boolean isDataGuardEnabled, String peerDbId, String dbVersion, OpenMode openMode, PermissionLevel permissionLevel, String subnetId, String privateEndpointLabel, String privateEndpointIp, List<String> nsgIds, Integer autoRefreshFrequencyInSeconds, Integer autoRefreshPointLagInSeconds, Date timeOfAutoRefreshStart, List<CustomerContact> customerContacts, Boolean isMtlsConnectionRequired, String resourcePoolLeaderId, ResourcePoolSummary resourcePoolSummary, AutonomousMaintenanceScheduleType autonomousMaintenanceScheduleType, Boolean isBackupRetentionLocked, List<ScheduledOperationDetails> scheduledOperations, Boolean isAutoScalingForStorageEnabled, AutonomousDatabaseSummary.DatabaseEdition databaseEdition, List<DatabaseTool> dbToolsDetails, String secretId, Integer secretVersionNumber, AutonomousDatabaseEncryptionKeyDetails encryptionKey, Boolean isDisconnectPeer) {
        this.backupRetentionPeriodInDays = backupRetentionPeriodInDays;
        this.computeModel = computeModel;
        this.inMemoryPercentage = inMemoryPercentage;
        this.localAdgAutoFailoverMaxDataLossLimit = localAdgAutoFailoverMaxDataLossLimit;
        this.cpuCoreCount = cpuCoreCount;
        this.longTermBackupSchedule = longTermBackupSchedule;
        this.isDevTier = isDevTier;
        this.computeCount = computeCount;
        this.ocpuCount = ocpuCount;
        this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        this.displayName = displayName;
        this.isFreeTier = isFreeTier;
        this.adminPassword = adminPassword;
        this.dbName = dbName;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.securityAttributes = securityAttributes;
        this.dbWorkload = dbWorkload;
        this.licenseModel = licenseModel;
        this.byolComputeCountLimit = byolComputeCountLimit;
        this.isAccessControlEnabled = isAccessControlEnabled;
        this.whitelistedIps = whitelistedIps;
        this.arePrimaryWhitelistedIpsUsed = arePrimaryWhitelistedIpsUsed;
        this.standbyWhitelistedIps = standbyWhitelistedIps;
        this.isAutoScalingEnabled = isAutoScalingEnabled;
        this.isRefreshableClone = isRefreshableClone;
        this.refreshableMode = refreshableMode;
        this.isLocalDataGuardEnabled = isLocalDataGuardEnabled;
        this.isDataGuardEnabled = isDataGuardEnabled;
        this.peerDbId = peerDbId;
        this.dbVersion = dbVersion;
        this.openMode = openMode;
        this.permissionLevel = permissionLevel;
        this.subnetId = subnetId;
        this.privateEndpointLabel = privateEndpointLabel;
        this.privateEndpointIp = privateEndpointIp;
        this.nsgIds = nsgIds;
        this.autoRefreshFrequencyInSeconds = autoRefreshFrequencyInSeconds;
        this.autoRefreshPointLagInSeconds = autoRefreshPointLagInSeconds;
        this.timeOfAutoRefreshStart = timeOfAutoRefreshStart;
        this.customerContacts = customerContacts;
        this.isMtlsConnectionRequired = isMtlsConnectionRequired;
        this.resourcePoolLeaderId = resourcePoolLeaderId;
        this.resourcePoolSummary = resourcePoolSummary;
        this.autonomousMaintenanceScheduleType = autonomousMaintenanceScheduleType;
        this.isBackupRetentionLocked = isBackupRetentionLocked;
        this.scheduledOperations = scheduledOperations;
        this.isAutoScalingForStorageEnabled = isAutoScalingForStorageEnabled;
        this.databaseEdition = databaseEdition;
        this.dbToolsDetails = dbToolsDetails;
        this.secretId = secretId;
        this.secretVersionNumber = secretVersionNumber;
        this.encryptionKey = encryptionKey;
        this.isDisconnectPeer = isDisconnectPeer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getBackupRetentionPeriodInDays() {
        return this.backupRetentionPeriodInDays;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public Integer getInMemoryPercentage() {
        return this.inMemoryPercentage;
    }

    public Integer getLocalAdgAutoFailoverMaxDataLossLimit() {
        return this.localAdgAutoFailoverMaxDataLossLimit;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public LongTermBackUpScheduleDetails getLongTermBackupSchedule() {
        return this.longTermBackupSchedule;
    }

    public Boolean getIsDevTier() {
        return this.isDevTier;
    }

    public Float getComputeCount() {
        return this.computeCount;
    }

    public Float getOcpuCount() {
        return this.ocpuCount;
    }

    public Integer getDataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public Integer getDataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsFreeTier() {
        return this.isFreeTier;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSecurityAttributes() {
        return this.securityAttributes;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public Float getByolComputeCountLimit() {
        return this.byolComputeCountLimit;
    }

    public Boolean getIsAccessControlEnabled() {
        return this.isAccessControlEnabled;
    }

    public List<String> getWhitelistedIps() {
        return this.whitelistedIps;
    }

    public Boolean getArePrimaryWhitelistedIpsUsed() {
        return this.arePrimaryWhitelistedIpsUsed;
    }

    public List<String> getStandbyWhitelistedIps() {
        return this.standbyWhitelistedIps;
    }

    public Boolean getIsAutoScalingEnabled() {
        return this.isAutoScalingEnabled;
    }

    public Boolean getIsRefreshableClone() {
        return this.isRefreshableClone;
    }

    public RefreshableMode getRefreshableMode() {
        return this.refreshableMode;
    }

    public Boolean getIsLocalDataGuardEnabled() {
        return this.isLocalDataGuardEnabled;
    }

    public Boolean getIsDataGuardEnabled() {
        return this.isDataGuardEnabled;
    }

    public String getPeerDbId() {
        return this.peerDbId;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public OpenMode getOpenMode() {
        return this.openMode;
    }

    public PermissionLevel getPermissionLevel() {
        return this.permissionLevel;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getPrivateEndpointLabel() {
        return this.privateEndpointLabel;
    }

    public String getPrivateEndpointIp() {
        return this.privateEndpointIp;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public Integer getAutoRefreshFrequencyInSeconds() {
        return this.autoRefreshFrequencyInSeconds;
    }

    public Integer getAutoRefreshPointLagInSeconds() {
        return this.autoRefreshPointLagInSeconds;
    }

    public Date getTimeOfAutoRefreshStart() {
        return this.timeOfAutoRefreshStart;
    }

    public List<CustomerContact> getCustomerContacts() {
        return this.customerContacts;
    }

    public Boolean getIsMtlsConnectionRequired() {
        return this.isMtlsConnectionRequired;
    }

    public String getResourcePoolLeaderId() {
        return this.resourcePoolLeaderId;
    }

    public ResourcePoolSummary getResourcePoolSummary() {
        return this.resourcePoolSummary;
    }

    public AutonomousMaintenanceScheduleType getAutonomousMaintenanceScheduleType() {
        return this.autonomousMaintenanceScheduleType;
    }

    public Boolean getIsBackupRetentionLocked() {
        return this.isBackupRetentionLocked;
    }

    public List<ScheduledOperationDetails> getScheduledOperations() {
        return this.scheduledOperations;
    }

    public Boolean getIsAutoScalingForStorageEnabled() {
        return this.isAutoScalingForStorageEnabled;
    }

    public AutonomousDatabaseSummary.DatabaseEdition getDatabaseEdition() {
        return this.databaseEdition;
    }

    public List<DatabaseTool> getDbToolsDetails() {
        return this.dbToolsDetails;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public Integer getSecretVersionNumber() {
        return this.secretVersionNumber;
    }

    public AutonomousDatabaseEncryptionKeyDetails getEncryptionKey() {
        return this.encryptionKey;
    }

    public Boolean getIsDisconnectPeer() {
        return this.isDisconnectPeer;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateAutonomousDatabaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("backupRetentionPeriodInDays=").append(String.valueOf(this.backupRetentionPeriodInDays));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(", inMemoryPercentage=").append(String.valueOf(this.inMemoryPercentage));
        sb.append(", localAdgAutoFailoverMaxDataLossLimit=").append(String.valueOf(this.localAdgAutoFailoverMaxDataLossLimit));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", longTermBackupSchedule=").append(String.valueOf((Object)this.longTermBackupSchedule));
        sb.append(", isDevTier=").append(String.valueOf(this.isDevTier));
        sb.append(", computeCount=").append(String.valueOf(this.computeCount));
        sb.append(", ocpuCount=").append(String.valueOf(this.ocpuCount));
        sb.append(", dataStorageSizeInTBs=").append(String.valueOf(this.dataStorageSizeInTBs));
        sb.append(", dataStorageSizeInGBs=").append(String.valueOf(this.dataStorageSizeInGBs));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", isFreeTier=").append(String.valueOf(this.isFreeTier));
        sb.append(", adminPassword=").append(String.valueOf(this.adminPassword));
        sb.append(", dbName=").append(String.valueOf(this.dbName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", securityAttributes=").append(String.valueOf(this.securityAttributes));
        sb.append(", dbWorkload=").append(String.valueOf((Object)this.dbWorkload));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", byolComputeCountLimit=").append(String.valueOf(this.byolComputeCountLimit));
        sb.append(", isAccessControlEnabled=").append(String.valueOf(this.isAccessControlEnabled));
        sb.append(", whitelistedIps=").append(String.valueOf(this.whitelistedIps));
        sb.append(", arePrimaryWhitelistedIpsUsed=").append(String.valueOf(this.arePrimaryWhitelistedIpsUsed));
        sb.append(", standbyWhitelistedIps=").append(String.valueOf(this.standbyWhitelistedIps));
        sb.append(", isAutoScalingEnabled=").append(String.valueOf(this.isAutoScalingEnabled));
        sb.append(", isRefreshableClone=").append(String.valueOf(this.isRefreshableClone));
        sb.append(", refreshableMode=").append(String.valueOf((Object)this.refreshableMode));
        sb.append(", isLocalDataGuardEnabled=").append(String.valueOf(this.isLocalDataGuardEnabled));
        sb.append(", isDataGuardEnabled=").append(String.valueOf(this.isDataGuardEnabled));
        sb.append(", peerDbId=").append(String.valueOf(this.peerDbId));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", openMode=").append(String.valueOf((Object)this.openMode));
        sb.append(", permissionLevel=").append(String.valueOf((Object)this.permissionLevel));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", privateEndpointLabel=").append(String.valueOf(this.privateEndpointLabel));
        sb.append(", privateEndpointIp=").append(String.valueOf(this.privateEndpointIp));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", autoRefreshFrequencyInSeconds=").append(String.valueOf(this.autoRefreshFrequencyInSeconds));
        sb.append(", autoRefreshPointLagInSeconds=").append(String.valueOf(this.autoRefreshPointLagInSeconds));
        sb.append(", timeOfAutoRefreshStart=").append(String.valueOf(this.timeOfAutoRefreshStart));
        sb.append(", customerContacts=").append(String.valueOf(this.customerContacts));
        sb.append(", isMtlsConnectionRequired=").append(String.valueOf(this.isMtlsConnectionRequired));
        sb.append(", resourcePoolLeaderId=").append(String.valueOf(this.resourcePoolLeaderId));
        sb.append(", resourcePoolSummary=").append(String.valueOf((Object)this.resourcePoolSummary));
        sb.append(", autonomousMaintenanceScheduleType=").append(String.valueOf((Object)this.autonomousMaintenanceScheduleType));
        sb.append(", isBackupRetentionLocked=").append(String.valueOf(this.isBackupRetentionLocked));
        sb.append(", scheduledOperations=").append(String.valueOf(this.scheduledOperations));
        sb.append(", isAutoScalingForStorageEnabled=").append(String.valueOf(this.isAutoScalingForStorageEnabled));
        sb.append(", databaseEdition=").append(String.valueOf((Object)this.databaseEdition));
        sb.append(", dbToolsDetails=").append(String.valueOf(this.dbToolsDetails));
        sb.append(", secretId=").append(String.valueOf(this.secretId));
        sb.append(", secretVersionNumber=").append(String.valueOf(this.secretVersionNumber));
        sb.append(", encryptionKey=").append(String.valueOf((Object)this.encryptionKey));
        sb.append(", isDisconnectPeer=").append(String.valueOf(this.isDisconnectPeer));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAutonomousDatabaseDetails)) {
            return false;
        }
        UpdateAutonomousDatabaseDetails other = (UpdateAutonomousDatabaseDetails)((Object)o);
        return Objects.equals(this.backupRetentionPeriodInDays, other.backupRetentionPeriodInDays) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && Objects.equals(this.inMemoryPercentage, other.inMemoryPercentage) && Objects.equals(this.localAdgAutoFailoverMaxDataLossLimit, other.localAdgAutoFailoverMaxDataLossLimit) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals((Object)this.longTermBackupSchedule, (Object)other.longTermBackupSchedule) && Objects.equals(this.isDevTier, other.isDevTier) && Objects.equals(this.computeCount, other.computeCount) && Objects.equals(this.ocpuCount, other.ocpuCount) && Objects.equals(this.dataStorageSizeInTBs, other.dataStorageSizeInTBs) && Objects.equals(this.dataStorageSizeInGBs, other.dataStorageSizeInGBs) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.isFreeTier, other.isFreeTier) && Objects.equals(this.adminPassword, other.adminPassword) && Objects.equals(this.dbName, other.dbName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.securityAttributes, other.securityAttributes) && Objects.equals((Object)this.dbWorkload, (Object)other.dbWorkload) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.byolComputeCountLimit, other.byolComputeCountLimit) && Objects.equals(this.isAccessControlEnabled, other.isAccessControlEnabled) && Objects.equals(this.whitelistedIps, other.whitelistedIps) && Objects.equals(this.arePrimaryWhitelistedIpsUsed, other.arePrimaryWhitelistedIpsUsed) && Objects.equals(this.standbyWhitelistedIps, other.standbyWhitelistedIps) && Objects.equals(this.isAutoScalingEnabled, other.isAutoScalingEnabled) && Objects.equals(this.isRefreshableClone, other.isRefreshableClone) && Objects.equals((Object)this.refreshableMode, (Object)other.refreshableMode) && Objects.equals(this.isLocalDataGuardEnabled, other.isLocalDataGuardEnabled) && Objects.equals(this.isDataGuardEnabled, other.isDataGuardEnabled) && Objects.equals(this.peerDbId, other.peerDbId) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals((Object)this.openMode, (Object)other.openMode) && Objects.equals((Object)this.permissionLevel, (Object)other.permissionLevel) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.privateEndpointLabel, other.privateEndpointLabel) && Objects.equals(this.privateEndpointIp, other.privateEndpointIp) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.autoRefreshFrequencyInSeconds, other.autoRefreshFrequencyInSeconds) && Objects.equals(this.autoRefreshPointLagInSeconds, other.autoRefreshPointLagInSeconds) && Objects.equals(this.timeOfAutoRefreshStart, other.timeOfAutoRefreshStart) && Objects.equals(this.customerContacts, other.customerContacts) && Objects.equals(this.isMtlsConnectionRequired, other.isMtlsConnectionRequired) && Objects.equals(this.resourcePoolLeaderId, other.resourcePoolLeaderId) && Objects.equals((Object)this.resourcePoolSummary, (Object)other.resourcePoolSummary) && Objects.equals((Object)this.autonomousMaintenanceScheduleType, (Object)other.autonomousMaintenanceScheduleType) && Objects.equals(this.isBackupRetentionLocked, other.isBackupRetentionLocked) && Objects.equals(this.scheduledOperations, other.scheduledOperations) && Objects.equals(this.isAutoScalingForStorageEnabled, other.isAutoScalingForStorageEnabled) && Objects.equals((Object)this.databaseEdition, (Object)other.databaseEdition) && Objects.equals(this.dbToolsDetails, other.dbToolsDetails) && Objects.equals(this.secretId, other.secretId) && Objects.equals(this.secretVersionNumber, other.secretVersionNumber) && Objects.equals((Object)this.encryptionKey, (Object)other.encryptionKey) && Objects.equals(this.isDisconnectPeer, other.isDisconnectPeer) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.backupRetentionPeriodInDays == null ? 43 : this.backupRetentionPeriodInDays.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + (this.inMemoryPercentage == null ? 43 : this.inMemoryPercentage.hashCode());
        result = result * 59 + (this.localAdgAutoFailoverMaxDataLossLimit == null ? 43 : this.localAdgAutoFailoverMaxDataLossLimit.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.longTermBackupSchedule == null ? 43 : this.longTermBackupSchedule.hashCode());
        result = result * 59 + (this.isDevTier == null ? 43 : this.isDevTier.hashCode());
        result = result * 59 + (this.computeCount == null ? 43 : this.computeCount.hashCode());
        result = result * 59 + (this.ocpuCount == null ? 43 : this.ocpuCount.hashCode());
        result = result * 59 + (this.dataStorageSizeInTBs == null ? 43 : this.dataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.dataStorageSizeInGBs == null ? 43 : this.dataStorageSizeInGBs.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.isFreeTier == null ? 43 : this.isFreeTier.hashCode());
        result = result * 59 + (this.adminPassword == null ? 43 : this.adminPassword.hashCode());
        result = result * 59 + (this.dbName == null ? 43 : this.dbName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.securityAttributes == null ? 43 : this.securityAttributes.hashCode());
        result = result * 59 + (this.dbWorkload == null ? 43 : this.dbWorkload.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.byolComputeCountLimit == null ? 43 : this.byolComputeCountLimit.hashCode());
        result = result * 59 + (this.isAccessControlEnabled == null ? 43 : this.isAccessControlEnabled.hashCode());
        result = result * 59 + (this.whitelistedIps == null ? 43 : this.whitelistedIps.hashCode());
        result = result * 59 + (this.arePrimaryWhitelistedIpsUsed == null ? 43 : this.arePrimaryWhitelistedIpsUsed.hashCode());
        result = result * 59 + (this.standbyWhitelistedIps == null ? 43 : this.standbyWhitelistedIps.hashCode());
        result = result * 59 + (this.isAutoScalingEnabled == null ? 43 : this.isAutoScalingEnabled.hashCode());
        result = result * 59 + (this.isRefreshableClone == null ? 43 : this.isRefreshableClone.hashCode());
        result = result * 59 + (this.refreshableMode == null ? 43 : this.refreshableMode.hashCode());
        result = result * 59 + (this.isLocalDataGuardEnabled == null ? 43 : this.isLocalDataGuardEnabled.hashCode());
        result = result * 59 + (this.isDataGuardEnabled == null ? 43 : this.isDataGuardEnabled.hashCode());
        result = result * 59 + (this.peerDbId == null ? 43 : this.peerDbId.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.openMode == null ? 43 : this.openMode.hashCode());
        result = result * 59 + (this.permissionLevel == null ? 43 : this.permissionLevel.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.privateEndpointLabel == null ? 43 : this.privateEndpointLabel.hashCode());
        result = result * 59 + (this.privateEndpointIp == null ? 43 : this.privateEndpointIp.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.autoRefreshFrequencyInSeconds == null ? 43 : this.autoRefreshFrequencyInSeconds.hashCode());
        result = result * 59 + (this.autoRefreshPointLagInSeconds == null ? 43 : this.autoRefreshPointLagInSeconds.hashCode());
        result = result * 59 + (this.timeOfAutoRefreshStart == null ? 43 : this.timeOfAutoRefreshStart.hashCode());
        result = result * 59 + (this.customerContacts == null ? 43 : this.customerContacts.hashCode());
        result = result * 59 + (this.isMtlsConnectionRequired == null ? 43 : this.isMtlsConnectionRequired.hashCode());
        result = result * 59 + (this.resourcePoolLeaderId == null ? 43 : this.resourcePoolLeaderId.hashCode());
        result = result * 59 + (this.resourcePoolSummary == null ? 43 : this.resourcePoolSummary.hashCode());
        result = result * 59 + (this.autonomousMaintenanceScheduleType == null ? 43 : this.autonomousMaintenanceScheduleType.hashCode());
        result = result * 59 + (this.isBackupRetentionLocked == null ? 43 : this.isBackupRetentionLocked.hashCode());
        result = result * 59 + (this.scheduledOperations == null ? 43 : this.scheduledOperations.hashCode());
        result = result * 59 + (this.isAutoScalingForStorageEnabled == null ? 43 : this.isAutoScalingForStorageEnabled.hashCode());
        result = result * 59 + (this.databaseEdition == null ? 43 : this.databaseEdition.hashCode());
        result = result * 59 + (this.dbToolsDetails == null ? 43 : this.dbToolsDetails.hashCode());
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.secretVersionNumber == null ? 43 : this.secretVersionNumber.hashCode());
        result = result * 59 + (this.encryptionKey == null ? 43 : this.encryptionKey.hashCode());
        result = result * 59 + (this.isDisconnectPeer == null ? 43 : this.isDisconnectPeer.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU");

        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ComputeModel: " + key);
        }

        static {
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DbWorkload implements BmcEnum
    {
        Oltp("OLTP"),
        Dw("DW"),
        Ajd("AJD"),
        Apex("APEX");

        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DbWorkload: " + key);
        }

        static {
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RefreshableMode implements BmcEnum
    {
        Automatic("AUTOMATIC"),
        Manual("MANUAL");

        private final String value;
        private static Map<String, RefreshableMode> map;

        private RefreshableMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RefreshableMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RefreshableMode: " + key);
        }

        static {
            map = new HashMap<String, RefreshableMode>();
            for (RefreshableMode v : RefreshableMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OpenMode implements BmcEnum
    {
        ReadOnly("READ_ONLY"),
        ReadWrite("READ_WRITE");

        private final String value;
        private static Map<String, OpenMode> map;

        private OpenMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OpenMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OpenMode: " + key);
        }

        static {
            map = new HashMap<String, OpenMode>();
            for (OpenMode v : OpenMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PermissionLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Unrestricted("UNRESTRICTED");

        private final String value;
        private static Map<String, PermissionLevel> map;

        private PermissionLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PermissionLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PermissionLevel: " + key);
        }

        static {
            map = new HashMap<String, PermissionLevel>();
            for (PermissionLevel v : PermissionLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AutonomousMaintenanceScheduleType implements BmcEnum
    {
        Early("EARLY"),
        Regular("REGULAR");

        private final String value;
        private static Map<String, AutonomousMaintenanceScheduleType> map;

        private AutonomousMaintenanceScheduleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AutonomousMaintenanceScheduleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AutonomousMaintenanceScheduleType: " + key);
        }

        static {
            map = new HashMap<String, AutonomousMaintenanceScheduleType>();
            for (AutonomousMaintenanceScheduleType v : AutonomousMaintenanceScheduleType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="backupRetentionPeriodInDays")
        private Integer backupRetentionPeriodInDays;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonProperty(value="inMemoryPercentage")
        private Integer inMemoryPercentage;
        @JsonProperty(value="localAdgAutoFailoverMaxDataLossLimit")
        private Integer localAdgAutoFailoverMaxDataLossLimit;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="longTermBackupSchedule")
        private LongTermBackUpScheduleDetails longTermBackupSchedule;
        @JsonProperty(value="isDevTier")
        private Boolean isDevTier;
        @JsonProperty(value="computeCount")
        private Float computeCount;
        @JsonProperty(value="ocpuCount")
        private Float ocpuCount;
        @JsonProperty(value="dataStorageSizeInTBs")
        private Integer dataStorageSizeInTBs;
        @JsonProperty(value="dataStorageSizeInGBs")
        private Integer dataStorageSizeInGBs;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="isFreeTier")
        private Boolean isFreeTier;
        @JsonProperty(value="adminPassword")
        private String adminPassword;
        @JsonProperty(value="dbName")
        private String dbName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="securityAttributes")
        private Map<String, Map<String, Object>> securityAttributes;
        @JsonProperty(value="dbWorkload")
        private DbWorkload dbWorkload;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="byolComputeCountLimit")
        private Float byolComputeCountLimit;
        @JsonProperty(value="isAccessControlEnabled")
        private Boolean isAccessControlEnabled;
        @JsonProperty(value="whitelistedIps")
        private List<String> whitelistedIps;
        @JsonProperty(value="arePrimaryWhitelistedIpsUsed")
        private Boolean arePrimaryWhitelistedIpsUsed;
        @JsonProperty(value="standbyWhitelistedIps")
        private List<String> standbyWhitelistedIps;
        @JsonProperty(value="isAutoScalingEnabled")
        private Boolean isAutoScalingEnabled;
        @JsonProperty(value="isRefreshableClone")
        private Boolean isRefreshableClone;
        @JsonProperty(value="refreshableMode")
        private RefreshableMode refreshableMode;
        @JsonProperty(value="isLocalDataGuardEnabled")
        private Boolean isLocalDataGuardEnabled;
        @JsonProperty(value="isDataGuardEnabled")
        private Boolean isDataGuardEnabled;
        @JsonProperty(value="peerDbId")
        private String peerDbId;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="openMode")
        private OpenMode openMode;
        @JsonProperty(value="permissionLevel")
        private PermissionLevel permissionLevel;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="privateEndpointLabel")
        private String privateEndpointLabel;
        @JsonProperty(value="privateEndpointIp")
        private String privateEndpointIp;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="autoRefreshFrequencyInSeconds")
        private Integer autoRefreshFrequencyInSeconds;
        @JsonProperty(value="autoRefreshPointLagInSeconds")
        private Integer autoRefreshPointLagInSeconds;
        @JsonProperty(value="timeOfAutoRefreshStart")
        private Date timeOfAutoRefreshStart;
        @JsonProperty(value="customerContacts")
        private List<CustomerContact> customerContacts;
        @JsonProperty(value="isMtlsConnectionRequired")
        private Boolean isMtlsConnectionRequired;
        @JsonProperty(value="resourcePoolLeaderId")
        private String resourcePoolLeaderId;
        @JsonProperty(value="resourcePoolSummary")
        private ResourcePoolSummary resourcePoolSummary;
        @JsonProperty(value="autonomousMaintenanceScheduleType")
        private AutonomousMaintenanceScheduleType autonomousMaintenanceScheduleType;
        @JsonProperty(value="isBackupRetentionLocked")
        private Boolean isBackupRetentionLocked;
        @JsonProperty(value="scheduledOperations")
        private List<ScheduledOperationDetails> scheduledOperations;
        @JsonProperty(value="isAutoScalingForStorageEnabled")
        private Boolean isAutoScalingForStorageEnabled;
        @JsonProperty(value="databaseEdition")
        private AutonomousDatabaseSummary.DatabaseEdition databaseEdition;
        @JsonProperty(value="dbToolsDetails")
        private List<DatabaseTool> dbToolsDetails;
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="secretVersionNumber")
        private Integer secretVersionNumber;
        @JsonProperty(value="encryptionKey")
        private AutonomousDatabaseEncryptionKeyDetails encryptionKey;
        @JsonProperty(value="isDisconnectPeer")
        private Boolean isDisconnectPeer;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder backupRetentionPeriodInDays(Integer backupRetentionPeriodInDays) {
            this.backupRetentionPeriodInDays = backupRetentionPeriodInDays;
            this.__explicitlySet__.add("backupRetentionPeriodInDays");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public Builder inMemoryPercentage(Integer inMemoryPercentage) {
            this.inMemoryPercentage = inMemoryPercentage;
            this.__explicitlySet__.add("inMemoryPercentage");
            return this;
        }

        public Builder localAdgAutoFailoverMaxDataLossLimit(Integer localAdgAutoFailoverMaxDataLossLimit) {
            this.localAdgAutoFailoverMaxDataLossLimit = localAdgAutoFailoverMaxDataLossLimit;
            this.__explicitlySet__.add("localAdgAutoFailoverMaxDataLossLimit");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder longTermBackupSchedule(LongTermBackUpScheduleDetails longTermBackupSchedule) {
            this.longTermBackupSchedule = longTermBackupSchedule;
            this.__explicitlySet__.add("longTermBackupSchedule");
            return this;
        }

        public Builder isDevTier(Boolean isDevTier) {
            this.isDevTier = isDevTier;
            this.__explicitlySet__.add("isDevTier");
            return this;
        }

        public Builder computeCount(Float computeCount) {
            this.computeCount = computeCount;
            this.__explicitlySet__.add("computeCount");
            return this;
        }

        public Builder ocpuCount(Float ocpuCount) {
            this.ocpuCount = ocpuCount;
            this.__explicitlySet__.add("ocpuCount");
            return this;
        }

        public Builder dataStorageSizeInTBs(Integer dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            this.__explicitlySet__.add("dataStorageSizeInTBs");
            return this;
        }

        public Builder dataStorageSizeInGBs(Integer dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            this.__explicitlySet__.add("dataStorageSizeInGBs");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder isFreeTier(Boolean isFreeTier) {
            this.isFreeTier = isFreeTier;
            this.__explicitlySet__.add("isFreeTier");
            return this;
        }

        public Builder adminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
            this.__explicitlySet__.add("adminPassword");
            return this;
        }

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            this.__explicitlySet__.add("dbName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder securityAttributes(Map<String, Map<String, Object>> securityAttributes) {
            this.securityAttributes = securityAttributes;
            this.__explicitlySet__.add("securityAttributes");
            return this;
        }

        public Builder dbWorkload(DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder byolComputeCountLimit(Float byolComputeCountLimit) {
            this.byolComputeCountLimit = byolComputeCountLimit;
            this.__explicitlySet__.add("byolComputeCountLimit");
            return this;
        }

        public Builder isAccessControlEnabled(Boolean isAccessControlEnabled) {
            this.isAccessControlEnabled = isAccessControlEnabled;
            this.__explicitlySet__.add("isAccessControlEnabled");
            return this;
        }

        public Builder whitelistedIps(List<String> whitelistedIps) {
            this.whitelistedIps = whitelistedIps;
            this.__explicitlySet__.add("whitelistedIps");
            return this;
        }

        public Builder arePrimaryWhitelistedIpsUsed(Boolean arePrimaryWhitelistedIpsUsed) {
            this.arePrimaryWhitelistedIpsUsed = arePrimaryWhitelistedIpsUsed;
            this.__explicitlySet__.add("arePrimaryWhitelistedIpsUsed");
            return this;
        }

        public Builder standbyWhitelistedIps(List<String> standbyWhitelistedIps) {
            this.standbyWhitelistedIps = standbyWhitelistedIps;
            this.__explicitlySet__.add("standbyWhitelistedIps");
            return this;
        }

        public Builder isAutoScalingEnabled(Boolean isAutoScalingEnabled) {
            this.isAutoScalingEnabled = isAutoScalingEnabled;
            this.__explicitlySet__.add("isAutoScalingEnabled");
            return this;
        }

        public Builder isRefreshableClone(Boolean isRefreshableClone) {
            this.isRefreshableClone = isRefreshableClone;
            this.__explicitlySet__.add("isRefreshableClone");
            return this;
        }

        public Builder refreshableMode(RefreshableMode refreshableMode) {
            this.refreshableMode = refreshableMode;
            this.__explicitlySet__.add("refreshableMode");
            return this;
        }

        public Builder isLocalDataGuardEnabled(Boolean isLocalDataGuardEnabled) {
            this.isLocalDataGuardEnabled = isLocalDataGuardEnabled;
            this.__explicitlySet__.add("isLocalDataGuardEnabled");
            return this;
        }

        public Builder isDataGuardEnabled(Boolean isDataGuardEnabled) {
            this.isDataGuardEnabled = isDataGuardEnabled;
            this.__explicitlySet__.add("isDataGuardEnabled");
            return this;
        }

        public Builder peerDbId(String peerDbId) {
            this.peerDbId = peerDbId;
            this.__explicitlySet__.add("peerDbId");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder openMode(OpenMode openMode) {
            this.openMode = openMode;
            this.__explicitlySet__.add("openMode");
            return this;
        }

        public Builder permissionLevel(PermissionLevel permissionLevel) {
            this.permissionLevel = permissionLevel;
            this.__explicitlySet__.add("permissionLevel");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder privateEndpointLabel(String privateEndpointLabel) {
            this.privateEndpointLabel = privateEndpointLabel;
            this.__explicitlySet__.add("privateEndpointLabel");
            return this;
        }

        public Builder privateEndpointIp(String privateEndpointIp) {
            this.privateEndpointIp = privateEndpointIp;
            this.__explicitlySet__.add("privateEndpointIp");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder autoRefreshFrequencyInSeconds(Integer autoRefreshFrequencyInSeconds) {
            this.autoRefreshFrequencyInSeconds = autoRefreshFrequencyInSeconds;
            this.__explicitlySet__.add("autoRefreshFrequencyInSeconds");
            return this;
        }

        public Builder autoRefreshPointLagInSeconds(Integer autoRefreshPointLagInSeconds) {
            this.autoRefreshPointLagInSeconds = autoRefreshPointLagInSeconds;
            this.__explicitlySet__.add("autoRefreshPointLagInSeconds");
            return this;
        }

        public Builder timeOfAutoRefreshStart(Date timeOfAutoRefreshStart) {
            this.timeOfAutoRefreshStart = timeOfAutoRefreshStart;
            this.__explicitlySet__.add("timeOfAutoRefreshStart");
            return this;
        }

        public Builder customerContacts(List<CustomerContact> customerContacts) {
            this.customerContacts = customerContacts;
            this.__explicitlySet__.add("customerContacts");
            return this;
        }

        public Builder isMtlsConnectionRequired(Boolean isMtlsConnectionRequired) {
            this.isMtlsConnectionRequired = isMtlsConnectionRequired;
            this.__explicitlySet__.add("isMtlsConnectionRequired");
            return this;
        }

        public Builder resourcePoolLeaderId(String resourcePoolLeaderId) {
            this.resourcePoolLeaderId = resourcePoolLeaderId;
            this.__explicitlySet__.add("resourcePoolLeaderId");
            return this;
        }

        public Builder resourcePoolSummary(ResourcePoolSummary resourcePoolSummary) {
            this.resourcePoolSummary = resourcePoolSummary;
            this.__explicitlySet__.add("resourcePoolSummary");
            return this;
        }

        public Builder autonomousMaintenanceScheduleType(AutonomousMaintenanceScheduleType autonomousMaintenanceScheduleType) {
            this.autonomousMaintenanceScheduleType = autonomousMaintenanceScheduleType;
            this.__explicitlySet__.add("autonomousMaintenanceScheduleType");
            return this;
        }

        public Builder isBackupRetentionLocked(Boolean isBackupRetentionLocked) {
            this.isBackupRetentionLocked = isBackupRetentionLocked;
            this.__explicitlySet__.add("isBackupRetentionLocked");
            return this;
        }

        public Builder scheduledOperations(List<ScheduledOperationDetails> scheduledOperations) {
            this.scheduledOperations = scheduledOperations;
            this.__explicitlySet__.add("scheduledOperations");
            return this;
        }

        public Builder isAutoScalingForStorageEnabled(Boolean isAutoScalingForStorageEnabled) {
            this.isAutoScalingForStorageEnabled = isAutoScalingForStorageEnabled;
            this.__explicitlySet__.add("isAutoScalingForStorageEnabled");
            return this;
        }

        public Builder databaseEdition(AutonomousDatabaseSummary.DatabaseEdition databaseEdition) {
            this.databaseEdition = databaseEdition;
            this.__explicitlySet__.add("databaseEdition");
            return this;
        }

        public Builder dbToolsDetails(List<DatabaseTool> dbToolsDetails) {
            this.dbToolsDetails = dbToolsDetails;
            this.__explicitlySet__.add("dbToolsDetails");
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder secretVersionNumber(Integer secretVersionNumber) {
            this.secretVersionNumber = secretVersionNumber;
            this.__explicitlySet__.add("secretVersionNumber");
            return this;
        }

        public Builder encryptionKey(AutonomousDatabaseEncryptionKeyDetails encryptionKey) {
            this.encryptionKey = encryptionKey;
            this.__explicitlySet__.add("encryptionKey");
            return this;
        }

        public Builder isDisconnectPeer(Boolean isDisconnectPeer) {
            this.isDisconnectPeer = isDisconnectPeer;
            this.__explicitlySet__.add("isDisconnectPeer");
            return this;
        }

        public UpdateAutonomousDatabaseDetails build() {
            UpdateAutonomousDatabaseDetails model = new UpdateAutonomousDatabaseDetails(this.backupRetentionPeriodInDays, this.computeModel, this.inMemoryPercentage, this.localAdgAutoFailoverMaxDataLossLimit, this.cpuCoreCount, this.longTermBackupSchedule, this.isDevTier, this.computeCount, this.ocpuCount, this.dataStorageSizeInTBs, this.dataStorageSizeInGBs, this.displayName, this.isFreeTier, this.adminPassword, this.dbName, this.freeformTags, this.definedTags, this.securityAttributes, this.dbWorkload, this.licenseModel, this.byolComputeCountLimit, this.isAccessControlEnabled, this.whitelistedIps, this.arePrimaryWhitelistedIpsUsed, this.standbyWhitelistedIps, this.isAutoScalingEnabled, this.isRefreshableClone, this.refreshableMode, this.isLocalDataGuardEnabled, this.isDataGuardEnabled, this.peerDbId, this.dbVersion, this.openMode, this.permissionLevel, this.subnetId, this.privateEndpointLabel, this.privateEndpointIp, this.nsgIds, this.autoRefreshFrequencyInSeconds, this.autoRefreshPointLagInSeconds, this.timeOfAutoRefreshStart, this.customerContacts, this.isMtlsConnectionRequired, this.resourcePoolLeaderId, this.resourcePoolSummary, this.autonomousMaintenanceScheduleType, this.isBackupRetentionLocked, this.scheduledOperations, this.isAutoScalingForStorageEnabled, this.databaseEdition, this.dbToolsDetails, this.secretId, this.secretVersionNumber, this.encryptionKey, this.isDisconnectPeer);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateAutonomousDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("backupRetentionPeriodInDays")) {
                this.backupRetentionPeriodInDays(model.getBackupRetentionPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            if (model.wasPropertyExplicitlySet("inMemoryPercentage")) {
                this.inMemoryPercentage(model.getInMemoryPercentage());
            }
            if (model.wasPropertyExplicitlySet("localAdgAutoFailoverMaxDataLossLimit")) {
                this.localAdgAutoFailoverMaxDataLossLimit(model.getLocalAdgAutoFailoverMaxDataLossLimit());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("longTermBackupSchedule")) {
                this.longTermBackupSchedule(model.getLongTermBackupSchedule());
            }
            if (model.wasPropertyExplicitlySet("isDevTier")) {
                this.isDevTier(model.getIsDevTier());
            }
            if (model.wasPropertyExplicitlySet("computeCount")) {
                this.computeCount(model.getComputeCount());
            }
            if (model.wasPropertyExplicitlySet("ocpuCount")) {
                this.ocpuCount(model.getOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInTBs")) {
                this.dataStorageSizeInTBs(model.getDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInGBs")) {
                this.dataStorageSizeInGBs(model.getDataStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("isFreeTier")) {
                this.isFreeTier(model.getIsFreeTier());
            }
            if (model.wasPropertyExplicitlySet("adminPassword")) {
                this.adminPassword(model.getAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("dbName")) {
                this.dbName(model.getDbName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("securityAttributes")) {
                this.securityAttributes(model.getSecurityAttributes());
            }
            if (model.wasPropertyExplicitlySet("dbWorkload")) {
                this.dbWorkload(model.getDbWorkload());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("byolComputeCountLimit")) {
                this.byolComputeCountLimit(model.getByolComputeCountLimit());
            }
            if (model.wasPropertyExplicitlySet("isAccessControlEnabled")) {
                this.isAccessControlEnabled(model.getIsAccessControlEnabled());
            }
            if (model.wasPropertyExplicitlySet("whitelistedIps")) {
                this.whitelistedIps(model.getWhitelistedIps());
            }
            if (model.wasPropertyExplicitlySet("arePrimaryWhitelistedIpsUsed")) {
                this.arePrimaryWhitelistedIpsUsed(model.getArePrimaryWhitelistedIpsUsed());
            }
            if (model.wasPropertyExplicitlySet("standbyWhitelistedIps")) {
                this.standbyWhitelistedIps(model.getStandbyWhitelistedIps());
            }
            if (model.wasPropertyExplicitlySet("isAutoScalingEnabled")) {
                this.isAutoScalingEnabled(model.getIsAutoScalingEnabled());
            }
            if (model.wasPropertyExplicitlySet("isRefreshableClone")) {
                this.isRefreshableClone(model.getIsRefreshableClone());
            }
            if (model.wasPropertyExplicitlySet("refreshableMode")) {
                this.refreshableMode(model.getRefreshableMode());
            }
            if (model.wasPropertyExplicitlySet("isLocalDataGuardEnabled")) {
                this.isLocalDataGuardEnabled(model.getIsLocalDataGuardEnabled());
            }
            if (model.wasPropertyExplicitlySet("isDataGuardEnabled")) {
                this.isDataGuardEnabled(model.getIsDataGuardEnabled());
            }
            if (model.wasPropertyExplicitlySet("peerDbId")) {
                this.peerDbId(model.getPeerDbId());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("openMode")) {
                this.openMode(model.getOpenMode());
            }
            if (model.wasPropertyExplicitlySet("permissionLevel")) {
                this.permissionLevel(model.getPermissionLevel());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointLabel")) {
                this.privateEndpointLabel(model.getPrivateEndpointLabel());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointIp")) {
                this.privateEndpointIp(model.getPrivateEndpointIp());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("autoRefreshFrequencyInSeconds")) {
                this.autoRefreshFrequencyInSeconds(model.getAutoRefreshFrequencyInSeconds());
            }
            if (model.wasPropertyExplicitlySet("autoRefreshPointLagInSeconds")) {
                this.autoRefreshPointLagInSeconds(model.getAutoRefreshPointLagInSeconds());
            }
            if (model.wasPropertyExplicitlySet("timeOfAutoRefreshStart")) {
                this.timeOfAutoRefreshStart(model.getTimeOfAutoRefreshStart());
            }
            if (model.wasPropertyExplicitlySet("customerContacts")) {
                this.customerContacts(model.getCustomerContacts());
            }
            if (model.wasPropertyExplicitlySet("isMtlsConnectionRequired")) {
                this.isMtlsConnectionRequired(model.getIsMtlsConnectionRequired());
            }
            if (model.wasPropertyExplicitlySet("resourcePoolLeaderId")) {
                this.resourcePoolLeaderId(model.getResourcePoolLeaderId());
            }
            if (model.wasPropertyExplicitlySet("resourcePoolSummary")) {
                this.resourcePoolSummary(model.getResourcePoolSummary());
            }
            if (model.wasPropertyExplicitlySet("autonomousMaintenanceScheduleType")) {
                this.autonomousMaintenanceScheduleType(model.getAutonomousMaintenanceScheduleType());
            }
            if (model.wasPropertyExplicitlySet("isBackupRetentionLocked")) {
                this.isBackupRetentionLocked(model.getIsBackupRetentionLocked());
            }
            if (model.wasPropertyExplicitlySet("scheduledOperations")) {
                this.scheduledOperations(model.getScheduledOperations());
            }
            if (model.wasPropertyExplicitlySet("isAutoScalingForStorageEnabled")) {
                this.isAutoScalingForStorageEnabled(model.getIsAutoScalingForStorageEnabled());
            }
            if (model.wasPropertyExplicitlySet("databaseEdition")) {
                this.databaseEdition(model.getDatabaseEdition());
            }
            if (model.wasPropertyExplicitlySet("dbToolsDetails")) {
                this.dbToolsDetails(model.getDbToolsDetails());
            }
            if (model.wasPropertyExplicitlySet("secretId")) {
                this.secretId(model.getSecretId());
            }
            if (model.wasPropertyExplicitlySet("secretVersionNumber")) {
                this.secretVersionNumber(model.getSecretVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("encryptionKey")) {
                this.encryptionKey(model.getEncryptionKey());
            }
            if (model.wasPropertyExplicitlySet("isDisconnectPeer")) {
                this.isDisconnectPeer(model.getIsDisconnectPeer());
            }
            return this;
        }
    }
}

