/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SystemVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="giVersion")
    private final String giVersion;
    @JsonProperty(value="systemVersions")
    private final List<String> systemVersions;

    @Deprecated
    @ConstructorProperties(value={"shape", "giVersion", "systemVersions"})
    public SystemVersionSummary(String shape, String giVersion, List<String> systemVersions) {
        this.shape = shape;
        this.giVersion = giVersion;
        this.systemVersions = systemVersions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getShape() {
        return this.shape;
    }

    public String getGiVersion() {
        return this.giVersion;
    }

    public List<String> getSystemVersions() {
        return this.systemVersions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SystemVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("shape=").append(String.valueOf(this.shape));
        sb.append(", giVersion=").append(String.valueOf(this.giVersion));
        sb.append(", systemVersions=").append(String.valueOf(this.systemVersions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemVersionSummary)) {
            return false;
        }
        SystemVersionSummary other = (SystemVersionSummary)((Object)o);
        return Objects.equals(this.shape, other.shape) && Objects.equals(this.giVersion, other.giVersion) && Objects.equals(this.systemVersions, other.systemVersions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.giVersion == null ? 43 : this.giVersion.hashCode());
        result = result * 59 + (this.systemVersions == null ? 43 : this.systemVersions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="giVersion")
        private String giVersion;
        @JsonProperty(value="systemVersions")
        private List<String> systemVersions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            this.__explicitlySet__.add("giVersion");
            return this;
        }

        public Builder systemVersions(List<String> systemVersions) {
            this.systemVersions = systemVersions;
            this.__explicitlySet__.add("systemVersions");
            return this;
        }

        public SystemVersionSummary build() {
            SystemVersionSummary model = new SystemVersionSummary(this.shape, this.giVersion, this.systemVersions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SystemVersionSummary model) {
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("giVersion")) {
                this.giVersion(model.getGiVersion());
            }
            if (model.wasPropertyExplicitlySet("systemVersions")) {
                this.systemVersions(model.getSystemVersions());
            }
            return this;
        }
    }
}

