/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseCredentialDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EnableDatabaseManagementDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="credentialDetails")
    private final DatabaseCredentialDetails credentialDetails;
    @JsonProperty(value="privateEndPointId")
    private final String privateEndPointId;
    @JsonProperty(value="managementType")
    private final ManagementType managementType;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="sslSecretId")
    private final String sslSecretId;
    @JsonProperty(value="role")
    private final Role role;

    @Deprecated
    @ConstructorProperties(value={"credentialDetails", "privateEndPointId", "managementType", "serviceName", "protocol", "port", "sslSecretId", "role"})
    public EnableDatabaseManagementDetails(DatabaseCredentialDetails credentialDetails, String privateEndPointId, ManagementType managementType, String serviceName, Protocol protocol, Integer port, String sslSecretId, Role role) {
        this.credentialDetails = credentialDetails;
        this.privateEndPointId = privateEndPointId;
        this.managementType = managementType;
        this.serviceName = serviceName;
        this.protocol = protocol;
        this.port = port;
        this.sslSecretId = sslSecretId;
        this.role = role;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DatabaseCredentialDetails getCredentialDetails() {
        return this.credentialDetails;
    }

    public String getPrivateEndPointId() {
        return this.privateEndPointId;
    }

    public ManagementType getManagementType() {
        return this.managementType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getSslSecretId() {
        return this.sslSecretId;
    }

    public Role getRole() {
        return this.role;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EnableDatabaseManagementDetails(");
        sb.append("super=").append(super.toString());
        sb.append("credentialDetails=").append(String.valueOf((Object)this.credentialDetails));
        sb.append(", privateEndPointId=").append(String.valueOf(this.privateEndPointId));
        sb.append(", managementType=").append(String.valueOf((Object)this.managementType));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", sslSecretId=").append(String.valueOf(this.sslSecretId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnableDatabaseManagementDetails)) {
            return false;
        }
        EnableDatabaseManagementDetails other = (EnableDatabaseManagementDetails)((Object)o);
        return Objects.equals((Object)this.credentialDetails, (Object)other.credentialDetails) && Objects.equals(this.privateEndPointId, other.privateEndPointId) && Objects.equals((Object)this.managementType, (Object)other.managementType) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.port, other.port) && Objects.equals(this.sslSecretId, other.sslSecretId) && Objects.equals((Object)this.role, (Object)other.role) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.credentialDetails == null ? 43 : this.credentialDetails.hashCode());
        result = result * 59 + (this.privateEndPointId == null ? 43 : this.privateEndPointId.hashCode());
        result = result * 59 + (this.managementType == null ? 43 : this.managementType.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.sslSecretId == null ? 43 : this.sslSecretId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ManagementType implements BmcEnum
    {
        Basic("BASIC"),
        Advanced("ADVANCED");

        private final String value;
        private static Map<String, ManagementType> map;

        private ManagementType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagementType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ManagementType: " + key);
        }

        static {
            map = new HashMap<String, ManagementType>();
            for (ManagementType v : ManagementType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Protocol implements BmcEnum
    {
        Tcp("TCP"),
        Tcps("TCPS");

        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Protocol: " + key);
        }

        static {
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Role implements BmcEnum
    {
        Sysdba("SYSDBA"),
        Normal("NORMAL"),
        Sysdg("SYSDG");

        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Role: " + key);
        }

        static {
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialDetails")
        private DatabaseCredentialDetails credentialDetails;
        @JsonProperty(value="privateEndPointId")
        private String privateEndPointId;
        @JsonProperty(value="managementType")
        private ManagementType managementType;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="sslSecretId")
        private String sslSecretId;
        @JsonProperty(value="role")
        private Role role;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialDetails(DatabaseCredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            this.__explicitlySet__.add("credentialDetails");
            return this;
        }

        public Builder privateEndPointId(String privateEndPointId) {
            this.privateEndPointId = privateEndPointId;
            this.__explicitlySet__.add("privateEndPointId");
            return this;
        }

        public Builder managementType(ManagementType managementType) {
            this.managementType = managementType;
            this.__explicitlySet__.add("managementType");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder sslSecretId(String sslSecretId) {
            this.sslSecretId = sslSecretId;
            this.__explicitlySet__.add("sslSecretId");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public EnableDatabaseManagementDetails build() {
            EnableDatabaseManagementDetails model = new EnableDatabaseManagementDetails(this.credentialDetails, this.privateEndPointId, this.managementType, this.serviceName, this.protocol, this.port, this.sslSecretId, this.role);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EnableDatabaseManagementDetails model) {
            if (model.wasPropertyExplicitlySet("credentialDetails")) {
                this.credentialDetails(model.getCredentialDetails());
            }
            if (model.wasPropertyExplicitlySet("privateEndPointId")) {
                this.privateEndPointId(model.getPrivateEndPointId());
            }
            if (model.wasPropertyExplicitlySet("managementType")) {
                this.managementType(model.getManagementType());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("sslSecretId")) {
                this.sslSecretId(model.getSslSecretId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            return this;
        }
    }
}

