/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DefinedFileSystemConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="mountPoint")
    private final String mountPoint;
    @JsonProperty(value="minSizeGb")
    private final Integer minSizeGb;
    @JsonProperty(value="isResizable")
    private final Boolean isResizable;
    @JsonProperty(value="isBackupPartition")
    private final Boolean isBackupPartition;

    @Deprecated
    @ConstructorProperties(value={"mountPoint", "minSizeGb", "isResizable", "isBackupPartition"})
    public DefinedFileSystemConfiguration(String mountPoint, Integer minSizeGb, Boolean isResizable, Boolean isBackupPartition) {
        this.mountPoint = mountPoint;
        this.minSizeGb = minSizeGb;
        this.isResizable = isResizable;
        this.isBackupPartition = isBackupPartition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public Integer getMinSizeGb() {
        return this.minSizeGb;
    }

    public Boolean getIsResizable() {
        return this.isResizable;
    }

    public Boolean getIsBackupPartition() {
        return this.isBackupPartition;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DefinedFileSystemConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("mountPoint=").append(String.valueOf(this.mountPoint));
        sb.append(", minSizeGb=").append(String.valueOf(this.minSizeGb));
        sb.append(", isResizable=").append(String.valueOf(this.isResizable));
        sb.append(", isBackupPartition=").append(String.valueOf(this.isBackupPartition));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefinedFileSystemConfiguration)) {
            return false;
        }
        DefinedFileSystemConfiguration other = (DefinedFileSystemConfiguration)((Object)o);
        return Objects.equals(this.mountPoint, other.mountPoint) && Objects.equals(this.minSizeGb, other.minSizeGb) && Objects.equals(this.isResizable, other.isResizable) && Objects.equals(this.isBackupPartition, other.isBackupPartition) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mountPoint == null ? 43 : this.mountPoint.hashCode());
        result = result * 59 + (this.minSizeGb == null ? 43 : this.minSizeGb.hashCode());
        result = result * 59 + (this.isResizable == null ? 43 : this.isResizable.hashCode());
        result = result * 59 + (this.isBackupPartition == null ? 43 : this.isBackupPartition.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mountPoint")
        private String mountPoint;
        @JsonProperty(value="minSizeGb")
        private Integer minSizeGb;
        @JsonProperty(value="isResizable")
        private Boolean isResizable;
        @JsonProperty(value="isBackupPartition")
        private Boolean isBackupPartition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            this.__explicitlySet__.add("mountPoint");
            return this;
        }

        public Builder minSizeGb(Integer minSizeGb) {
            this.minSizeGb = minSizeGb;
            this.__explicitlySet__.add("minSizeGb");
            return this;
        }

        public Builder isResizable(Boolean isResizable) {
            this.isResizable = isResizable;
            this.__explicitlySet__.add("isResizable");
            return this;
        }

        public Builder isBackupPartition(Boolean isBackupPartition) {
            this.isBackupPartition = isBackupPartition;
            this.__explicitlySet__.add("isBackupPartition");
            return this;
        }

        public DefinedFileSystemConfiguration build() {
            DefinedFileSystemConfiguration model = new DefinedFileSystemConfiguration(this.mountPoint, this.minSizeGb, this.isResizable, this.isBackupPartition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DefinedFileSystemConfiguration model) {
            if (model.wasPropertyExplicitlySet("mountPoint")) {
                this.mountPoint(model.getMountPoint());
            }
            if (model.wasPropertyExplicitlySet("minSizeGb")) {
                this.minSizeGb(model.getMinSizeGb());
            }
            if (model.wasPropertyExplicitlySet("isResizable")) {
                this.isResizable(model.getIsResizable());
            }
            if (model.wasPropertyExplicitlySet("isBackupPartition")) {
                this.isBackupPartition(model.getIsBackupPartition());
            }
            return this;
        }
    }
}

