/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.util.Stack;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.ext.LexicalHandler;

public class XTIDecoder
implements XTIConstants {
    XMLError err = null;
    XTIStream xtiStream = null;
    byte[] currentPage = null;
    int currentPageNumber = 0;
    SAXAttrList attrlist = new SAXAttrList(100);
    private Stack<DecodeElem> elements = new Stack();
    LexicalHandler lexHdlr = null;

    XTIDecoder(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
        this.xtiStream.setXMLError(xMLError);
    }

    XMLError getXMLError() {
        if (this.err == null) {
            this.err = new XMLError();
        }
        return this.err;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexHdlr = lexicalHandler;
    }

    public void decode(ContentHandler contentHandler, ErrorHandler errorHandler) throws XTIException {
        try {
            int n = this.readHeader();
            int n2 = 0;
            DecodeElem decodeElem = null;
            byte by = 0;
            do {
                by = this.decodeNodes(n, contentHandler, errorHandler);
                n2 = n;
                n = this.getChildAddress(n);
                if (by == 1 && n == 0 && !this.elements.empty()) {
                    decodeElem = this.elements.pop();
                    contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
                }
                while (n == 0 && n2 != 0) {
                    n = this.getNextAddress(n2);
                    if (n != 0) continue;
                    n2 = this.getParentAddress(n2);
                    if (this.elements.empty()) continue;
                    decodeElem = this.elements.pop();
                    contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
                }
            } while (n != 0);
            while (!this.elements.empty()) {
                decodeElem = this.elements.pop();
                contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
            }
            contentHandler.endDocument();
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    boolean isLastChild(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = this.currentPage[n2];
        return (by & 0x10) > 0;
    }

    int readHeader() {
        byte[] byArray = this.xtiStream.readXTINPage(0, false);
        byte by = (byte)(byArray[0] & 0xF);
        byte by2 = (byte)(by & 9);
        if ((by & 9) > 0) {
            this.xtiStream.setInterleaving(true);
        }
        int n = XTIUtil.byteArrayToInt(byArray, 8);
        int n2 = XTIUtil.byteArrayToInt(byArray, 4);
        this.xtiStream.setTotalXTINPages(n2);
        this.xtiStream.readXTICPage(0, false);
        return n;
    }

    int getChildAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n2 + 12);
    }

    int getNextAddress(int n) {
        this.getXTINPageFromAddress(n);
        if (this.isLastChild(n)) {
            return 0;
        }
        int n2 = (n & 0xFF) * 32;
        int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 24);
        return n3;
    }

    int getPreviousAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 16);
        if (this.isLastChild(n3)) {
            return 0;
        }
        return n3;
    }

    int getParentAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n2 + 20);
    }

    int getAttributeAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n2 + 28);
    }

    String getPrefix(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        long l = XTIUtil.byteArrayToLong(this.currentPage, n2 + 4);
        QxName qxName = this.getQxName(l);
        return qxName.getPrefix();
    }

    String getLocalName(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        long l = XTIUtil.byteArrayToLong(this.currentPage, n2 + 4);
        QxName qxName = this.getQxName(l);
        return qxName.getLocalPart();
    }

    String getQName(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        String string = null;
        switch (by) {
            case 1: 
            case 2: {
                long l = XTIUtil.byteArrayToLong(this.currentPage, n2 + 4);
                QxName qxName = this.getQxName(l);
                string = qxName.getQName();
                break;
            }
            case 7: {
                int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n3);
                n2 = n3 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n2);
            }
        }
        return string;
    }

    String getXMLEncoding() {
        byte[] byArray = this.xtiStream.getXTINPageNumber(0, false);
        byte by = byArray[17];
        if ((by & 2) == 0) {
            return "UTF-8";
        }
        int n = XTIUtil.byteArrayToInt(byArray, 13);
        byte[] byArray2 = this.getXTICPageFromAddress(n);
        int n2 = n & 0xFFF;
        String string = XTIUtil.getStringFromArray(byArray2, n2);
        return string;
    }

    String getXmlVersion() {
        return "1.0";
    }

    boolean getStandalone() {
        byte[] byArray = this.xtiStream.getXTINPageNumber(0, false);
        byte by = byArray[17];
        return (by & 8) == 8;
    }

    String getNamespaceURI(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        long l = XTIUtil.byteArrayToLong(this.currentPage, n2 + 4);
        QxName qxName = this.getQxName(l);
        return qxName.getNamespaceURI();
    }

    String getNodeValue(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        String string = null;
        switch (by) {
            case 3: 
            case 4: 
            case 8: {
                int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n3);
                int n4 = n3 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n4);
                break;
            }
            case 7: {
                int n5 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 4);
                byte[] byArray = this.getXTICPageFromAddress(n5);
                int n6 = n5 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n6);
                break;
            }
            case 2: {
                int n7 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 4 + 12);
                byte[] byArray = this.getXTICPageFromAddress(n7);
                int n8 = n7 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n8);
                break;
            }
            default: {
                return null;
            }
        }
        return string;
    }

    byte getNodeType(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        return by;
    }

    public boolean isNamespaceNode(int n) {
        byte by = this.getNodeType(n);
        if (by == 2) {
            this.getXTINPageFromAddress(n);
            int n2 = n & 0xFF;
            n2 = 32 * n2;
            byte by2 = this.currentPage[n2 + 29];
            if (by2 == 2 || by2 == 4) {
                return true;
            }
        }
        return false;
    }

    private byte decodeNodes(int n, ContentHandler contentHandler, ErrorHandler errorHandler) throws Exception {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        switch (by) {
            case 9: {
                contentHandler.startDocument();
                break;
            }
            case 1: {
                long l = XTIUtil.byteArrayToLong(this.currentPage, n2 + 4);
                QxName qxName = this.getQxName(l);
                String string = qxName.getPrefix();
                String string2 = qxName.getLocalPart();
                String string3 = qxName.getNamespaceURI();
                int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 28);
                this.decodeAttributes(n3);
                this.elements.push(new DecodeElem(string3, string, string2));
                contentHandler.startElement(string3, string2, qxName.getQName(), this.attrlist);
                this.attrlist.reset();
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                String string = this.getNodeValue(n);
                if (by == 3) {
                    contentHandler.characters(string.toCharArray(), 0, string.length());
                    break;
                }
                if (by == 8) {
                    this.lexHdlr.comment(string.toCharArray(), 0, string.length());
                    break;
                }
                if (by != 4) break;
                this.lexHdlr.startCDATA();
                contentHandler.characters(string.toCharArray(), 0, string.length());
                this.lexHdlr.endCDATA();
                break;
            }
            case 7: {
                String string = this.getNodeValue(n);
                int n4 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n4);
                int n5 = n4 & 0xFFF;
                String string4 = XTIUtil.getStringFromArray(byArray, n5);
                contentHandler.processingInstruction(string4, string);
                break;
            }
            default: {
                if (this.err == null) {
                    this.err = this.getXMLError();
                }
                this.err.error0(36005, 1);
                throw new XTIException(this.err.getMessage0(36005));
            }
        }
        return by;
    }

    private void decodeAttributes(int n) {
        if (n == 0) {
            return;
        }
        int n2 = 0;
        long l = 0L;
        while (n != 0) {
            this.getXTINPageFromAddress(n);
            n2 = n & 0xFF;
            n2 = 32 * n2;
            l = XTIUtil.byteArrayToLong(this.currentPage, n2 + 4);
            QxName qxName = this.getQxName(l);
            String string = this.getNodeValue(n);
            this.attrlist.addAttr(qxName.getPrefix(), qxName.getLocalPart(), qxName.getQName(), string, true, 0, qxName.getNamespaceURI());
            n = XTIUtil.byteArrayToInt(this.currentPage, n2 + 24);
        }
    }

    public QxName getQxName(long l) throws XTIException {
        if (l == 0L) {
            if (this.err == null) {
                this.err = this.getXMLError();
            }
            this.err.error0(36005, 1);
            throw new XTIException(this.err.getMessage0(36005));
        }
        QxName qxName = this.xtiStream.qnameCache.get(l);
        if (qxName == null) {
            int n = (int)(l >> 32);
            int n2 = (int)l;
            byte[] byArray = this.getXTICPageFromAddress(n2);
            int n3 = n2 & 0xFFF;
            int n4 = byArray[--n3];
            String string = "";
            String string2 = null;
            int n5 = 0;
            if (n4 != 0) {
                string = new String(byArray, n3 + 1, --n4);
                n5 = n3 + n4 + 2;
            } else {
                n5 = n3 + 1;
            }
            string2 = XTIUtil.getQNameFromArray(byArray, n5);
            byArray = this.getXTICPageFromAddress(n);
            n5 = n3 = n & 0xFFF;
            String string3 = XTIUtil.getQNameFromArray(byArray, n3);
            qxName = QxNameHash.create(string3, string2, string);
            this.xtiStream.qnameCache.put(l, qxName);
        }
        return qxName;
    }

    private void getXTINPageFromAddress(int n) {
        int n2 = (n &= Integer.MAX_VALUE) >> 8;
        if (n2 != this.currentPageNumber || this.currentPageNumber == 0 && this.currentPage == null) {
            this.currentPageNumber = n2;
            this.currentPage = this.xtiStream.readXTINPage(n >> 8, false);
        }
    }

    private byte[] getXTICPageFromAddress(int n) {
        return this.xtiStream.readXTICPage(n >> 12, false);
    }

    class DecodeElem
    implements XTIConstants {
        String uri = null;
        String prefix = null;
        String localname = null;

        DecodeElem(String string, String string2, String string3) {
            this.uri = string;
            this.prefix = string2;
            this.localname = string3;
        }

        String getURI() {
            return this.uri;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getLocalname() {
            return this.localname;
        }

        String getQname() {
            if (this.prefix == null || this.prefix.equals("")) {
                return this.localname;
            }
            return this.prefix + ":" + this.localname;
        }
    }
}

