/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.aq;

import java.sql.Connection;
import java.util.Optional;
import java.util.logging.Logger;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.sqlcl.commands.aq.AQMessages;
import oracle.dbtools.sqlcl.commands.aq.AQModel;
import oracle.dbtools.sqlcl.commands.aq.AQOptions;
import oracle.dbtools.sqlcl.commands.aq.AQProcessor;

public class AQCommand
extends CommandListener
implements IHelp,
SQLCLService {
    protected static final Logger LOGGER = Logger.getLogger(AQCommand.class.getName());

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("aqcommand - begin");
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("aqcommand - end");
    }

    public String getCommand() {
        return "aq";
    }

    public Type getParserType() {
        return AQOptions.getCommandType();
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, AQOptions.getCommandType()).get(pagePath);
    }

    public boolean isSqlPlus() {
        return false;
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return AQMessages.getString("AQCMDEXTENSIONDESCRIPTION").trim();
    }

    public String getExtensionName() {
        String name = "Advanced Queuing";
        return "Advanced Queuing";
    }

    public String getExtensionVersion() {
        return AQMessages.getString("AQCMDVERSION");
    }

    public boolean handleEvent(Connection sqlConn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedSQL().startsWith("aq")) {
            return false;
        }
        try {
            Parser parser = new Parser(AQOptions.getCommandType(), ctx.getEnvironment());
            Optional optParsedCommand = parser.parse(cmd.getSql(), error -> ctx.write(error + "\n"));
            if (!optParsedCommand.isPresent()) {
                return true;
            }
            ParsedCommand parsedCommand = (ParsedCommand)optParsedCommand.get();
            Id _command = parsedCommand.getType().getId();
            AQModel model = new AQModel(sqlConn, ctx, parsedCommand);
            if (_command == AQOptions.Symbol.CREATE_QUEUE_TABLE) {
                AQProcessor.createQueueTable(model);
            } else if (_command == AQOptions.Symbol.ALTER_QUEUE_TABLE) {
                AQProcessor.alterQueueTable(model);
            } else if (_command == AQOptions.Symbol.DROP_QUEUE_TABLE) {
                AQProcessor.dropQueueTable(model);
            } else if (_command == AQOptions.Symbol.CREATE_QUEUE) {
                AQProcessor.createQueue(model);
            } else if (_command == AQOptions.Symbol.ALTER_QUEUE) {
                AQProcessor.alterQueue(model);
            } else if (_command == AQOptions.Symbol.DROP_QUEUE) {
                AQProcessor.dropQueue(model);
            } else if (_command == AQOptions.Symbol.CREATE_SHARDED_QUEUE) {
                AQProcessor.createShardedQueue(model);
            } else if (_command == AQOptions.Symbol.CREATE_EXCEPTION_QUEUE) {
                AQProcessor.createExceptionQueue(model);
            } else if (_command == AQOptions.Symbol.ALTER_SHARDED_QUEUE) {
                AQProcessor.alterShardedQueue(model);
            } else if (_command == AQOptions.Symbol.DROP_SHARDED_QUEUE) {
                AQProcessor.dropShardedQueue(model);
            } else if (_command == AQOptions.Symbol.START_QUEUE) {
                AQProcessor.startQueue(model);
            } else if (_command == AQOptions.Symbol.STOP_QUEUE) {
                AQProcessor.stopQueue(model);
            } else if (_command == AQOptions.Symbol.ADD_SUBSCRIBER) {
                AQProcessor.addSubscriber(model);
            } else if (_command == AQOptions.Symbol.ALTER_SUBSCRIBER) {
                AQProcessor.alterSubscriber(model);
            } else if (_command == AQOptions.Symbol.REMOVE_SUBSCRIBER) {
                AQProcessor.removeSubscriber(model);
            } else if (_command == AQOptions.Symbol.CREATE_TRANSACTIONAL_EVENT_QUEUE) {
                AQProcessor.createTransactionalEventQueue(model);
            } else if (_command == AQOptions.Symbol.ALTER_TRANSACTIONAL_EVENT_QUEUE) {
                AQProcessor.alterTransactionalEventQueue(model);
            } else if (_command == AQOptions.Symbol.DROP_TRANSACTIONAL_EVENT_QUEUE) {
                AQProcessor.dropTransactionalEventQueue(model);
            } else if (_command == AQOptions.Symbol.CREATE_EQ_EXCEPTION_QUEUE) {
                AQProcessor.createEQExceptionQueue(model);
            } else if (_command == AQOptions.Symbol.ENQUE) {
                AQProcessor.enqueue(model);
            } else if (_command == AQOptions.Symbol.DEQUE) {
                AQProcessor.dequeue(model);
            }
            ctx.write("\n" + String.format(Messages.getString((String)"AQEXP.SUCCESS_COMMAND"), _command.getName()) + "\n");
        }
        catch (Exception e) {
            ctx.writeln(e.getMessage());
        }
        return true;
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        HelpPages helpPages = new HelpPagesBuilder(ctx.getEnvironment()).lineSize(lineSize).enableColorCode(ctx.isCommandLine()).alphaSort().addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
        return helpPages;
    }
}

