/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;

@Deprecated
public class LazyNode
extends ParseNode {
    public String startToken;
    List<LexerToken> src;
    public boolean isWellFormed = true;
    private ParseNode branch = null;

    public LazyNode(int begin, String start, List<LexerToken> src) {
        super(begin, -1, -1, -1, null);
        this.startToken = start;
        this.src = src;
    }

    public ParseNode getBranch() {
        return this.branch;
    }

    @Override
    public SortedSet<ParseNode> children() {
        if (this.branch == null) {
            return super.children();
        }
        TreeSet<ParseNode> ret = new TreeSet<ParseNode>();
        ret.addAll(super.children());
        ret.add(this.branch);
        return ret;
    }

    @Override
    public ParseNode childAt(int head, int tail) {
        if (this.branch == null) {
            return super.childAt(head, tail);
        }
        return this.branch.childAt(head, tail);
    }

    public List<LazyNode> shallowChildren() {
        ArrayList<LazyNode> ret = new ArrayList<LazyNode>();
        for (ParseNode child : super.children()) {
            if (!(child instanceof LazyNode)) continue;
            ret.add((LazyNode)child);
        }
        return ret;
    }

    public List<LazyNode> shallowDescendants() {
        ArrayList<LazyNode> ret = new ArrayList<LazyNode>();
        ret.add(this);
        for (ParseNode parseNode : this.shallowChildren()) {
            ret.addAll(((LazyNode)parseNode).shallowDescendants());
        }
        return ret;
    }

    public List<LazyNode> shallowIntermediates(int head, int tail) {
        ArrayList<LazyNode> ret = new ArrayList<LazyNode>();
        if (this.from <= head && tail <= this.to) {
            ret.add(this);
        }
        for (LazyNode n : this.shallowChildren()) {
            if (n.from > head || tail > n.to) continue;
            ret.addAll(n.shallowIntermediates(head, tail));
        }
        return ret;
    }

    public LazyNode shallowParent(int head, int tail) {
        for (LazyNode descendant : this.shallowIntermediates(head, tail)) {
            for (LazyNode child : descendant.shallowChildren()) {
                if (child.from != head || child.to != tail) continue;
                return descendant;
            }
        }
        return null;
    }

    public LazyNode shallowLeaf(int head, int tail) {
        for (LazyNode descendant : this.shallowIntermediates(head, tail)) {
            if (descendant.shallowChildren().size() != 0 || descendant.from > head || tail > descendant.to) continue;
            return descendant;
        }
        return null;
    }

    public LazyNode ancestor(int head, int tail) {
        List<LazyNode> candidates = this.shallowChildren();
        if (candidates.size() == 0) {
            return this;
        }
        for (LazyNode child : candidates) {
            if (child.from > head || tail > child.to) continue;
            return child.ancestor(head, tail);
        }
        return this;
    }

    @Override
    public boolean isAuxiliary() {
        return false;
    }

    protected String toString(int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append("[" + this.from + "," + this.to + ") ");
        sb.append("  " + this.startToken);
        if (!this.isWellFormed) {
            sb.append("  *** incomplete!");
        }
        return sb.toString();
    }

    public boolean isAs() {
        return "is".equalsIgnoreCase(this.startToken) || "as".equalsIgnoreCase(this.startToken) || "before".equalsIgnoreCase(this.startToken) || "after".equalsIgnoreCase(this.startToken) || "of".equalsIgnoreCase(this.startToken);
    }

    public boolean isCompilationUnit() {
        return "package".equalsIgnoreCase(this.startToken) || "trigger".equalsIgnoreCase(this.startToken) || this.isProcedure();
    }

    public boolean isProcedure() {
        return "function".equalsIgnoreCase(this.startToken) || "procedure".equalsIgnoreCase(this.startToken);
    }

    public boolean isDML() {
        return this.isDML(null);
    }

    public boolean isDML(String next) {
        return !"(".equals(next) && !";".equals(next) && ("insert".equalsIgnoreCase(this.startToken) || "update".equalsIgnoreCase(this.startToken) || "delete".equalsIgnoreCase(this.startToken) || "select".equalsIgnoreCase(this.startToken) || "with".equalsIgnoreCase(this.startToken) && !"context".equalsIgnoreCase(next) || "cursor".equalsIgnoreCase(this.startToken) && !"is".equalsIgnoreCase(next) && !"as".equalsIgnoreCase(next) || "merge".equalsIgnoreCase(this.startToken) || "fetch".equalsIgnoreCase(this.startToken));
    }

    public boolean isDDL(String next) {
        return "alter".equalsIgnoreCase(this.startToken) || "create".equalsIgnoreCase(this.startToken) || "grant".equalsIgnoreCase(this.startToken) || "drop".equalsIgnoreCase(this.startToken) || "comment".equalsIgnoreCase(this.startToken) || "administer".equalsIgnoreCase(this.startToken) && "key".equalsIgnoreCase(next);
    }

    boolean isControlStmt(LazyNode root) {
        String parentStartToken = "N/A";
        LazyNode parent = root.shallowParent(this.from, this.to);
        if (parent != null) {
            parentStartToken = parent.startToken;
        }
        return "if".equalsIgnoreCase(this.startToken) || "case".equalsIgnoreCase(this.startToken) || "for".equalsIgnoreCase(this.startToken) || "while".equalsIgnoreCase(this.startToken) || "loop".equalsIgnoreCase(this.startToken) && !"for".equalsIgnoreCase(parentStartToken) && !"while".equalsIgnoreCase(parentStartToken);
    }

    public boolean isBlock(LazyNode root) {
        if ("declare".equalsIgnoreCase(this.startToken)) {
            return true;
        }
        if ("begin".equalsIgnoreCase(this.startToken) || "exception".equalsIgnoreCase(this.startToken)) {
            if (root == null) {
                return true;
            }
            LazyNode parent = root.shallowParent(this.from, this.to);
            if (parent == null) {
                return true;
            }
            if (!"declare".equalsIgnoreCase(parent.startToken) && !parent.isProcedure()) {
                return true;
            }
        }
        return false;
    }

    public boolean isStmt(LazyNode root) {
        return this.isBlock(root) || this.isControlStmt(root) || this.isDML(null) || this.isDDL(null);
    }

    public void expandInterruptably() throws InterruptedException {
        this.expand(true);
    }

    public void expand() {
        try {
            this.expand(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void expand(boolean interrupt) throws InterruptedException {
        if (this.branch != null) {
            return;
        }
        ArrayList<LexerToken> fragment = new ArrayList<LexerToken>();
        int k = -1;
        for (LexerToken tok : this.src) {
            ++k;
            if (interrupt && Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.from > k || k >= this.to) continue;
            fragment.add(tok);
        }
        SqlEarley earley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(earley);
        earley.parse(fragment, matrix);
        this.branch = earley.forest(fragment, matrix);
        this.branch.moveInterval(this.from);
    }

    public List<LexerToken> getSrcFragment() {
        ArrayList<LexerToken> fragment = new ArrayList<LexerToken>();
        int k = -1;
        int offset = 0;
        for (LexerToken tok : this.src) {
            if (this.to <= ++k) break;
            if (this.from == k) {
                offset = tok.begin;
            }
            if (this.from > k) continue;
            fragment.add(new LexerToken(tok.content, tok.begin - offset, tok.end - offset, tok.type));
        }
        return fragment;
    }

    @Override
    public void addContent(String symbol) {
        this.startToken = symbol;
    }
}

