/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.mysql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.mysql.MysqlRules;
import oracle.dbtools.parser.plsql.SyntaxError;

public class MysqlEarley
extends Earley {
    public static boolean visualize = false;
    int tableSourceItem = this.getSymbol("tableSourceItem");
    public String[] keywords = new String[]{"'WITH'", "'SELECT'", "'FROM'", "'WHERE'", "'AND'", "'OR'", "'NOT'", "'DISTINCT'", "'UNION'", "'ALL'", "'INNER'", "'LEFT'", "'FULL'", "'ON'", "'INSERT'", "'UPDATE'", "'CREATE'", "'ALTER'", "'TABLE'", "'VALUES'", "'CASE'", "'WHEN'", "'AS'", "'BEGIN'", "'END'", "'IN'"};
    private Set<Integer> _keywords = new TreeSet<Integer>();
    public static final String frequenciesFN = "frequencies.txt";
    public static final String path = "/oracle/dbtools/parser/mysql/";
    private static Map<Long, Integer> frequencies = null;

    public MysqlEarley() throws IOException {
        super(MysqlRules.getRules());
        this.initKeywords();
    }

    void initKeywords() {
        for (String k : this.keywords) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    @Override
    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        if (suspect != null && this._keywords.contains(suspect)) {
            return false;
        }
        return super.isIdentifier(y, src, symbol, suspect);
    }

    @Override
    protected boolean isOptimizable(int headSym, int preSym, int mid, int y) {
        if (headSym == this.tableSourceItem) {
            return false;
        }
        return super.isOptimizable(headSym, preSym, mid, y);
    }

    public static void main(String[] args) throws Exception {
        Parser.EarleyCell top;
        visualize = true;
        String input = Service.readFile("/Users/VTROPASH/eclipse-workspace/sandbox/src/example.sql");
        MysqlEarley earley = new MysqlEarley();
        boolean T = true;
        boolean F = false;
        earley.printOrderedRules("separator", false, false);
        List<LexerToken> src = Lexer.parse(input, false, 307);
        if (src.size() < 100) {
            LexerToken.print(src);
        }
        Matrix matrix = new Matrix(earley);
        if (visualize && src.size() < 1000) {
            matrix.visual = new Visual(src, earley);
        }
        matrix.visual = null;
        earley.parse(src, matrix);
        if (matrix.visual != null) {
            matrix.visual.draw(matrix);
        }
        if ((top = matrix.get(0, src.size())) != null) {
            System.out.println(src.size() + " tokens, top = " + ((Object)top).toString());
        } else {
            System.out.println((Object)SyntaxError.checkSyntax(input, new String[]{"sqlStatements"}, src, earley, matrix));
        }
        ParseNode root = earley.forest(src, matrix, true, input);
        if (src.size() < 1000) {
            root.printTree();
        } else {
            root.printTree(10);
        }
    }

    public static Map<Long, Integer> getFrequencies() {
        if (frequencies == null) {
            frequencies = new HashMap<Long, Integer>();
            URL u = MysqlEarley.class.getResource("/oracle/dbtools/parser/mysql/frequencies.txt");
            try {
                if (u == null) {
                    u = Service.fileNameGitResource(MysqlEarley.class, "/oracle/dbtools/parser/mysql/frequencies.txt");
                }
                InputStream is = u.openStream();
                StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    token = token.trim();
                    int pos = token.indexOf(61);
                    String head = token.substring(0, pos);
                    String tail = token.substring(pos + 1);
                    frequencies.put(Long.decode(head), Integer.decode(tail));
                }
                is.close();
            }
            catch (Exception e) {
                System.err.println("Failed to read frequencies: " + e.getMessage());
            }
        }
        return frequencies;
    }
}

