/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;

public class RecognizedRule
extends RuleTuple {
    public int X = -1;
    public int Y = -1;
    public long weight = 0L;
    public int pos;

    public RecognizedRule(String head, String[] rhs, int pos, int x, int y, int factor) {
        super(head, (String[])null);
        this.pos = pos;
        int len = rhs.length;
        if (pos + 2 <= len) {
            len = pos + 2;
            this.rhs = new String[len];
            for (int i = 0; i < pos + 1; ++i) {
                this.rhs[i] = rhs[i];
            }
            this.rhs[pos + 1] = "...";
        } else {
            this.rhs = rhs;
        }
        this.X = x;
        this.Y = y;
        this.weight = 1 * factor;
        try {
            int h = (Integer)SqlEarley.getInstance().symbolIndexes.get(head);
            int s = (Integer)SqlEarley.getInstance().symbolIndexes.get(rhs[pos]);
            Integer w = HarvestDoc.getFrequencies().get(Service.lPair(s, h));
            if (w != null) {
                this.weight += (long)(w * factor);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public RecognizedRule(RecognizedRule src, int at, int[] replacement) {
        this(src, at, replacement, -1);
    }

    public RecognizedRule(RecognizedRule src, int at, int[] replacement, int parent) {
        super(src.head, (String[])null);
        int i;
        this.pos = at < src.pos ? src.pos + replacement.length - 1 : src.pos;
        int len = src.rhs.length + replacement.length - 1;
        if (this.pos + 2 <= len) {
            len = this.pos + 2;
        }
        this.rhs = new String[len];
        for (i = 0; i < at; ++i) {
            this.rhs[i] = src.rhs[i];
        }
        for (i = 0; i < replacement.length && at + i < len; ++i) {
            this.rhs[at + i] = SqlEarley.getInstance().allSymbols[replacement[i]];
        }
        for (i = at + 1; i < src.rhs.length && i + replacement.length - 1 < len; ++i) {
            this.rhs[i + replacement.length - 1] = src.rhs[i];
        }
        if (len == this.pos + 2) {
            this.rhs[len - 1] = "...";
        }
        this.X = src.X;
        this.Y = src.Y;
        this.weight = src.weight / 2L;
        try {
            Integer w;
            if (0 < parent && (w = HarvestDoc.getFrequencies().get(Service.lPair(replacement[0], parent))) != null) {
                this.weight += (long)w.intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public RecognizedRule(RecognizedRule src, String[] replacement) {
        this(src, replacement, null);
    }

    public RecognizedRule(RecognizedRule src, String[] replacement, String head) {
        super(src.head, (String[])null);
        int i;
        int len = src.rhs.length - src.pos + replacement.length;
        this.pos = replacement.length;
        if (this.pos + 2 <= len) {
            len = this.pos + 2;
        }
        this.rhs = new String[len];
        for (i = 0; i < this.pos; ++i) {
            this.rhs[i] = replacement[i];
        }
        for (i = this.pos; i < this.rhs.length; ++i) {
            this.rhs[i] = src.rhs[i - this.pos + src.pos];
        }
        if (len == this.pos + 2) {
            this.rhs[len - 1] = "...";
        }
        this.X = src.X;
        this.Y = src.Y;
        this.weight = src.weight / 2L;
        try {
            if (head != null) {
                int h = (Integer)SqlEarley.getInstance().symbolIndexes.get(head);
                int s = (Integer)SqlEarley.getInstance().symbolIndexes.get(this.rhs[this.pos]);
                Integer w = HarvestDoc.getFrequencies().get(Service.lPair(s, h));
                if (w != null) {
                    this.weight += (long)w.intValue();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isTruncated() {
        return this.pos == this.rhs.length - 2 && "...".equals(this.rhs[this.rhs.length - 1]);
    }

    public boolean isPresentable() {
        for (int i = 0; i < this.rhs.length; ++i) {
            if ("...".equals(this.rhs[i])) continue;
            int code = (Integer)SqlEarley.getInstance().symbolIndexes.get(this.rhs[i]);
            Map<Integer, DocURL> railroads = HarvestDoc.getRailroads();
            DocURL tdoc = railroads.get(code);
            if (tdoc != null || this.rhs[i].charAt(0) == '\'' || "identifier".equals(this.rhs[i])) continue;
            Parser.Tuple[] tuples = SqlEarley.getInstance().rules;
            for (int j = 0; j < tuples.length; ++j) {
                Parser.Tuple candidate = tuples[j];
                if (candidate.head != code) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRedundant(List<RecognizedRule> rules) {
        boolean ret = false;
        for (RecognizedRule candidate : rules) {
            int i;
            if (this == candidate || this.pos != candidate.pos || !candidate.isTruncated()) continue;
            if (this.rhs.length + 1 == candidate.rhs.length) {
                ret = true;
                for (i = 0; i < this.rhs.length; ++i) {
                    if (this.rhs[i].equals(candidate.rhs[i])) continue;
                    ret = false;
                    break;
                }
                if (ret) {
                    return ret;
                }
            }
            if (this.rhs.length != candidate.rhs.length) continue;
            ret = true;
            for (i = 0; i < this.rhs.length; ++i) {
                if (this.rhs[i].equals(candidate.rhs[i])) continue;
                ret = false;
                break;
            }
            if (!ret || this.weight > candidate.weight) continue;
            return ret;
        }
        return ret;
    }

    public boolean isKeyword() {
        String s = this.rhs[this.pos];
        return s.charAt(0) == '\'';
    }

    public static void merge(Collection<RecognizedRule> rules, Collection<RecognizedRule> addendum) {
        for (RecognizedRule candidate : addendum) {
            boolean matches = false;
            for (RecognizedRule cmp : rules) {
                if (!cmp.equals(candidate)) continue;
                matches = true;
                cmp.weight += candidate.weight;
                break;
            }
            if (matches) continue;
            rules.add(candidate);
        }
    }

    @Override
    public int compareTo(Object obj) {
        RuleTuple src = (RuleTuple)obj;
        int cmp = 0;
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.rhs.length && i < src.rhs.length; ++i) {
            if (this.rhs[i].compareTo(src.rhs[i]) == 0) continue;
            return this.rhs[i].compareTo(src.rhs[i]);
        }
        cmp = this.rhs.length - src.rhs.length;
        if (cmp != 0) {
            return cmp;
        }
        int posDelta = this.pos - ((RecognizedRule)obj).pos;
        if (posDelta != 0) {
            return posDelta;
        }
        int xDelta = this.X - ((RecognizedRule)obj).X;
        if (xDelta != 0) {
            return xDelta;
        }
        int yDelta = this.Y - ((RecognizedRule)obj).Y;
        if (yDelta != 0) {
            return yDelta;
        }
        return this.compareWeight(obj);
    }

    public int compareWeight(Object obj) {
        RecognizedRule o = (RecognizedRule)obj;
        return this.weight - o.weight > 0L ? 1 : (this.weight - o.weight < 0L ? -1 : 0);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.head != null) {
            b.append(this.head + ":");
        }
        int i = -1;
        for (String t : this.rhs) {
            if (++i == this.pos) {
                b.append(" >!<");
            }
            b.append(" " + t);
        }
        return b.toString();
    }
}

