/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class ParentChildNodes
extends IdentedPredicate {
    String p;
    String c;
    int level = 1;
    Program program;

    public ParentChildNodes(String parent, String child, int level, Program program) {
        this.p = parent;
        this.c = child;
        this.level = level;
        this.program = program;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src, Map<String, Attribute> varDefs) {
        ParseNode nodeP = this.getNode(this.p, attributePositions, tuple, varDefs);
        if (nodeP == null) {
            return false;
        }
        ParseNode nodeC = this.getNode(this.c, attributePositions, tuple, varDefs);
        if (nodeC == null) {
            return false;
        }
        if (this.level == 1) {
            return nodeC.parent() == nodeP;
        }
        if (this.level == 2) {
            return nodeC.parent().parent() == nodeP;
        }
        throw new AssertionError((Object)("Unexpected level = " + this.level));
    }

    public String toString() {
        return this.p + " = " + this.c + (this.level == 2 ? "^^" : "^");
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        ret.add(this.p + "=" + this.c + (this.level == 2 ? "^^" : "^"));
    }

    @Override
    public void signature(Set<String> ret) {
        ParentChildNodes.variables(this.p, ret);
        ParentChildNodes.variables(this.c, ret);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        Attribute attr1 = varDefs.get(this.p);
        Attribute attr2 = varDefs.get(this.c);
        if (attr1.isDependent(var1, varDefs) && attr2.isDependent(var2, varDefs) || attr2.isDependent(var1, varDefs) && attr1.isDependent(var2, varDefs)) {
            return this;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int pos = this.p.indexOf(46);
        if (0 < pos) {
            ret.put(this.p.substring(0, pos), true);
        }
        if (0 < (pos = this.c.indexOf(46))) {
            ret.put(this.c.substring(0, pos), true);
        }
        return ret;
    }

    Set<Tuple> innerLoop(ParseNode node, MaterializedPredicate anc) {
        if (1 < anc.arity()) {
            throw new AssertionError((Object)"1 < anc.arity()");
        }
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        SortedSet<ParseNode> children = node.children();
        if (this.level == 2) {
            TreeSet<ParseNode> grandchildren = new TreeSet<ParseNode>();
            for (ParseNode p : children) {
                grandchildren.addAll(p.children());
            }
            children = grandchildren;
        }
        for (ParseNode p : children) {
            Tuple candidate = new Tuple(new ParseNode[]{p});
            if (!anc.getTuples().contains(candidate)) continue;
            ret.add(candidate);
        }
        return ret;
    }
}

