/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;

class ChildExpr
extends Attribute {
    int level = 1;
    String def;
    Predicate unaryFilter;

    public ChildExpr(String name, String def, int level, Predicate full) {
        this.name = name;
        this.level = level;
        this.def = def;
        this.unaryFilter = ChildExpr.unaryFilter(full, name);
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        int nameCol = attributePositions.get(this.name);
        int defCol = attributePositions.get(this.def);
        for (Tuple t : candidates) {
            ParseNode node = t.values[defCol];
            SortedSet<ParseNode> children = node.children();
            if (this.level == 2) {
                TreeSet<ParseNode> grandchildren = new TreeSet<ParseNode>();
                for (ParseNode p : children) {
                    grandchildren.addAll(p.children());
                }
                children = grandchildren;
            }
            for (ParseNode p : children) {
                ParseNode[] t1 = new ParseNode[t.values.length];
                System.arraycopy(t.values, 0, t1, 0, t.values.length);
                t1[nameCol] = p;
                if (!this.unaryFilter.eval(attributePositions, t1, this.src, null)) continue;
                ret.add(new Tuple(t1));
            }
        }
        return ret;
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return varDefs.get(this.def);
    }

    @Override
    public String toString() {
        return "\"" + this.name + " " + this.level + " " + this.def + "\"";
    }

    @Override
    ParseNode lookup(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        Integer pos = attributePositions.get(this.name);
        return tuple[pos];
    }
}

