/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.datapump.generators;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.datapump.DataPumpResources;
import oracle.dbtools.extension.datapump.common.DataPumpArguments;
import oracle.dbtools.extension.datapump.common.DataPumpGenOptions;
import oracle.dbtools.extension.datapump.common.DataPumpModel;
import oracle.dbtools.extension.datapump.common.DataPumpOption;
import oracle.dbtools.rest.RestMessages;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;

public class DataPumpGenerator {
    private static final String DATAPUMP_GROUP_FILE = "oracle/dbtools/extension/datapump/generators/templates/datapump.stg";
    private DataPumpModel _model;
    private DataPumpArguments _args;
    private DataPumpOption.Operation _operation;
    private STGroup _templateGroup;
    private Map<String, Object> _templateProps = new HashMap<String, Object>();

    public DataPumpGenerator(DataPumpModel model) {
        this._model = model;
        this._args = this._model.getArgs();
    }

    public void genSQL() {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(DataPumpResources.getString("DP_GEN"));
        }
        if (this._model.isExport()) {
            this._operation = DataPumpOption.Operation.EXPORT;
        }
        if (this._model.isImport()) {
            this._operation = DataPumpOption.Operation.IMPORT;
        }
        this.genStart();
        this.genOpen();
        this.genParallel();
        this.genFiles();
        this.genMetadataFilters();
        if (this._model.isImport()) {
            this.genRemapSchema();
            this.genRemapTablespace();
        }
        this.genNameValue(DataPumpOption.SubProgram.DATA_FILTER, "dataFilter");
        this.genNameValue(DataPumpOption.SubProgram.PARAMETER, "setParameter");
        this.genNameValue(DataPumpOption.SubProgram.METADATA_TRANSFORM, "metadataTransform");
        this.genTemplate("startJob");
        this.genWait();
        this.genTemplate("finish");
        if (this._model.isDebug() || this._model.isVerbose() || this._model.isNoExec()) {
            this._model.getToolLogger().log(this._model.getGenSql());
            if (this._model.isNoExec() || this._model.isVerbose()) {
                this._model.showBinds("GEN");
            }
        }
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessEnd();
        }
    }

    private void genStart() {
        this._templateProps.clear();
        this._templateProps.put("JOBNAME", (String)this._args.get("jobname"));
        this._model.appendGenSql(this.getTemplate("start", this._templateProps));
    }

    private void genOpen() {
        this._templateProps.clear();
        this.handleOptions(DataPumpOption.SubProgram.OPEN);
        this._model.appendGenSql(this.getTemplate("open", this._templateProps));
    }

    private void genParallel() {
        this._templateProps.clear();
        Object degreeObj = this._args.get("parallel");
        if (degreeObj != null) {
            String degree = null;
            if (degreeObj instanceof Integer) {
                degree = ((Integer)degreeObj).toString();
            } else if (degreeObj instanceof String) {
                degree = (String)degreeObj;
            }
            if (degree != null && !degree.trim().equals("1")) {
                this._templateProps.put("DEGREE", degree);
                this._model.appendGenSql(this.getTemplate("setParallel", this._templateProps));
            }
        }
    }

    private void genFiles() {
        String dumpcred = (String)this._args.get("credential");
        String dumpdir = (String)this._args.get("dumpdirectory");
        DataPumpOption opt = null;
        if (dumpcred != null) {
            List dumpUris = (List)this._args.get("dumpuri");
            opt = DataPumpGenOptions.getOption("dumpuri");
            int count = 1;
            for (String uri : dumpUris) {
                this._templateProps.clear();
                String bindName = "FILESIZE" + count;
                this._model.getGenBinds().put(bindName, (String)this._args.get("filesize"));
                this._templateProps.put("filesize", ":" + bindName);
                this._templateProps.put("reusefile", this._model.isArgTrue("reusefile") ? 1 : 0);
                bindName = "CREDENTIAL" + count;
                this._model.getGenBinds().put(bindName, dumpcred);
                this._templateProps.put("credentialname", ":" + bindName);
                bindName = opt.getSubProgramId() + "_DMP" + count;
                this._model.getGenBinds().put(bindName, uri);
                this._templateProps.put("uriname", ":" + bindName);
                this._model.appendGenSql(this.getTemplate("genCloudDumpFileMultiple", this._templateProps));
                ++count;
            }
        } else {
            Object al = this._args.get("dumpfile");
            List dumpFiles = (List)this._args.get("dumpfile");
            int count = 1;
            for (String file : dumpFiles) {
                this._templateProps.clear();
                this._model.getGenBinds().put("FILESIZE" + count, (String)this._args.get("filesize"));
                this._templateProps.put("filesize", ":FILESIZE" + count);
                this._templateProps.put("reusefile", this._model.isArgTrue("reusefile") ? 1 : 0);
                opt = DataPumpGenOptions.getOption("dumpdirectory");
                String dumpDirBind = opt.getSubProgramId() + "_DMP" + count;
                this._model.getGenBinds().put(dumpDirBind, dumpdir);
                this._templateProps.put("directoryname", ":" + dumpDirBind);
                opt = DataPumpGenOptions.getOption("dumpfile");
                String dumpfile = file;
                String dumpFileBind = opt.getSubProgramId() + "_DMP" + count;
                this._model.getGenBinds().put(dumpFileBind, (String)(dumpfile != null ? dumpfile : (String)this._args.get("jobname") + ".DMP"));
                this._templateProps.put("filename", ":" + dumpFileBind);
                this._model.appendGenSql(this.getTemplate("genDumpFileMultiple", this._templateProps));
                ++count;
            }
        }
        this._templateProps.clear();
        String logdir = (String)this._args.get("logdirectory");
        opt = DataPumpGenOptions.getOption("logdirectory");
        this._model.getGenBinds().put(opt.getSubProgramId() + "_LOG", logdir);
        opt = DataPumpGenOptions.getOption("logfile");
        String logfile = (String)this._args.get("logfile");
        this._model.getGenBinds().put(opt.getSubProgramId() + "_LOG", (String)(logfile != null ? logfile : (String)this._args.get("jobname") + ".LOG"));
        this._model.appendGenSql(this.getTemplate("genLogFile"));
    }

    private void genRemapSchema() {
        this._templateProps.clear();
        ArrayList schemasList = new ArrayList();
        DataPumpOption opt = DataPumpGenOptions.getOption("remapschemas");
        this._templateProps.put("name", opt.getSubProgramId());
        Map remaps = (Map)this._args.get("remapschemas");
        if (remaps != null && !remaps.isEmpty()) {
            int count = 1;
            Object bindName = "";
            for (Map.Entry entry : remaps.entrySet()) {
                bindName = "REMAP" + count;
                this._model.getGenBinds().put((String)bindName, (String)entry.getKey());
                this._templateProps.put("oldval", ":" + (String)bindName);
                bindName = "REMAP" + ++count;
                this._model.getGenBinds().put((String)bindName, (String)entry.getValue());
                this._templateProps.put("newval", ":" + (String)bindName);
                ++count;
                this._model.appendGenSql(this.getTemplate("metadataRemap", this._templateProps));
            }
        }
    }

    private void genRemapTablespace() {
        this._templateProps.clear();
        ArrayList schemasList = new ArrayList();
        DataPumpOption opt = DataPumpGenOptions.getOption("remaptablespaces");
        this._templateProps.put("name", opt.getSubProgramId());
        Map remaps = (Map)this._args.get("remaptablespaces");
        if (remaps != null && !remaps.isEmpty()) {
            int count = 1;
            Object bindName = "";
            for (Map.Entry entry : remaps.entrySet()) {
                bindName = "REMAPTABLESPACE" + count;
                this._model.getGenBinds().put((String)bindName, (String)entry.getKey());
                this._templateProps.put("oldval", ":" + (String)bindName);
                bindName = "REMAPTABLESPACE" + ++count;
                this._model.getGenBinds().put((String)bindName, (String)entry.getValue());
                this._templateProps.put("newval", ":" + (String)bindName);
                ++count;
                this._model.appendGenSql(this.getTemplate("metadataRemap", this._templateProps));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void genMetadataFilters() {
        DataPumpOption opt;
        this._templateProps.clear();
        List schemasList = (List)this._args.get("schemas");
        ArrayList<CallSite> valList = new ArrayList<CallSite>();
        if (schemasList != null) {
            DataPumpOption opt2 = DataPumpGenOptions.getOption("schemas");
            int count = 1;
            Object bindName = "";
            for (String schema : schemasList) {
                bindName = "SCHEMA" + count;
                this._model.getGenBinds().put((String)bindName, schema);
                valList.add((CallSite)((Object)(":" + (String)bindName)));
                ++count;
            }
            this._templateProps.put("name", opt2.getSubProgramId());
            this._templateProps.put("valList", valList);
            this._model.appendGenSql(this.getTemplate("metadataFilter", this._templateProps));
        }
        this._templateProps.clear();
        String eExpr = (String)this._args.get("excludeexpr");
        if (eExpr != null) {
            DataPumpOption opt3 = DataPumpGenOptions.getOption("excludeexpr");
            int count = 1;
            String bindName = "EXCLUDEX" + count;
            this._model.getGenBinds().put(bindName, eExpr);
            this._templateProps.put("name", opt3.getSubProgramId());
            this._templateProps.put("expr", ":" + bindName);
            this._model.appendGenSql(this.getTemplate("metadataFilterExpr", this._templateProps));
        }
        this._templateProps.clear();
        List xList = (List)this._args.get("excludelist");
        if (xList != null) {
            DataPumpOption opt4 = DataPumpGenOptions.getOption("excludelist");
            this._templateProps.put("name", opt4.getSubProgramId());
            this._templateProps.put("exprList", this.genBindsForList(xList, "EXCLUDEL"));
            this._model.appendGenSql(this.getTemplate("metadataFilterList", this._templateProps));
        }
        this._templateProps.clear();
        String iExpr = (String)this._args.get("includeexpr");
        if (iExpr != null) {
            opt = DataPumpGenOptions.getOption("includeexpr");
            int count = 1;
            String bindName = "INCLUDEX" + count;
            this._model.getGenBinds().put(bindName, iExpr);
            this._templateProps.put("name", opt.getSubProgramId());
            this._templateProps.put("expr", ":" + bindName);
            this._model.appendGenSql(this.getTemplate("metadataFilterExpr", this._templateProps));
        }
        this._templateProps.clear();
        xList = (List)this._args.get("includelist");
        if (xList != null) {
            opt = DataPumpGenOptions.getOption("includelist");
            this._templateProps.put("name", opt.getSubProgramId());
            this._templateProps.put("exprList", this.genBindsForList(xList, "INCLUDEL"));
            this._model.appendGenSql(this.getTemplate("metadataFilterList", this._templateProps));
        }
        this._templateProps.clear();
        opt = DataPumpGenOptions.getOption("nameexpr");
        this._templateProps.put("name", opt.getSubProgramId());
        Map typeNamesX = (Map)this._args.get("nameexpr");
        if (typeNamesX != null && !typeNamesX.isEmpty()) {
            int count = 1;
            Object bindName = "";
            for (Map.Entry entry : typeNamesX.entrySet()) {
                bindName = "TYPEX" + count;
                this._model.getGenBinds().put((String)bindName, (String)entry.getKey());
                this._templateProps.put("name", opt.getSubProgramId());
                this._templateProps.put("type", ":" + (String)bindName);
                bindName = "NAMEX" + count;
                this._model.getGenBinds().put((String)bindName, (String)entry.getValue());
                this._templateProps.put("expr", ":" + (String)bindName);
                this._model.appendGenSql(this.getTemplate("metadataFilterExprByType", this._templateProps));
                ++count;
                this._templateProps.clear();
            }
        }
        this._templateProps.clear();
        opt = DataPumpGenOptions.getOption("namelist");
        Map typeNamesL = (Map)this._args.get("namelist");
        if (typeNamesL != null && !typeNamesL.isEmpty()) {
            int count = 1;
            Object bindName = "";
            for (Map.Entry entry : typeNamesL.entrySet()) {
                bindName = "TYPEL" + count;
                this._model.getGenBinds().put((String)bindName, (String)entry.getKey());
                this._templateProps.put("name", opt.getSubProgramId());
                this._templateProps.put("type", ":" + (String)bindName);
                this._templateProps.put("exprList", this.genBindsForList((List)entry.getValue(), "NAMEL" + count + "_"));
                this._model.appendGenSql(this.getTemplate("metadataFilterListByType", this._templateProps));
                this._templateProps.clear();
                ++count;
            }
        }
        this._templateProps.clear();
        String excludeLong = (String)this._args.get("excludedwcs");
        if (excludeLong != null) {
            excludeLong = excludeLong.substring(excludeLong.indexOf("(") + 1, excludeLong.lastIndexOf(")")).replace("'", "").replace("\"", "");
            String[] excludeArray = excludeLong.split(",");
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            opt = DataPumpGenOptions.getOption("excludedwcs");
            boolean bl = true;
            Object bindName = "";
            for (String exclude : excludeArray) {
                void var12_24;
                bindName = "EXCLUDE" + (int)var12_24;
                this._model.getGenBinds().put((String)bindName, exclude.trim());
                arrayList.add((CallSite)((Object)(":" + (String)bindName)));
                ++var12_24;
            }
            this._templateProps.put("name", opt.getSubProgramId());
            this._templateProps.put("valList", arrayList);
            this._model.appendGenSql(this.getTemplate("metadataFilter", this._templateProps));
        }
    }

    private void genNameValue(DataPumpOption.SubProgram subProgram, String template) {
        this._templateProps.clear();
        Map<String, DataPumpOption> options = DataPumpGenOptions.getOptions(this._operation, subProgram);
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            String key = entry.getKey();
            String arg = null;
            Object argObj = this._args.get(key);
            if (argObj == null || (arg = argObj instanceof Boolean ? argObj.toString() : (String)argObj) == null || arg.isEmpty()) continue;
            String bindName = ":" + opt.getSubProgramId();
            this._templateProps.put("name", opt.getSubProgramId());
            if (opt.getParameterType() == DataPumpOption.ParameterType.BOOLEAN) {
                this._templateProps.put("value", this._model.isArgTrue(key) ? 1 : 0);
            } else if (opt.getParameterType() == DataPumpOption.ParameterType.NUMBER || opt.getParameterType() == DataPumpOption.ParameterType.PLSQL) {
                this._templateProps.put("value", arg);
            } else {
                this._templateProps.put("value", bindName);
                this._model.getGenBinds().put(opt.getSubProgramId(), arg);
            }
            this._model.appendGenSql(this.getTemplate(template, this._templateProps));
        }
    }

    private void handleOptions(DataPumpOption.SubProgram subProgram) {
        Map<String, DataPumpOption> options = DataPumpGenOptions.getOptions(this._operation, subProgram);
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            String bindName = ":" + opt.getSubProgramId();
            this._templateProps.put(opt.getSubProgramId(), bindName);
            this._model.getGenBinds().put(opt.getSubProgramId(), (String)this._args.get(entry.getKey()));
        }
    }

    private void genWait() {
        if (this._model.isArgTrue("wait")) {
            this.genTemplate("wait");
        }
    }

    private List<String> genBindsForList(List<String> list, String bindPrefix) {
        if (list != null) {
            ArrayList<String> valList = new ArrayList<String>();
            int count = 1;
            Object bindName = "";
            for (String type : list) {
                bindName = bindPrefix + count;
                this._model.getGenBinds().put((String)bindName, type);
                valList.add(":" + (String)bindName);
                ++count;
            }
            return valList;
        }
        return list;
    }

    private void genTemplate(String template) {
        this._model.appendGenSql(this.getTemplate(template));
    }

    private STGroup getTemplateGroup() {
        if (this._templateGroup == null) {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                this._templateGroup = new STGroupFile(DATAPUMP_GROUP_FILE);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
        return this._templateGroup;
    }

    private String getTemplate(String templateName) {
        return this.getTemplate(templateName, null);
    }

    private String getTemplate(String templateName, Map<String, Object> properties) {
        if (this.getTemplateGroup() != null) {
            ST st = this.getTemplateGroup().getInstanceOf(templateName);
            if (st != null) {
                if (properties != null) {
                    Set<String> keys = properties.keySet();
                    for (String k : keys) {
                        st.add(k, properties.get(k));
                    }
                }
                NoIndentWriter out = new NoIndentWriter((Writer)new StringWriter());
                try {
                    st.write((STWriter)out);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return st.render();
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format((String)"GEN_TEMPLATE_NOT_FOUND", (Object[])new Object[]{templateName}));
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format((String)"GEN_GROUP_FILE_NOT_FOUND", (Object[])new Object[]{DATAPUMP_GROUP_FILE}));
        }
        return null;
    }
}

