/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.datapump.commands;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.datapump.DataPumpResources;
import oracle.dbtools.extension.datapump.commands.DataPumpOptions;
import oracle.dbtools.extension.datapump.commands.SetDataPumpOptions;
import oracle.dbtools.extension.datapump.common.DataPumpArguments;
import oracle.dbtools.extension.datapump.common.DataPumpModel;
import oracle.dbtools.extension.datapump.exceptions.ProcessFailedException;
import oracle.dbtools.extension.datapump.executors.DataPumpExecutor;
import oracle.dbtools.extension.datapump.executors.DataPumpTransfer;
import oracle.dbtools.extension.datapump.generators.DataPumpGenerator;
import oracle.dbtools.extension.datapump.generators.DataPumpPreprocessor;
import oracle.dbtools.extension.datapump.help.Messages;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.util.Logger;

public class DataPumpCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected,
ICommandSyntax {
    private static final String HELP_BUNDLE = "Help";
    private static final String NL = "\n";

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "DataPump";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getCommandLongName() {
        return "DataPump";
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return null;
    }

    public String getCommandShortName() {
        return "dp";
    }

    public String getExtensionDescription() {
        return Messages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return "DataPump";
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, DataPumpOptions.getCommandType()).get(pagePath);
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String subCommand;
        Parser parser;
        Optional optParsedCommand;
        if (!cmd.getLoweredTrimmedSQL().startsWith(this.getCommand().toLowerCase()) && !cmd.getLoweredTrimmedSQL().startsWith(this.getCommandShortName())) {
            return false;
        }
        if (conn == null) {
            this.showConnectionRequired(ctx);
            return true;
        }
        if (cmd.getProperty("STRIPPED_CONTINUATION") == null) {
            cmd.setSql(ScriptUtils.checkforContinuationChars((String)cmd.getSql()));
        }
        if (!(optParsedCommand = (parser = new Parser(DataPumpOptions.getCommandType(), ctx.getEnvironment())).parse(cmd.getSql(), error -> ctx.writeln(error))).isPresent()) {
            return true;
        }
        ParsedCommand parsedCommand = (ParsedCommand)optParsedCommand.get();
        DataPumpArguments args = this.getOptions(ctx, cmd, parsedCommand);
        if (args == null) {
            return true;
        }
        DataPumpModel model = new DataPumpModel(conn, ctx, cmd, args);
        switch (subCommand = parsedCommand.getType().getName().toLowerCase()) {
            case "export": {
                model.isExport(true);
                this.process(model);
                break;
            }
            case "import": {
                model.isImport(true);
                this.process(model);
                break;
            }
            default: {
                this.getHelp(ctx, "DataPump".toUpperCase());
            }
        }
        return true;
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }

    private DataPumpArguments getOptions(ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        DataPumpArguments args = new DataPumpArguments(ctx);
        ScriptRunnerContext.Parameters parameters = ctx.getParameterInstance();
        try {
            if (!ctx.getParameterInstance().parametersContains("setdatapump.parms")) {
                CommandParser.loadParams((String)"setdatapump.parms", (String)"set datapump -default false", (ScriptRunnerContext)ctx, SetDataPumpOptions.class);
                if (parameters.getParameterAsBoolean("setdatapump.parms", "debug").booleanValue()) {
                    ctx.write("Defaults Set");
                    ctx.getParameterInstance().printParametersAsRow("setdatapump.parms");
                }
            }
            parameters.getParameters("setdatapump.parms").forEach((key, value) -> args.put(key, value));
            for (Map.Entry entry : parsedCommand.getOptions().entrySet()) {
                if (entry.getValue() == null) continue;
                args.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
            }
            args.put("basecommand", args.get("command"));
            args.put("jobmode", "SCHEMA");
            args.put("keepmaster", "true");
            if (!args.contains("columnencryption")) {
                args.put("columnencryption", "true");
            }
            if (!args.contains("includemetadata")) {
                args.put("includemetadata", "true");
            }
            if (!args.contains("includerows")) {
                args.put("includerows", "true");
            }
            if (!args.contains("reusefile")) {
                args.put("reusefile", "true");
            }
            if (!args.contains("tablecompression")) {
                args.put("tablecompression", "true");
            }
            if (!args.contains("wait")) {
                args.put("wait", "true");
            }
            String subCommand = parsedCommand.getType().getName().toUpperCase();
            args.put("operation", subCommand);
            return args;
        }
        catch (CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (parameters.getParameterAsBoolean("datapump.parms", "debug").booleanValue()) {
                e.printStackTrace(pw);
                ctx.write(pw.toString());
            } else {
                ctx.write(e.getLocalizedMessage() + NL);
                ctx.write(Messages.getString("FAILED_REQUEST"));
                parameters.printParametersAsTable("datapump.parms");
            }
            return null;
        }
    }

    private void process(DataPumpModel model) {
        long start = System.currentTimeMillis();
        try {
            if (model.isVerbose() || model.isDebug()) {
                model.getToolLogger().logToolStart(DataPumpResources.getString("DP"));
            }
            if (model.getConn() != null) {
                DataPumpPreprocessor preprocessor;
                if (model.isDebug()) {
                    model.getToolLogger().log("debug on");
                }
                if (model.getConn() != null && (preprocessor = new DataPumpPreprocessor(model)).check()) {
                    if (!model.ToolLoggerFlushLog()) {
                        return;
                    }
                    if (preprocessor.handleSupport()) {
                        if (!model.ToolLoggerFlushLog()) {
                            return;
                        }
                        DataPumpGenerator generator = new DataPumpGenerator(model);
                        generator.genSQL();
                        if (!model.ToolLoggerFlushLog()) {
                            return;
                        }
                        if (model.isNoExec()) {
                            model.getCtx().write(DataPumpResources.getString("NO_EXEC") + NL);
                        } else {
                            if (model.isImport() && model.isArgTrue("copycloud")) {
                                DataPumpTransfer transfer = new DataPumpTransfer(model);
                                transfer.transferFromCloud();
                                if (!model.ToolLoggerFlushLog()) {
                                    return;
                                }
                            }
                            DataPumpExecutor executor = new DataPumpExecutor(model);
                            boolean isExec = executor.execSql();
                            if (!model.ToolLoggerFlushLog()) {
                                return;
                            }
                            if (isExec & model.isExport() && model.isArgTrue("copycloud")) {
                                DataPumpTransfer transfer = new DataPumpTransfer(model);
                                transfer.transferToCloud();
                                if (!model.ToolLoggerFlushLog()) {
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                model.getToolLogger().logError(e1.getLocalizedMessage());
            }
            model.getToolLogger().logException((Throwable)e);
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        if (model.isVerbose() || model.isDebug()) {
            model.getToolLogger().logToolEnd();
        }
        if (model.getCtx().getTiming()) {
            model.getToolLogger().log(ToolLoggerResources.format((String)"TIMINGELAPSEDTOTAL", (Object[])new Object[]{ToolLogger.getElapsedTime((long)start)}) + NL);
        }
        model.ToolLoggerFlushLog();
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        HelpPages helpPages = new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine()).alphaSort().addHelpContainerFor((Object)this, HELP_BUNDLE).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
        return helpPages;
    }

    private void showConnectionRequired(ScriptRunnerContext ctx) {
        ToolLogger tLogger = new ToolLogger((OutputStream)ctx.getOutputStream());
        tLogger.logError(DataPumpResources.format("DPCMPD_CONN", "DataPump".toLowerCase()));
        if (!ctx.isInterrupted()) {
            tLogger.flushLog();
        }
    }
}

