/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;

public abstract class OraDateFormat
extends Format {
    static final String DEFAULT_DATE_LONG_FORMAT = "DL";
    static final String DEFAULT_DATE_SHORT_FORMAT = "DS";
    static final String DEFAULT_TIME_SHORT_FORMAT = "TS";
    static final int DEFAULT_DATE_OR_TIME_FORMAT_LENGTH = "DL".length();
    static final int DEFAULT_DATE_AND_TIME_FORMAT_LENGTH = (DEFAULT_DATE_OR_TIME_FORMAT_LENGTH << 1) + 1;
    static final int NULL_FIELD = -1;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR_FIELD = 15;
    public static final int TIMEZONE_FIELD = 17;
    public static final int ALL_FIELD = 1000;
    public static final int CENTRY_FIELD = 1001;
    public static final int JULIAN_DAY_FIELD = 1002;
    public static final int QUARTER_OF_YEAR_FIELD = 1003;
    public static final int SECONDS_FIELD = 1004;
    public static final int TEXT_FIELD = 1005;
    public static final int ISO_YEAR_FIELD = 1006;
    public static final int ISO_WEEK_OF_YEAR_FIELD = 1007;
    static final int NONE = -1;
    public static final int SHORT = 3;
    public static final int LONG = 1;
    public static final int DEFAULT = 127;
    protected Calendar calendar;

    public static final OraDateFormat getDateInstance() {
        return OraDateFormat.getInstance(127, -1, OraLocaleInfo.getDefault());
    }

    public static final OraDateFormat getDateInstance(int n) {
        return OraDateFormat.getDateInstance(n, OraLocaleInfo.getDefault());
    }

    public static final OraDateFormat getDateInstance(int n, Locale locale) {
        return OraDateFormat.getDateInstance(n, OraLocaleInfo.getInstance(locale));
    }

    public static final OraDateFormat getDateInstance(int n, OraLocaleInfo oraLocaleInfo) {
        if (n != 3 && n != 1 && n != 127) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5086));
        }
        return OraDateFormat.getInstance(n, -1, oraLocaleInfo);
    }

    public static final OraDateFormat getDateTimeInstance() {
        return OraDateFormat.getInstance(127, 127, OraLocaleInfo.getDefault());
    }

    public static final OraDateFormat getDateTimeInstance(int n) {
        return OraDateFormat.getDateTimeInstance(n, OraLocaleInfo.getDefault());
    }

    public static final OraDateFormat getDateTimeInstance(int n, Locale locale) {
        return OraDateFormat.getDateTimeInstance(n, OraLocaleInfo.getInstance(locale));
    }

    public static final OraDateFormat getDateTimeInstance(int n, OraLocaleInfo oraLocaleInfo) {
        if (n != 3 && n != 1 && n != 127) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5086));
        }
        return OraDateFormat.getInstance(n, 127, oraLocaleInfo);
    }

    public static final OraDateFormat getInstance() {
        return OraDateFormat.getDateTimeInstance();
    }

    public static final OraDateFormat getTimeInstance() {
        return OraDateFormat.getTimeInstance(Locale.getDefault());
    }

    public static final OraDateFormat getTimeInstance(Locale locale) {
        return OraDateFormat.getTimeInstance(OraLocaleInfo.getInstance(locale));
    }

    public static final OraDateFormat getTimeInstance(OraLocaleInfo oraLocaleInfo) {
        return OraDateFormat.getInstance(-1, 127, oraLocaleInfo);
    }

    public final String format(Date date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(new Date(((Number)object).longValue()), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException(GDKMessage.getMessage(5085));
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            Date date = this.parse(string, parsePosition);
            return date;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), parsePosition.getErrorIndex());
        }
    }

    public abstract Date parse(String var1, ParsePosition var2);

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public static String getDefaultDateFormatPattern(int n, Locale locale) {
        return OraDateFormat.getDefaultDateFormatPattern(n, OraLocaleInfo.getInstance(locale));
    }

    public static String getDefaultDateFormatPattern(int n, OraLocaleInfo oraLocaleInfo) {
        return OraDateFormat.getDefaultFormatPattern(n, -1, true, oraLocaleInfo.getOraTerritory());
    }

    public static String getDefaultDateTimeFormatPattern(int n, Locale locale) {
        return OraDateFormat.getDefaultDateTimeFormatPattern(n, OraLocaleInfo.getInstance(locale));
    }

    public static String getDefaultDateTimeFormatPattern(int n, OraLocaleInfo oraLocaleInfo) {
        return OraDateFormat.getDefaultFormatPattern(n, 127, true, oraLocaleInfo.getOraTerritory());
    }

    public static String getDefaultTimeFormatPattern(Locale locale) {
        return OraDateFormat.getDefaultTimeFormatPattern(OraLocaleInfo.getInstance(locale));
    }

    public static String getDefaultTimeFormatPattern(OraLocaleInfo oraLocaleInfo) {
        return OraDateFormat.getDefaultFormatPattern(-1, 127, true, oraLocaleInfo.getOraTerritory());
    }

    static String getDefaultFormatPattern(int n, int n2, boolean bl, OraTerritory oraTerritory) {
        String string = null;
        String string2 = null;
        if (n == 3) {
            string = oraTerritory.getNLSDateShortFormat();
        } else if (n == 1) {
            string = oraTerritory.getNLSDateLongFormat();
        } else if (n == 127) {
            string = oraTerritory.getOracleDateFormatString();
        } else if (n != -1) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5086));
        }
        if (n2 == 3 || n2 == 127) {
            if (bl) {
                string2 = oraTerritory.getNLSTimeShortFormat();
            } else {
                string2 = string;
                string = oraTerritory.getNLSTimeShortFormat();
            }
        } else if (n2 != -1) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5086));
        }
        if (string == string2) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5086));
        }
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        boolean bl2 = false;
        for (int i = 0; i < string.length() - 1; ++i) {
            if (string.charAt(i) != 'f' && string.charAt(i) != 'F' || string.charAt(++i) != 'm' && string.charAt(i) != 'M') continue;
            bl2 = !bl2;
        }
        if (!bl2) {
            return string + ' ' + string2;
        }
        if (!(string2.length() <= 1 || string2.charAt(0) != 'f' && string2.charAt(0) != 'F' || string2.charAt(0) != 'm' && string2.charAt(0) != 'M')) {
            return string + ' ' + string2.substring(2);
        }
        return string + " fm" + string2;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }

    @Override
    public Object clone() {
        OraDateFormat oraDateFormat = (OraDateFormat)super.clone();
        oraDateFormat.calendar = (Calendar)this.calendar.clone();
        return oraDateFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDateFormat)) {
            return false;
        }
        OraDateFormat oraDateFormat = (OraDateFormat)object;
        return this.calendar.getFirstDayOfWeek() == oraDateFormat.calendar.getFirstDayOfWeek() && this.calendar.getMinimalDaysInFirstWeek() == oraDateFormat.calendar.getMinimalDaysInFirstWeek() && this.calendar.isLenient() == oraDateFormat.calendar.isLenient() && this.calendar.getTimeZone().equals(oraDateFormat.calendar.getTimeZone());
    }

    private static final OraDateFormat getInstance(int n, int n2, OraLocaleInfo oraLocaleInfo) {
        try {
            return new OraSimpleDateFormat(n, n2, oraLocaleInfo);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }
}

