/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.scheduling.JSONToPropertiesObject;
import oracle.dbtools.mle_js.ExpNode;
import oracle.dbtools.mle_js.ImpExpVisitor;
import oracle.dbtools.mle_js.MLEJS_Util;
import oracle.dbtools.mle_js.ModuleMetadata;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptLexer;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptParser;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class AntlrAstParser {
    public static void main(String[] args) {
    }

    public static ModuleMetadata getModuleMetadataFromJS(String code) {
        ModuleMetadata moduleMetadata;
        ByteArrayInputStream stream = new ByteArrayInputStream(code.getBytes(StandardCharsets.UTF_8.name()));
        try {
            JavaScriptLexer lexer = new JavaScriptLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            tokens.fill();
            Map<Long, ImpExpVisitor.Comment> comments = ImpExpVisitor.getComments(tokens);
            JavaScriptParser parser = new JavaScriptParser((TokenStream)tokens);
            JavaScriptParser.ProgramContext tree = parser.program();
            ImpExpVisitor visitor = new ImpExpVisitor();
            visitor.visit((ParseTree)tree);
            Map<String, Object> map = ImpExpVisitor.toMap(visitor.imports, visitor.exports, visitor.functions, visitor.classes, visitor.vars);
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            String json = ow.writeValueAsString(map);
            ArrayList<ExpNode> exps = new ArrayList<ExpNode>();
            ArrayList<ExpNode> imps = new ArrayList<ExpNode>();
            ArrayList<ExpNode> notResolved = new ArrayList<ExpNode>();
            ArrayList<ExpNode> requiredVars = new ArrayList<ExpNode>();
            ArrayList<String> lines = new ArrayList<String>();
            code.lines().forEach(line -> lines.add(line + System.lineSeparator()));
            AntlrAstParser.parseJSON(json, exps, imps, notResolved, requiredVars, comments, lines);
            ModuleMetadata meta = new ModuleMetadata();
            meta.exports = exps;
            meta.imports = imps;
            meta.notResolved = notResolved;
            meta.requiredVars = requiredVars;
            moduleMetadata = meta;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return moduleMetadata;
    }

    static String listToJson(String name, List<ExpNode> exps, int baseTab) {
        ExpNode.StringAdd s = new ExpNode.StringAdd();
        s.addNL_Tabs("\"" + name + "\":[", baseTab);
        boolean first = true;
        for (ExpNode exp : exps) {
            if (first) {
                s.addNL().addText(exp.toJson(baseTab + 1));
                first = false;
                continue;
            }
            s.addText(",").addNL().addText(exp.toJson(baseTab + 1));
        }
        s.addNL().addNL_Tabs("]", baseTab);
        return s.toString();
    }

    public static JsonObject parseJSON(String str, List<ExpNode> exps, List<ExpNode> imps, List<ExpNode> notResolved, List<ExpNode> requiredVars, Map<Long, ImpExpVisitor.Comment> comments) {
        return AntlrAstParser.parseJSON(str, exps, imps, notResolved, requiredVars, comments, null);
    }

    public static JsonObject parseJSON(String str, List<ExpNode> exps, List<ExpNode> imps, List<ExpNode> notResolved, List<ExpNode> requiredVars, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        JsonObject jdoc = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8.name()));){
            jdoc = ImpExpVisitor.JSF.createReader((InputStream)stream).readObject();
            HashMap<String, ExpNode> vardefs = new HashMap<String, ExpNode>();
            AntlrAstParser.processExports(jdoc, exps, comments, lines);
            ArrayList<ExpNode> t = new ArrayList<ExpNode>();
            Hashtable<String, String> names = new Hashtable<String, String>();
            for (ExpNode node : exps) {
                if ("exportItems".equals(node.type)) {
                    t.add(node);
                    AntlrAstParser.addExportItems(node.expItems, names);
                    continue;
                }
                if (!"exportDefault".equals(node.type)) continue;
                names.put(node.name_in_code, node.name);
            }
            if (t.size() > 0) {
                exps.removeAll(t);
            }
            ArrayList<ExpNode> vars = new ArrayList<ExpNode>();
            ArrayList<ExpNode> reqVars = new ArrayList<ExpNode>();
            HashMap<String, ExpNode> varsMap = new HashMap<String, ExpNode>();
            HashMap<String, String> namesCopy = new HashMap<String, String>(names);
            AntlrAstParser.processVaribles(jdoc, vars, names, comments, lines, vardefs);
            ArrayList<ExpNode> indirectExp = new ArrayList<ExpNode>();
            for (ExpNode exp : vars) {
                if (exp.name != null) {
                    varsMap.put(exp.name, exp);
                }
                if (!"exportIndirect".equals(exp.type)) continue;
                indirectExp.add(exp);
                if (reqVars.contains(exp)) continue;
                reqVars.add(exp);
            }
            for (ExpNode exp : indirectExp) {
                if (exp.expItems == null || exp.expItems.size() <= 0) continue;
                AntlrAstParser.processIndirectExports(exp, varsMap, reqVars, names);
            }
            requiredVars.addAll(reqVars);
            for (ExpNode exp : vars) {
                String alias;
                if (exp.name == null || (alias = (String)namesCopy.get(exp.name)) == null) continue;
                exps.add(exp);
                names.remove(exp.name);
                if (alias.equals(exp.name)) continue;
                exp.name_in_code = exp.name;
                exp.name = alias;
            }
            AntlrAstParser.processFunctions(jdoc, exps, names, comments, lines);
            AntlrAstParser.processClasses(jdoc, exps, names, comments, lines);
            for (ExpNode exp : requiredVars) {
                List<String> items;
                if (exp.name != null) {
                    names.remove(exp.name);
                }
                if ((items = exp.expItems) == null || items.size() <= 0) continue;
                for (String name : items) {
                    String[] parts;
                    if ((name = name.strip()).indexOf(" as ") > 0 && (parts = name.split(" as ")).length == 2) {
                        name = parts[0];
                    }
                    names.remove(name);
                }
            }
            AntlrAstParser.createPossibleImports(notResolved, names);
            AntlrAstParser.processImports(jdoc, imps);
            AntlrAstParser.processNotResolved(exps, notResolved);
            AntlrAstParser.processNotResolved(imps, notResolved);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return jdoc;
    }

    static void processIndirectExports(ExpNode exp, Map<String, ExpNode> varsMap, List<ExpNode> reqVars, Map<String, String> names) {
        if (exp.expItems != null && exp.expItems.size() > 0) {
            HashMap<String, String> exps = new HashMap<String, String>();
            AntlrAstParser.addExportItems(exp.expItems, exps);
            names.putAll(exps);
            for (Map.Entry ent : exps.entrySet()) {
                ExpNode node = varsMap.get(ent.getKey());
                if (node == null || "exportIndirect".equals(node.type)) continue;
                if (!reqVars.contains(node)) {
                    reqVars.add(node);
                }
                AntlrAstParser.processIndirectExports(node, varsMap, reqVars, names);
            }
        }
    }

    static void processNotResolved(List<ExpNode> source, List<ExpNode> notResolved) {
        ArrayList<ExpNode> temp = new ArrayList<ExpNode>();
        for (ExpNode node : source) {
            if (node.isBuiltInModule() || node.name != null) continue;
            temp.add(node);
        }
        source.removeAll(temp);
        notResolved.addAll(temp);
    }

    static void processExports(JsonObject jdoc, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        exps.clear();
        JsonArray ja = jdoc.getJsonArray("exports");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                ExpNode exp;
                JsonObject job = ja.getJsonObject(i);
                JsonArray ar = job.getJsonArray("exportDeclaration");
                if (ar != null) {
                    AntlrAstParser.processExportDeclaration(ar, exps, comments, lines);
                    continue;
                }
                JsonArray decl = job.getJsonArray("exportDefaultDeclaration");
                if (decl != null) {
                    ExpNode exp2;
                    String name;
                    JsonArray are = decl.getJsonObject(2).getJsonArray("identifierExpression");
                    if (are != null) {
                        JsonObject obj = are.getJsonObject(0).getJsonArray("identifier").getJsonObject(0);
                        name = obj.getString("text");
                        exp2 = new ExpNode();
                        exps.add(exp2);
                        exp2.type = "exportDefault";
                        exp2.name_in_code = name;
                        exp2.name = "default";
                        try {
                            ImpExpVisitor.Comment c;
                            int start = obj.getInt("start");
                            int stop = obj.getInt("stop");
                            if (comments != null && (c = comments.get(start - 1)) != null) {
                                exp2.comment = c.comment;
                            }
                            if (lines == null) continue;
                            exp2.code = ImpExpVisitor.getCode(lines, start, stop);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    JsonArray jarr = decl.getJsonObject(2).getJsonArray("functionExpression");
                    if (jarr == null || (exp2 = AntlrAstParser.processFunctionExpression(jarr, exps, null, comments, lines, name = "default")) == null) continue;
                    exp2.name_in_code = exp2.name;
                    exp2.name = name;
                    exp2.type = "function";
                    exps.add(exp2);
                    continue;
                }
                ar = job.getJsonArray("functionDeclaration");
                if (ar != null) {
                    exp = AntlrAstParser.processFunctionDeclaration(ar, exps, null, comments, lines, null);
                    if (exp == null) continue;
                    exps.add(exp);
                    continue;
                }
                ar = job.getJsonArray("variableDeclaration");
                if (ar != null) {
                    exp = AntlrAstParser.processVariableDeclaration(ar, exps, null, comments, lines);
                    if (exp == null) continue;
                    exps.add(exp);
                    continue;
                }
                ar = job.getJsonArray("classDeclaration");
                if (ar == null || (exp = AntlrAstParser.processClass(ar, exps, null, comments, lines, null)) == null) continue;
                exps.add(exp);
            }
        }
    }

    static void processVaribles(JsonObject jdoc, List<ExpNode> vars, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, Map<String, ExpNode> vardefs) {
        JsonArray ja = jdoc.getJsonArray("vars");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                ExpNode exp;
                JsonObject job = ja.getJsonObject(i);
                JsonArray arf = job.getJsonArray("variableStatement");
                if (arf != null) {
                    ExpNode exp2 = AntlrAstParser.processVariableStatement(arf, vars, names, comments, lines);
                    if (exp2 == null) continue;
                    vars.add(exp2);
                    continue;
                }
                JsonArray jarr = job.getJsonArray("variableDeclaration");
                if (jarr == null || (exp = AntlrAstParser.processVariableDeclaration(jarr, vars, names, comments, lines)) == null) continue;
                vars.add(exp);
            }
        }
    }

    static ExpNode processVariableStatement(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        ExpNode exp;
        JsonArray var = arf.getJsonObject(0).getJsonArray("variableDeclarationList");
        JsonArray vdecl = var.getJsonObject(1).getJsonArray("variableDeclaration");
        if (vdecl != null && (exp = AntlrAstParser.processVariableDeclaration(vdecl, exps, names, comments, lines)) != null) {
            try {
                if (exp.type == null) {
                    exp.type = "var";
                }
                try {
                    int start = var.getJsonObject(1).getInt("start");
                    int stop = var.getJsonObject(1).getInt("stop");
                    ImpExpVisitor.Comment c = comments.get(start - 1);
                    if (c != null) {
                        exp.comment = c.comment;
                    }
                    if (lines != null) {
                        exp.code = ImpExpVisitor.getCode(lines, start, stop);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JsonObject job = var.getJsonObject(0);
                JsonArray var_m = job.getJsonArray("varModifier");
                if (var_m != null) {
                    JsonValue val = (JsonValue)var_m.getJsonObject(0).get((Object)"text");
                    if (val != null) {
                        exp.subtype = val.toString();
                        exp.subtype = MLEJS_Util.getName(exp.subtype);
                    } else {
                        JsonArray valarr = var_m.getJsonObject(0).getJsonArray("let_");
                        if (valarr != null) {
                            exp.subtype = valarr.getJsonObject(0).getString("text");
                            exp.subtype = MLEJS_Util.getName(exp.subtype);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return exp;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ExpNode processVariableDeclaration(JsonArray vdecl, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        if (vdecl != null) {
            String type = "var";
            String name = null;
            try {
                JsonArray ja;
                JsonArray jar = vdecl.getJsonObject(0).getJsonArray("assignable");
                if (jar != null && jar.size() > 0 && (ja = jar.getJsonObject(0).getJsonArray("identifier")) != null) {
                    name = ja.getJsonObject(0).getString("text");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (name == null) {
                return null;
            }
            boolean process = names == null ? true : true;
            String alias = null;
            if (names != null) {
                alias = names.get(name);
            }
            if (process) {
                if (vdecl.size() > 2) {
                    JsonObject def = vdecl.getJsonObject(2);
                    if (def == null) {
                        ExpNode exp = new ExpNode();
                        exp.type = type;
                        exp.name = name;
                        return exp;
                    }
                    JsonArray jarr = def.getJsonArray("classExpression");
                    if (jarr != null) {
                        ExpNode exp = AntlrAstParser.processClass(jarr, exps, names, comments, lines, name);
                        if (exp != null) {
                            exp.name = name;
                            exp.type = "var_class";
                            return exp;
                        }
                    } else {
                        jarr = def.getJsonArray("functionExpression");
                        if (jarr != null) {
                            ExpNode exp = AntlrAstParser.processFunctionExpression(jarr, exps, names, comments, lines, name);
                            if (exp != null) {
                                exp.name = name;
                                exp.type = "var_function";
                                return exp;
                            }
                        } else {
                            jarr = def.getJsonArray("objectLiteralExpression");
                            if (jarr == null) {
                                ExpNode exp = new ExpNode();
                                exp.name = name;
                                return exp;
                            }
                            ExpNode exp = AntlrAstParser.processObjectLiteralExpression(jarr, names);
                            if (exp != null) {
                                exp.name = name;
                                if (exp.expItems != null && exp.expItems.size() > 0) {
                                    exp.type = "exportIndirect";
                                }
                                return exp;
                            }
                        }
                    }
                }
                ExpNode exp = new ExpNode();
                exp.type = type;
                exp.name = name;
                return exp;
            }
        }
        return null;
    }

    static ExpNode processObjectLiteralExpression(JsonArray arf, Map<String, String> names) {
        return AntlrAstParser.processObjectLiteralExpression(arf, names, false);
    }

    static ExpNode processObjectLiteralExpression(JsonArray arf, Map<String, String> names, boolean for_import) {
        JsonArray arr;
        if (arf != null && (arr = arf.getJsonObject(0).getJsonArray("objectLiteral")) != null) {
            ExpNode exp = new ExpNode();
            exp.expItems = new ArrayList<String>();
            for (JsonValue jo : arr) {
                if (!(jo instanceof JsonObject)) continue;
                JsonObject job = (JsonObject)jo;
                JsonArray decl = job.getJsonArray("propertyExpressionAssignment");
                try {
                    JsonArray are;
                    if (decl != null && decl.size() > 2) {
                        String name = null;
                        String alias = null;
                        try {
                            JsonArray ar2;
                            JsonArray ar1;
                            JsonArray are2 = decl.getJsonObject(0).getJsonArray("propertyName");
                            if (are2 != null && (ar1 = are2.getJsonObject(0).getJsonArray("identifierName")) != null && (ar2 = ar1.getJsonObject(0).getJsonArray("identifier")) != null) {
                                alias = ar2.getJsonObject(0).getString("text");
                            }
                            if ((are2 = decl.getJsonObject(2).getJsonArray("identifierExpression")) != null) {
                                name = are2.getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (alias == null || name == null) continue;
                        if (for_import) {
                            exp.expItems.add(alias + " as " + name);
                        } else {
                            exp.expItems.add(name + " as " + alias);
                        }
                        if (names == null) continue;
                        names.put(name, alias);
                        continue;
                    }
                    decl = job.getJsonArray("propertyShorthand");
                    if (decl == null || (are = decl.getJsonObject(0).getJsonArray("identifierExpression")) == null) continue;
                    String name = are.getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                    exp.expItems.add(name + " as " + name);
                    if (names == null) continue;
                    names.put(name, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return exp;
        }
        return null;
    }

    static void processExportDeclaration(JsonArray ar, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        if (ar != null) {
            JsonArray decl = null;
            int count = ar.size();
            for (int j = 1; j < count; ++j) {
                JsonArray are;
                ExpNode exp;
                JsonObject jo = ar.getJsonObject(j);
                decl = jo.getJsonArray("declaration");
                if (decl != null) {
                    JsonArray arf = decl.getJsonObject(0).getJsonArray("functionDeclaration");
                    if (arf != null) {
                        exp = AntlrAstParser.processFunctionDeclaration(arf, exps, null, comments, lines, null);
                        if (exp == null) continue;
                        exps.add(exp);
                        continue;
                    }
                    arf = decl.getJsonObject(0).getJsonArray("variableStatement");
                    if (arf != null) {
                        exp = AntlrAstParser.processVariableStatement(arf, exps, null, comments, lines);
                        if (exp == null) continue;
                        exps.add(exp);
                        continue;
                    }
                    arf = decl.getJsonObject(0).getJsonArray("variableDeclaration");
                    if (arf != null) {
                        exp = AntlrAstParser.processVariableDeclaration(arf, exps, null, comments, lines);
                        if (exp == null) continue;
                        exps.add(exp);
                        continue;
                    }
                    arf = decl.getJsonObject(0).getJsonArray("classDeclaration");
                    if (arf == null || (exp = AntlrAstParser.processClass(arf, exps, null, comments, lines, null)) == null) continue;
                    exps.add(exp);
                    continue;
                }
                decl = jo.getJsonArray("exportFromBlock");
                if (decl != null) {
                    JsonArray imp2;
                    are = decl.getJsonObject(0).getJsonArray("moduleItems");
                    if (are != null) {
                        exp = new ExpNode();
                        exps.add(exp);
                        exp.expItems = new ArrayList<String>();
                        exp.type = "exportItems";
                        for (JsonValue p : are) {
                            JsonArray po = ((JsonObject)p).getJsonArray("aliasName");
                            if (po == null) continue;
                            int pos = po.size();
                            Object name = po.getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                            if (pos > 2) {
                                String alias;
                                JsonObject id_ob = po.getJsonObject(2).getJsonArray("identifierName").getJsonObject(0);
                                JsonArray iar = id_ob.getJsonArray("identifier");
                                if (iar != null) {
                                    alias = iar.getJsonObject(0).getString("text");
                                    if (alias != null) {
                                        name = (String)name + " as " + alias;
                                    }
                                } else {
                                    try {
                                        iar = id_ob.getJsonArray("reservedWord");
                                        if (iar != null && (alias = iar.getJsonObject(0).getJsonArray("keyword").getJsonObject(0).getString("text")) != null) {
                                            name = (String)name + " as " + alias;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            exp.expItems.add((String)name);
                        }
                        try {
                            imp2 = decl.getJsonObject(1).getJsonArray("importFrom");
                            if (imp2 == null) continue;
                            exp.imp_name = imp2.getJsonObject(1).getString("text");
                            exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                            exp.type = "exportItemsFromModule";
                        }
                        catch (Exception imp2) {}
                        continue;
                    }
                    are = decl.getJsonObject(0).getJsonArray("importNamespace");
                    if (are == null) continue;
                    exp = new ExpNode();
                    exps.add(exp);
                    exp.type = "exportNamespace";
                    exp.scope = are.getJsonObject(0).getString("text");
                    try {
                        imp2 = decl.getJsonObject(1).getJsonArray("importFrom");
                        if (imp2 == null) continue;
                        exp.imp_name = imp2.getJsonObject(1).getString("text");
                        exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                        exp.type = "exportNamespaceFromModule";
                    }
                    catch (Exception imp3) {}
                    continue;
                }
                decl = jo.getJsonArray("exportDefaultDeclaration");
                if (decl == null || (are = decl.getJsonObject(2).getJsonArray("identifierExpression")) == null) continue;
                String name = are.getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                ExpNode exp2 = new ExpNode();
                exps.add(exp2);
                exp2.type = "exportDefault";
                exp2.name = name;
            }
        }
    }

    static void processImports(JsonObject jdoc, List<ExpNode> imps) {
        JsonArray ja = jdoc.getJsonArray("imports");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                JsonObject job = ja.getJsonObject(i);
                JsonArray ar = job.getJsonArray("variableStatement");
                if (ar != null) {
                    ExpNode exp = AntlrAstParser.processImportVariableStatement(ar);
                    if (exp == null) continue;
                    imps.add(exp);
                    continue;
                }
                ar = job.getJsonArray("importStatement");
                if (ar != null) {
                    JsonArray decl = null;
                    int count = ar.size();
                    for (int j = 1; j < count; ++j) {
                        JsonArray imp;
                        ExpNode exp;
                        JsonObject jo = ar.getJsonObject(j);
                        decl = jo.getJsonArray("importFromBlock");
                        if (decl == null || decl.size() <= 0) continue;
                        JsonObject obj = decl.getJsonObject(0);
                        JsonArray are = null;
                        if (obj != null) {
                            are = obj.getJsonArray("moduleItems");
                        }
                        if (are != null) {
                            exp = new ExpNode();
                            imps.add(exp);
                            exp.expItems = new ArrayList<String>();
                            exp.type = "importItems";
                            for (JsonValue p : are) {
                                String alias;
                                JsonArray po = ((JsonObject)p).getJsonArray("aliasName");
                                if (po == null) continue;
                                int pos = po.size();
                                Object name = po.getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                                if (pos > 2 && (alias = po.getJsonObject(2).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text")) != null) {
                                    name = (String)name + " as " + alias;
                                }
                                exp.expItems.add((String)name);
                            }
                            try {
                                imp = decl.getJsonObject(1).getJsonArray("importFrom");
                                if (imp == null) continue;
                                exp.imp_name = imp.getJsonObject(1).getString("text");
                                exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                            }
                            catch (Exception imp2) {}
                            continue;
                        }
                        are = decl.getJsonObject(0).getJsonArray("importNamespace");
                        if (are == null) continue;
                        exp = new ExpNode();
                        imps.add(exp);
                        try {
                            JsonObject jid = are.getJsonObject(0);
                            JsonArray id_ar = jid.getJsonArray("identifierName");
                            if (id_ar != null) {
                                exp.type = "importItems";
                                String impname = id_ar.getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                                exp.expItems = new ArrayList<String>();
                                String name = "default as " + impname;
                                exp.expItems.add(name);
                            } else {
                                exp.scope = are.getJsonObject(0).getString("text");
                                exp.type = "importNamespace";
                                if (are.size() > 2) {
                                    exp.imp_alias = are.getJsonObject(2).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        try {
                            imp = decl.getJsonObject(1).getJsonArray("importFrom");
                            if (imp == null) continue;
                            exp.imp_name = imp.getJsonObject(1).getString("text");
                            exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                JsonArray jar = job.getJsonArray("importExpression");
                if (jar == null) continue;
                String module = jar.getJsonObject(2).getJsonArray("literalExpression").getJsonObject(0).getJsonArray("literal").getJsonObject(0).getString("text");
                ExpNode exp = new ExpNode();
                imps.add(exp);
                exp.type = "importNamespace";
                exp.scope = "*";
                exp.imp_name = module;
                exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                exp.setDynamicImport(true);
            }
        }
    }

    static ExpNode processImportVariableStatement(JsonArray arf) {
        ExpNode exp;
        JsonArray var = arf.getJsonObject(0).getJsonArray("variableDeclarationList");
        JsonArray vdecl = var.getJsonObject(1).getJsonArray("variableDeclaration");
        if (vdecl != null && (exp = AntlrAstParser.processImportVariableDeclaration(vdecl)) != null) {
            try {
                JsonObject job;
                JsonArray var_m;
                JsonValue ie = AntlrAstParser.getChildWithName(vdecl, "importExpression");
                if (ie != null && ie instanceof JsonArray) {
                    String module;
                    JsonArray jar = (JsonArray)ie;
                    exp.imp_name = module = jar.getJsonObject(2).getJsonArray("literalExpression").getJsonObject(0).getJsonArray("literal").getJsonObject(0).getString("text");
                    exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                    exp.setDynamicImport(true);
                }
                if ((var_m = (job = var.getJsonObject(0)).getJsonArray("varModifier")) != null) {
                    JsonValue val = (JsonValue)var_m.getJsonObject(0).get((Object)"text");
                    if (val != null) {
                        exp.subtype = val.toString();
                        exp.subtype = MLEJS_Util.getName(exp.subtype);
                    } else {
                        JsonArray valarr = var_m.getJsonObject(0).getJsonArray("let_");
                        if (valarr != null) {
                            exp.subtype = valarr.getJsonObject(0).getString("text");
                            exp.subtype = MLEJS_Util.getName(exp.subtype);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return exp;
        }
        return null;
    }

    static JsonValue getChildWithName(JsonArray arr, String name) {
        for (JsonValue val : arr) {
            JsonValue t;
            if (val instanceof JsonObject) {
                JsonObject obj = (JsonObject)val;
                JsonValue t2 = AntlrAstParser.getChildWithName(obj, name);
                if (t2 == null) continue;
                return t2;
            }
            if (!(val instanceof JsonArray) || (t = AntlrAstParser.getChildWithName((JsonArray)val, name)) == null) continue;
            return t;
        }
        return null;
    }

    static JsonValue getChildWithName(JsonObject jobj, String name) {
        JsonValue t = (JsonValue)jobj.get((Object)name);
        if (t != null) {
            return t;
        }
        for (JsonValue val : jobj.values()) {
            if (!(val instanceof JsonArray ? (t = AntlrAstParser.getChildWithName((JsonArray)val, name)) != null : val instanceof JsonObject && (t = AntlrAstParser.getChildWithName((JsonObject)val, name)) != null)) continue;
            return t;
        }
        return null;
    }

    static ExpNode processImportVariableDeclaration(JsonArray vdecl) {
        if (vdecl != null) {
            String name = null;
            ExpNode exp = null;
            try {
                JsonArray jar = vdecl.getJsonObject(0).getJsonArray("assignable");
                if (jar != null && jar.size() > 0) {
                    JsonArray ja = jar.getJsonObject(0).getJsonArray("identifier");
                    if (ja != null) {
                        name = ja.getJsonObject(0).getString("text");
                        exp = new ExpNode();
                        exp.type = "importNamespace";
                        exp.scope = "*";
                        exp.imp_alias = name;
                        return exp;
                    }
                    JsonArray jarr = jar.getJsonObject(0).getJsonArray("objectLiteral");
                    if (jarr != null && (exp = AntlrAstParser.processObjectLiteralExpression(jar, null, true)) != null) {
                        exp.type = "importItems";
                        return exp;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static void processFunctions(JsonObject jdoc, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        JsonArray ja = jdoc.getJsonArray("functions");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                ExpNode exp;
                JsonObject job = ja.getJsonObject(i);
                JsonArray arf = job.getJsonArray("functionDeclaration");
                if (arf != null) {
                    ExpNode exp2 = AntlrAstParser.processFunctionDeclaration(arf, exps, names, comments, lines, null);
                    if (exp2 == null) continue;
                    exps.add(exp2);
                    continue;
                }
                JsonArray vdecl = job.getJsonArray("variableDeclaration");
                if (vdecl == null || (exp = AntlrAstParser.processVariableDeclaration(vdecl, exps, names, comments, lines)) == null) continue;
                exps.add(exp);
            }
        }
    }

    static ExpNode processFunctionExpression(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            JsonArray arr = arf.getJsonObject(0).getJsonArray("functionDecl");
            if (arr != null) {
                JsonArray decl = arr.getJsonObject(0).getJsonArray("functionDeclaration");
                if (decl != null) {
                    return AntlrAstParser.processFunctionDeclaration(decl, exps, names, comments, lines, varName);
                }
            } else {
                arr = arf.getJsonObject(0).getJsonArray("anonymousFunctionDecl");
                if (arr != null) {
                    return AntlrAstParser.processFunctionDeclaration(arr, exps, names, comments, lines, varName);
                }
                arr = arf.getJsonObject(0).getJsonArray("arrowFunction");
                if (arr != null) {
                    return AntlrAstParser.processArrowFunction(arr, exps, names, comments, lines, varName);
                }
            }
        }
        return null;
    }

    static ExpNode processFunctionDeclaration(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            FuncHelp hlp = AntlrAstParser.getFuncType(arf);
            int start = hlp.start;
            int stop = hlp.stop;
            int k = hlp.count + 1;
            JsonArray identif = arf.getJsonObject(k).getJsonArray("identifier");
            String name = "";
            if (identif != null) {
                name = identif.getJsonObject(0).getString("text");
            }
            boolean process = names == null;
            String alias = null;
            if (names != null) {
                alias = varName != null ? names.get(varName) : names.get(name);
                boolean bl = process = alias != null;
            }
            if (process) {
                int arfs;
                ExpNode exp = new ExpNode();
                exp.type = "function";
                if (hlp.async) {
                    exp.subtype = "async";
                }
                if (alias != null) {
                    exp.name = alias;
                    exp.name_in_code = name;
                } else {
                    exp.name = name;
                }
                ImpExpVisitor.Comment c = comments.get(start - 1);
                if (c != null) {
                    exp.comment = c.comment;
                }
                if (names != null) {
                    if (varName != null) {
                        names.remove(varName);
                    } else {
                        names.remove(name);
                    }
                }
                if (lines != null) {
                    exp.code = ImpExpVisitor.getCode(lines, start, stop);
                }
                if ((arfs = arf.size()) > 4) {
                    JsonArray par = arf.getJsonObject(3).getJsonArray("formalParameterList");
                    if (par == null) {
                        par = AntlrAstParser.getJsonArraybyNameInObject(arf, "formalParameterList");
                    }
                    if (par != null) {
                        exp.params = new ArrayList<ExpNode.Param>();
                        for (JsonValue p : par) {
                            JsonArray po = ((JsonObject)p).getJsonArray("formalParameterArg");
                            if (po == null) continue;
                            String pname = po.getJsonObject(0).getJsonArray("assignable").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                            ExpNode.Param param = new ExpNode.Param();
                            param.name = pname;
                            exp.params.add(param);
                        }
                    }
                }
                return exp;
            }
        }
        return null;
    }

    static JsonArray getJsonArraybyNameInObject(JsonArray jar, String propName) {
        if (jar != null && propName != null && !propName.isEmpty()) {
            for (int i = 0; i < jar.size(); ++i) {
                JsonObject job = jar.getJsonObject(i);
                JsonArray ar = job.getJsonArray(propName);
                if (ar == null) continue;
                return ar;
            }
        }
        return null;
    }

    static ExpNode processArrowFunction(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            int k = 0;
            JsonArray fparam = arf.getJsonObject(k).getJsonArray("arrowFunctionParameters");
            if (fparam != null) {
                ++k;
            }
            int start = arf.getJsonObject(k).getInt("start");
            int stop = arf.getJsonObject(k).getInt("stop");
            boolean process = true;
            if (process) {
                JsonArray par;
                ExpNode exp = new ExpNode();
                exp.name = "";
                exp.type = "function";
                ImpExpVisitor.Comment c = comments.get(start - 1);
                if (c != null) {
                    exp.comment = c.comment;
                }
                if (names != null && varName != null) {
                    names.remove(varName);
                }
                if (lines != null) {
                    exp.code = ImpExpVisitor.getCode(lines, start, stop);
                }
                if ((par = fparam.getJsonObject(1).getJsonArray("formalParameterList")) != null) {
                    exp.params = new ArrayList<ExpNode.Param>();
                    for (JsonValue p : par) {
                        JsonArray po = ((JsonObject)p).getJsonArray("formalParameterArg");
                        if (po == null) continue;
                        String pname = po.getJsonObject(0).getJsonArray("assignable").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                        ExpNode.Param param = new ExpNode.Param();
                        param.name = pname;
                        exp.params.add(param);
                    }
                }
                return exp;
            }
        }
        return null;
    }

    static void processClasses(JsonObject jdoc, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        JsonArray ja = jdoc.getJsonArray("classes");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                ExpNode exp;
                JsonObject job = ja.getJsonObject(i);
                JsonArray arf = job.getJsonArray("classDeclaration");
                if (arf != null) {
                    ExpNode exp2 = AntlrAstParser.processClass(arf, exps, names, comments, lines, null);
                    if (exp2 == null) continue;
                    exps.add(exp2);
                    continue;
                }
                JsonArray jarr = job.getJsonArray("variableDeclaration");
                if (jarr == null || (exp = AntlrAstParser.processVariableDeclaration(jarr, exps, names, comments, lines)) == null) continue;
                exp.type = "var_class";
                exps.add(exp);
            }
        }
    }

    static ExpNode processClass(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            boolean process;
            int start = arf.getJsonObject(0).getInt("start");
            int stop = arf.getJsonObject(0).getInt("stop");
            int k = 1;
            String alias = null;
            JsonArray identif = arf.getJsonObject(k).getJsonArray("identifier");
            String name = "";
            if (identif != null) {
                name = identif.getJsonObject(0).getString("text");
                ++k;
            }
            boolean bl = process = names == null;
            if (names != null) {
                alias = varName != null ? names.get(varName) : names.get(name);
                boolean bl2 = process = alias != null;
            }
            if (process) {
                JsonArray par;
                ExpNode exp = new ExpNode();
                exp.type = "class";
                if (alias != null) {
                    exp.name_in_code = name;
                    exp.name = alias;
                } else {
                    exp.name = name;
                }
                ImpExpVisitor.Comment c = comments.get(start - 1);
                if (c != null) {
                    exp.comment = c.comment;
                }
                if (lines != null) {
                    exp.code = ImpExpVisitor.getCode(lines, start, stop);
                }
                if (names != null) {
                    if (varName != null) {
                        names.remove(varName);
                    } else {
                        names.remove(name);
                    }
                }
                if ((par = arf.getJsonObject(k).getJsonArray("classTail")) != null) {
                    JsonValue val = (JsonValue)par.getJsonObject(0).get((Object)"text");
                    if (val != null) {
                        try {
                            String txt = val.toString();
                            if ("\"extends\"".equals(txt)) {
                                String cname;
                                exp.extendsClass = cname = par.getJsonObject(1).getJsonArray("identifierExpression").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    exp.methods = new ArrayList<ExpNode>();
                    for (JsonValue p : par) {
                        ExpNode elem;
                        JsonArray po = ((JsonObject)p).getJsonArray("classElement");
                        if (po == null || (elem = AntlrAstParser.processClassElement(po, exps, comments, lines, start = arf.getJsonObject(0).getInt("start"), stop = arf.getJsonObject(0).getInt("stop"))) == null) continue;
                        if (elem.type.startsWith("method")) {
                            if (exp.methods == null) {
                                exp.methods = new ArrayList<ExpNode>();
                            }
                            exp.methods.add(elem);
                            continue;
                        }
                        if (!elem.type.startsWith("property")) continue;
                        if (exp.properties == null) {
                            exp.properties = new ArrayList<ExpNode>();
                        }
                        exp.properties.add(elem);
                    }
                }
                return exp;
            }
        }
        return null;
    }

    static ExpNode processClassElement(JsonArray arf, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, int start, int stop) {
        if (arf != null && arf.size() > 0) {
            ExpNode exp;
            FuncHelp fh = AntlrAstParser.getClassElementSubType(arf);
            int count = 0;
            String ce_sub = "";
            if (fh != null) {
                ce_sub = fh.type;
                count = fh.count;
            }
            if ((exp = AntlrAstParser.processMethod(arf, exps, comments, lines, start, stop, count)) == null) {
                exp = AntlrAstParser.procesProperty(arf, exps, comments, lines, start, stop, count);
            }
            if (exp != null) {
                exp.subtype = ce_sub == null ? exp.subtype : (exp.subtype == null ? ce_sub : ce_sub + "_" + exp.subtype);
            }
            return exp;
        }
        return null;
    }

    static ExpNode procesProperty(JsonArray arf, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, int start, int stop, int startIndex) {
        JsonArray mdef = arf.getJsonObject(startIndex).getJsonArray("propertyName");
        ExpNode exp = null;
        if (mdef != null) {
            ImpExpVisitor.Comment c;
            JsonArray jar;
            int k = startIndex;
            JsonObject obj = mdef.getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0);
            String name = obj.getString("text");
            try {
                start = obj.getInt("start");
                stop = obj.getInt("stop");
            }
            catch (Exception exception) {
                // empty catch block
            }
            JsonObject job = arf.getJsonObject(k += 2);
            if (job.containsKey((Object)"functionExpression")) {
                jar = job.getJsonArray("functionExpression");
                exp = AntlrAstParser.processFunctionExpression(jar, exps, null, comments, lines, null);
            } else if (job.containsKey((Object)"classExpression")) {
                jar = job.getJsonArray("classExpression");
                exp = AntlrAstParser.processClass(jar, exps, null, comments, lines, null);
            }
            if (exp != null) {
                exp.type = "property" + (String)(exp.type == null ? "" : "_" + exp.type);
                if (name != null) {
                    exp.name = name;
                }
            } else {
                exp = new ExpNode();
                exp.name = name;
                exp.type = "property";
            }
            if ((c = comments.get(start - 1)) != null) {
                exp.comment = c.comment;
            }
        }
        return exp;
    }

    static ExpNode processMethod(JsonArray arf, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, int start, int stop, int startIndex) {
        JsonArray mdef = arf.getJsonObject(startIndex).getJsonArray("methodDefinition");
        if (mdef != null) {
            JsonArray par;
            int arfs;
            JsonNumber val = arf.getJsonObject(0).getJsonNumber("start");
            if (val != null) {
                start = val.intValue();
                val = arf.getJsonObject(0).getJsonNumber("stop");
                if (val != null) {
                    stop = val.intValue();
                }
            }
            int k = 0;
            FuncHelp fh = AntlrAstParser.getSubType(mdef);
            k = fh.count;
            String name = "";
            String typeExt = null;
            String subType = fh.type;
            JsonObject kind = mdef.getJsonObject(k);
            JsonObject obj = null;
            if (kind.containsKey((Object)"propertyName")) {
                obj = kind.getJsonArray("propertyName").getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0);
                name = obj.getString("text");
            } else if (kind.containsKey((Object)"setter")) {
                obj = kind.getJsonArray("setter").getJsonObject(1).getJsonArray("propertyName").getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0);
                name = obj.getString("text");
                typeExt = "setter";
            } else if (kind.containsKey((Object)"getter")) {
                obj = kind.getJsonArray("getter").getJsonObject(1).getJsonArray("propertyName").getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0);
                name = obj.getString("text");
                typeExt = "getter";
            }
            if (obj != null) {
                try {
                    start = obj.getInt("start");
                    stop = obj.getInt("stop");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ExpNode exp = new ExpNode();
            exp.type = "method";
            exp.subtype = subType;
            if (typeExt != null) {
                exp.type = exp.type + "_" + typeExt;
            }
            exp.name = name;
            ImpExpVisitor.Comment c = comments.get(start - 1);
            if (c != null) {
                exp.comment = c.comment;
            }
            if ((arfs = mdef.size()) > k + 2 && (par = mdef.getJsonObject(k += 2).getJsonArray("formalParameterList")) != null) {
                exp.params = new ArrayList<ExpNode.Param>();
                for (JsonValue p : par) {
                    JsonArray po = ((JsonObject)p).getJsonArray("formalParameterArg");
                    if (po == null) continue;
                    String pname = po.getJsonObject(0).getJsonArray("assignable").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                    ExpNode.Param param = new ExpNode.Param();
                    param.name = pname;
                    exp.params.add(param);
                }
            }
            return exp;
        }
        return null;
    }

    public static ModuleMetadata getModuleMetaDataFromJSON(String json) {
        if (json != null && !json.isEmpty()) {
            ModuleMetadata moduleMetadata;
            ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8.name()));
            try {
                JsonObject jdoc = ImpExpVisitor.JSF.createReader((InputStream)stream).readObject();
                ModuleMetadata obj = new ModuleMetadata();
                JSONToPropertiesObject tr = new JSONToPropertiesObject();
                JsonObject mobj = jdoc.getJsonObject(ModuleMetadata._METADATA);
                if (mobj == null) {
                    mobj = jdoc;
                }
                tr.processProperties(obj, mobj);
                moduleMetadata = obj;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
            ((InputStream)stream).close();
            return moduleMetadata;
        }
        return null;
    }

    public static ModuleMetadata.AllMetadata getAllMetaDataFromJSON(String json) {
        if (json != null && !json.isEmpty()) {
            ModuleMetadata.AllMetadata allMetadata;
            ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8.name()));
            try {
                JsonObject jdoc = ImpExpVisitor.JSF.createReader((InputStream)stream).readObject();
                ModuleMetadata.AllMetadata allmeta = new ModuleMetadata.AllMetadata();
                ModuleMetadata obj = new ModuleMetadata();
                JSONToPropertiesObject tr = new JSONToPropertiesObject();
                JsonObject mobj = jdoc.getJsonObject(ModuleMetadata._METADATA);
                if (mobj == null) {
                    tr.processProperties(obj, jdoc);
                } else {
                    tr.processProperties(obj, mobj);
                    tr.processProperties(allmeta, jdoc);
                }
                allmeta.metadata = obj;
                allMetadata = allmeta;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
            ((InputStream)stream).close();
            return allMetadata;
        }
        return null;
    }

    public static String getMetadataFromJS(String code) {
        ModuleMetadata meta = AntlrAstParser.getModuleMetadataFromJS(code);
        if (meta != null) {
            String res = AntlrAstParser.toJsonMetadata(meta.exports, meta.imports, meta.notResolved);
            return res;
        }
        return null;
    }

    public static String getMetadataFromJS(ModuleMetadata meta) {
        if (meta != null) {
            String res = AntlrAstParser.toJsonMetadata(meta.exports, meta.imports, meta.notResolved);
            return res;
        }
        return null;
    }

    public static String toJsonMetadata(List<ExpNode> exps, List<ExpNode> imps, List<ExpNode> notResolved) {
        ExpNode.StringAdd s = new ExpNode.StringAdd();
        s.addText("{");
        s.addText(AntlrAstParser.listToJson("exports", exps, 1));
        s.addText(",").addText(AntlrAstParser.listToJson("imports", imps, 1));
        if (notResolved.size() > 0) {
            s.addText(",").addText(AntlrAstParser.listToJson("notResolved", notResolved, 1));
        }
        s.addNL().addText("}");
        return s.toString();
    }

    public static String toJsonMetadata(String name, List<ExpNode> list) {
        ExpNode.StringAdd s = new ExpNode.StringAdd();
        s.addText("{");
        s.addText(AntlrAstParser.listToJson(name, list, 1));
        s.addNL().addText("}");
        return s.toString();
    }

    public static void createPossibleImports(List<ExpNode> notResolved, Map<String, String> names) {
        for (Map.Entry<String, String> val : names.entrySet()) {
            ExpNode exp = new ExpNode();
            exp.type = "exportPossibleImport";
            exp.name_in_code = val.getKey();
            exp.name = val.getValue();
            notResolved.add(exp);
        }
        names.clear();
    }

    static void addExportedVars(List<ExpNode> exps, Map<String, String> names) {
        for (String key : names.keySet()) {
            ExpNode exp = new ExpNode();
            exps.add(exp);
            exp.type = "var";
            exp.name = key;
        }
    }

    static void addExportItems(List<String> items, Map<String, String> names) {
        if (items != null && items.size() > 0) {
            for (String name : items) {
                String[] parts;
                String alias = name = name.strip();
                if (name.indexOf(" as ") > 0 && (parts = name.split(" as ")).length == 2) {
                    name = parts[0];
                    alias = parts[1];
                }
                names.put(name, alias);
            }
        }
    }

    static FuncHelp getClassElementSubType(JsonArray mdef) {
        if (mdef != null && mdef.size() > 0) {
            int k = 0;
            Object subType = null;
            JsonObject kind = mdef.getJsonObject(k);
            while (kind.containsKey((Object)"text") || kind.containsKey((Object)"identifier")) {
                String val;
                if (kind.containsKey((Object)"text")) {
                    val = kind.getString("text");
                    String str = val.toString();
                    if ("static".equals(str)) {
                        subType = subType != null ? subType + "_static" : "static";
                    } else if ("async".equals(str)) {
                        subType = subType != null ? (String)subType + "_async" : "async";
                    } else if ("#".equals(str)) {
                        subType = subType != null ? (String)subType + "_private" : "private";
                    } else if ("*".equals(str)) {
                        subType = subType != null ? (String)subType + "_generator" : "generator";
                    }
                } else if (kind.containsKey((Object)"identifier")) {
                    val = kind.getJsonArray("identifier").getJsonObject(0).getString("text");
                    subType = subType != null ? (String)subType + "_" + val : val;
                }
                kind = mdef.getJsonObject(++k);
            }
            FuncHelp fh = new FuncHelp();
            fh.type = subType;
            fh.count = k;
            return fh;
        }
        return null;
    }

    static FuncHelp getFuncType(JsonArray arf) {
        JsonValue jv;
        FuncHelp hlp = new FuncHelp();
        int k = 0;
        String val = arf.getJsonObject(k).getString("text");
        if (val != null && "async".equalsIgnoreCase(val)) {
            hlp.async = true;
            k = 1;
        }
        if (k == 1) {
            val = arf.getJsonObject(k).getString("text");
        }
        if ("function".equalsIgnoreCase(val)) {
            hlp.start = arf.getJsonObject(k).getInt("start");
            hlp.stop = arf.getJsonObject(k).getInt("stop");
        }
        if ((jv = (JsonValue)arf.getJsonObject(++k).get((Object)"text")) != null) {
            val = jv.toString();
            if ("*".equals(val)) {
                hlp.generator = true;
                ++k;
            }
        } else {
            --k;
        }
        hlp.count = k;
        return hlp;
    }

    static FuncHelp getSubType(JsonArray mdef) {
        if (mdef != null) {
            int k = 0;
            Object subType = null;
            JsonObject kind = mdef.getJsonObject(k);
            while (kind.containsKey((Object)"text")) {
                String val = kind.getString("text");
                String str = val.toString();
                if ("#".equals(str)) {
                    subType = subType != null ? subType + "_private" : "private";
                } else if ("*".equals(str)) {
                    subType = subType != null ? (String)subType + "_private" : "generator";
                }
                kind = mdef.getJsonObject(++k);
            }
            FuncHelp fh = new FuncHelp();
            fh.type = subType;
            fh.count = k;
            return fh;
        }
        return null;
    }

    static class FuncHelp {
        boolean async;
        boolean generator;
        boolean private_def;
        boolean static_def;
        String identifier;
        String type;
        int count = 0;
        int start = -1;
        int stop = -1;

        FuncHelp() {
        }
    }
}

